S0	EQU	$10	; Anzeigestelle S0
S1	EQU	$11	; aktueller Ausgabewert
S2	EQU	$12	; Anzeigestelle S2
PUFFER	EQU	$0	; Anzeigepuffer
ZAEHLER EQU	$0000	; Zhler in Speicherstelle 0
PAUSE	EQU	$0004	; Zhler fr Pause
INT_CB1	EQU	$0038	; Interrupt-Vektor fr CB1
INT_CB2	EQU	$003C	; Interrupt-Vektor fr CB2
INT_Z3	EQU	$002E	; Interrupt-Vektor fr Timer #3
SR_Z1	EQU	$F018	; Steuerregister Timer #1
SR_Z3	EQU	$F018	; Steuerregister Timer #3
SR_Z2	EQU	$F019	; Steuerregister Timer #2
STREG	EQU	$F019	; Timer-Statusregister
DRB	EQU	$F002	; Datenregister Port PB
DDRB	EQU	$F002	; Datenrichtungsregister Port PB
CRB	EQU	$F003	; Steuerregister Port PB 
CLRDISP	EQU	$F110	; Anzeige lschen
SHOWA	EQU	$F113
LATCH_Z3 EQU	$F01E	; Latches fr Timer #3
SHOWD	EQU	$F116
SHOWT7SG EQU	$F11C	; Tetrade im 7-Segment-Code darstellen
SHOWB7SG EQU	$F120	; 2-tetraden im 7-Segment-Code darstellen
SHOWD7SG EQU	$F123	; 4-Tetraden im 7-Segment-Code darstellen
SHOWDBUF EQU	$F133	; Puffer in Anzeige
KEY	EQU	$F140	; Tastaturabfrage ohne Halt
HALTKEY	EQU	$F143	; Halten und Tastatur abfragen
INDATA	EQU	$F14C
SHOWDATA EQU	$F150
DLY1MS	EQU	$F160	; 1 ms verzgern

COUNT	EQU	$0
MODE	EQU	$2

	ORG	$0400	; Programmzhler auf $0400 stellen
START	JSR	CLRDISP	; Anzeige lschen
	LDD	#INTZ3	; Beginn der Interruptroutine zu Timer #3 laden und 
	STD	<INT_Z3	; in den Interrupt-Vektor zu Timer #3 bringen
	LDD	#INTCB1
	STD	<INT_CB1
	LDD	#INTCB2
	STD	<INT_CB2

			; Port B initialisieren
	CLR	CRB
	LDA	#$FF
	STA	DDRB
	LDA	#$0D
	STA	CRB
	
	CLR	SR_Z2	; Timer 3 initialisieren
	LDA	#$C3
	STA	<MODE
	STA	SR_Z3
	LDD	#$FFFF
	STD	LATCH_Z3
	LDA	#1
	STA	SR_Z2
	LDX	#0

LAUF	LDD	LATCH_Z3
	LDY	#$400
	JSR	DLY1MS
	CMPD	LATCH_Z3
	BNE	LAUF

	LDA	#1
	STA	SR_Z2
	STA	SR_Z1	; Zhler aus
	LDB	#$A
	JSR	SHOWT7SG


	BRA	LAUF


INTCB1	LDB	DRB
	LDA	#1
	STA	SR_Z2
	CLR	SR_Z1	; Zhler starten
	LDB	#$E
	LDX	#0
	JSR	SHOWT7SG
	RTI	

INTCB2	LDB	DRB
	LDA	<MODE
	EORA	#1
	STA	<MODE
	CLR	SR_Z2
	STA	SR_Z1
	
	RTI


	
INTZ3	PSHS	D,X,Y
	LDD	<COUNT
	ADDD	#1
	STD	<COUNT
	STB	DRB	
	LDX	#2
	JSR	SHOWD7SG
	LDA	STREG
	LDD	LATCH_Z3
	PULS	D,X,Y
	RTI


	END