S0	EQU	$10	; Anzeigestelle S0
S1	EQU	$11	; aktueller Ausgabewert
S2	EQU	$12	; Anzeigestelle S2
PUFFER	EQU	$0	; Anzeigepuffer
ZAEHLER EQU	$0000	; Zhler in Speicherstelle 0
PAUSE	EQU	$0004	; Zhler fr Pause
INT_CB1	EQU	$003C	; Interrupt-Vektor fr CB1
INT_Z3	EQU	$002E	; Interrupt-Vektor fr Timer #3
SR_Z1	EQU	$F018	; Steuerregister Timer #1
SR_Z3	EQU	$F018	; Steuerregister Timer #3
SR_Z2	EQU	$F019	; Steuerregister Timer #2
STREG	EQU	$F019	; Timer-Statusregister
DRB	EQU	$F002	; Datenregister Port PB
DDRB	EQU	$F002	; Datenrichtungsregister Port PB
CRB	EQU	$F003	; Steuerregister Port PB 
CLRDISP	EQU	$F110	; Anzeige lschen
LATCH_Z3 EQU	$F01E	; Latches fr Timer #3
SHOWT7SG EQU	$F11C	; Tetrade im 7-Segment-Code darstellen
SHOWB7SG EQU	$F120	; 2-tetraden im 7-Segment-Code darstellen
SHOWD7SG EQU	$F123	; 4-Tetraden im 7-Segment-Code darstellen
SHOWDBUF EQU	$F133	; Puffer in Anzeige
HALTKEY	EQU	$F143	; Halten und Tastatur abfragen
DLY1MS	EQU	$F160	; 1 ms verzgern

	ORG	$0400	; Programmzhler auf $0400 stellen
START	LDD	#INTZ3	; Beginn der Interruptroutine zu Timer #3 laden und 
	STD	INT_Z3	; in den Interrupt-Vektor zu Timer #3 bringen
	LDA	#$36	; Interrupt an CB1 deaktivieren, positive Flanke, DRB anwhlen, CB2 aus
	STA	CRB	; Steuerregister setzen
	LDA	#$C2	; (Belegung fr Trace erhalten)
	STA	SR_Z2	; Anwhlen von Steuerregister Timer #3
	LDA	#$C3	; Modus laden und
	STA	SR_Z3	; ins Steuerregister Timer #3 bringen
	STA	S0	; in S0 sichern
	LDD	#$FFFF	; $FFFF laden und
	STD	LATCH_Z3;  in die Latches von Timer #3 bringen
	LDA	#$C3	; (Trace erhalten) Steuerregister von 
	STA	SR_Z2	; Timer #1 anwhlen
	CLR	SR_Z1	; alle Timer starten
	LDA	#$2C	; (Trace erhalten)
	CLR	SR_Z2	; Steuerregister Timer #3 selektieren

ANFANG	JSR	CLRDISP	; Anzeige loeschen
			; wenn Timer lnger als 50 ms gestoppt, LED an CB2 an
LOOP	LDA	CRB	
	LDU	LATCH_Z3; Zhlerstand lesen
	LDY	#50	; 50 ms sec
	JSR	DLY1MS	; verzgern
	CMPU	LATCH_Z3; mit neuem Zhlerstand vergleichen
	BNE	L4	; ungleich, wenn Zhler nicht gestoppt
	ORA	#$08	; Zhler gestoppt, LED an CB2 an
	BRA	L3
L4	ANDA	#$F7	; Zhler nicht gestoppt, LED an CB2 aus
L3	STA	CRB
	BRA	LOOP	; 
	

			; Interrupt-Routine zu Timer #3	
INTZ3	PSHS	D,U,X
	LDB	CRB	; Test auf Interrupt an CB1
	BPL	WEITER	; weiter, falls kein Interrupt
	LDA	S0	; gerettetes Steuerwort lesen
	EORA	#$01	; Bit 0 toggeln: ':1 / :8'
	STA	S0	; und retten
	STA	SR_Z3	; und zum Steuerregister Timer #3

WEITER	LDA	S1	; Ausgabewert toggeln
	EORA	#$40	; dadurch Segment g ein/aus
	STA	S1
	LDU	#$8	; Zhler und Zeiger U initialisieren
	LDB	DRB	; Interrupt-Flag lschen, Maske lesen
	STB	S2	; und retten
AUS	LEAU	-1,U	; Zhler dekrementieren
	LDA	S1	; Ausgabewert S1 lesen
	LSL	S2	; Maskenbit testen
	BCS	L1	; weiter falls =1
	CLRA		; Ausgabewert lschen (=0)
L1	STA	,U	; und retten
	CMPU	#$0	; U auf Endwert ?
	BNE	AUS	; falls nein, nchsten Wert

	LDX	#$0	;
	JSR	SHOWDBUF; Puffer ausgeben
	LDB	STREG	; Interrupt lschen
	LDD	LATCH_Z3; Interrupt lschen
	PULS	D,U,X
	RTI		; Rcksprung


	END