S0	EQU	$10	; Anzeigestelle S0
S1	EQU	$11	; aktueller Ausgabewert
S2	EQU	$12	; Anzeigestelle S2
PUFFER	EQU	$0	; Anzeigepuffer
ZAEHLER EQU	$0000	; Zhler in Speicherstelle 0
PAUSE	EQU	$0004	; Zhler fr Pause
INT_CB1	EQU	$003C	; Interrupt-Vektor fr CB1
INT_Z3	EQU	$002E	; Interrupt-Vektor fr Timer #3
SR_Z1	EQU	$F018	; Steuerregister Timer #1
SR_Z3	EQU	$F018	; Steuerregister Timer #3
SR_Z2	EQU	$F019	; Steuerregister Timer #2
STREG	EQU	$F019	; Timer-Statusregister
DRB	EQU	$F002	; Datenregister Port PB
DDRB	EQU	$F002	; Datenrichtungsregister Port PB
CRB	EQU	$F003	; Steuerregister Port PB 
CLRDISP	EQU	$F110	; Anzeige lschen
LATCH_Z3 EQU	$F01E	; Latches fr Timer #3
SHOWT7SG EQU	$F11C	; Tetrade im 7-Segment-Code darstellen
SHOWB7SG EQU	$F120	; 2-tetraden im 7-Segment-Code darstellen
SHOWD7SG EQU	$F123	; 4-Tetraden im 7-Segment-Code darstellen
SHOWDBUF EQU	$F133	; Puffer in Anzeige
KEY	EQU	$F140	; Tastaturabfrage ohne Halt
HALTKEY	EQU	$F143	; Halten und Tastatur abfragen
DLY1MS	EQU	$F160	; 1 ms verzgern

	ORG	$0400	; Programmzhler auf $0400 stellen
START	LDD	#INTZ3	; Beginn der Interruptroutine zu Timer #3 laden und 
	STD	<INT_Z3	; in den Interrupt-Vektor zu Timer #3 bringen
	CLR	CRB
	LDA	#$FF
	STA	DDRB
	LDA	#$3C	; Interrupt an CB1 deaktivieren,  DRB anwhlen
	STA	CRB	; Steuerregister setzen
	CLR	SR_Z2	; Anwhlen von Steuerregister Timer #3
	LDA	#$C3	; Modus laden und
	STA	SR_Z3	; ins Steuerregister Timer #3 bringen
	STA	<S0	; in S0 sichern
	LDD	#$FFFF	; $FFFF laden und
	STD	LATCH_Z3;  in die Latches von Timer #3 bringen
	LDA	#$01	; Steuerregister von    
	STA	SR_Z2	; Timer #1 anwhlen
	CLR	SR_Z1	; alle Timer starten
	CLR	SR_Z2	; Steuerregister Timer #3 selektieren

ANFANG	JSR	CLRDISP	; Anzeige lschen

LOOP	LDA	<S0
	JSR	KEY	; Tastatur abfragen
	CMPB	#$80	; '+' gedrckt ?
	BNE	MINUS
	ORA	#$40	
	LDB	#$3C
	BRA	L5
MINUS	CMPB	#$81	; '-' gedrckt ?
	BNE	L6
	ANDA	#$BF
	LDB	#$34
L5	STB	CRB
	STA	<S0
	STA	SR_Z3	
	BRA	LOOP	;
L6	CMPB	#$0F
	BHI	LOOP
	LDX	#0
	TFR	B,A
	ANDA	#$08
	ANDB	#$07
	ABX
	STA	,X
	CLR	DRB
	BRA	LOOP
	
INTZ3	PSHS	D,U,X
WEITER	LDX	#8
	CLR	<S1
AUS	ANDCC	#$FE
	LDA	-1,X
	BEQ	L7
	ORCC	#$1
L7	ROL	<S1
	LEAX	-1,X
	BNE	AUS

	LDA	DRB
	ANDA	<S1
	EORA	<S1
	STA	DRB

	LDB	STREG	; Interrupt lschen
	LDD	LATCH_Z3; Interrupt lschen
	PULS	D,U,X
	RTI		; Rcksprung


	END