INTV_T1       EQU  $002C    ; Timer #1
INTV_T3       EQU $002E    ; Timer #3
INTV_CB1     EQU $0038    ; CB1
INTV_CB2     EQU $003C    ; CB2
INTV_CA1     EQU $0036    ; CA1, Taste F4
INTV_V24     EQU $0040    ; V.24-Schnittstelle
KEYB         EQU  $F010    ; Startadresse Tasten ($F010-$F016)
DISPL         EQU $F020    ; Startadresse Anzeige ($F020-$F02F)
DRA          EQU $F000    ; Datenregister Port PA
DDRA         EQU $F000    ; Datenrichtungsregister Port PA
CRA          EQU $F001    ; Steuerregister Port PA
DRB          EQU $F002    ; Datenregister Port PB
DDRB         EQU $F002    ; Datenrichtungsregister PB
CRB          EQU $F003    ; Steueregister Port PB
V24DATA       EQU $F008    ; Sende-/Empfangsregister
V24SR         EQU $F009    ; Statusregister
V24IR         EQU $F00A    ; Instruktionsregister
V24CR         EQU $F00B    ; Steuerregister
SR_T1         EQU $F018    ; Stuerregister Timer #1, SR_T20=1
SR_T3         EQU $F018    ; Steueregister Timer #3, SR_T20=0
SR_T2         EQU $F019    ; Steueregister Timer #2
STREG         EQU $F019    ; Statusregister Timer #1 - #3
LATCH_T1     EQU $F01A    ; Latch Timer #1
LATCH_T2     EQU $F01C    ; Latch Timer #2
LATCH_T3     EQU $F01E    ; Latch Timer #3


T7SG         EQU $F100    ; Tetrade in 7-Seg.-Code
B7SG         EQU $F103    ; Byte in 7-Seg.-Code
D7SG         EQU $F106    ; Wort in 7-Seg.-Code
CLRDISP       EQU $F110    ; Anzeige lschen
SHOWA         EQU $F113    ; Byte anzeigen
SHOWD         EQU $F116    ; Wort anzeigen
SHOWYD        EQU $F119    ; Doppelwort anzeigen
SHOWT7SG     EQU $F11C    ; Tetrade im 7-Seg.-Code anzeigen
SHOWB7SG	EQU	$F120
SHOWD7SG     EQU $F123    ; Wort im 7-Seg.-Code anzeigen
CLRDBUF       EQU $F130    ; Puffer lschen
SHOWDBUF     EQU $F133    ; Puffer anzeigen
RRDBUF        EQU $F136    ; Puffer rechts rotieren
RLDBUF        EQU $F139    ; Puffer links rotieren
COPYDBUF     EQU $F13C    ; Puffer kopieren
KEY          EQU $F140    ; Tastaturabfrage ohne Halt
HALTKEY       EQU $F143    ; Tastaturabfrage mit Halt
SHOWKEY       EQU $F146    ; Tastaturabfrage mit Anzeige ohne
SHOWHKEY     EQU $F149    ; Tastaturabfrage mit Anzeige und Halt
INDATA        EQU $F14C    ; Byte ber Tastatur einlesen
SHOWDATA     EQU $F150    ; Byte einlesen und anzeigen
INADR         EQU $F153    ; Adresse einlesen
SHOWADR       EQU $F156    ; Adresse einlesen und anzeigen
DLY1MS        EQU $F160    ; Verzgerung (Auflsung: 1ms)
RANDOM        EQU $F163    ; Zufallszahl ziehen
COPYXD        EQU $F166    ; Verschieben von Speicherbereichen

BLINK	EQU	$10
LATCH3	EQU	$0
SR3	EQU	$2


	ORG  	$0400
INIT:   LDD  	#T3_INT  ; Interrupt-Vektor fr Timer #3
        STD  	INTV_T3  ;  setzen
	LDD	#INTCB1
	STD	INTV_CB1
	LDD	#$FFFF
	STD	LATCH3
	STD	LATCH_T3
        LDA  	#$01  	 ; Steuerregister Timer #1
        STA  	SR_T2    ;   selektieren
        CLR  	SR_T1    ; Timer #3 starten
        CLR  	SR_T2    ; Steuerregister Timer #3 selektieren
	LDD	#$C30D
	STD	SR3	
	STA	SR_T3
	LDB	#$0B
	STB	V24IR
	LDB	#$98
	STB	V24CR
	CLR	CRB
	CLR	DDRB
	LDA	#$35	; Interrupt an CB1 und CB2 aktiviert
	STA	CRB

ANZEIGE	JSR	ANZ
	
NEU	CLRA
	LDX	#$6
	JSR	SHOWA
	JSR	HALTKEY
	CMPB	#$87
	BEQ	LATCH
	CMPB	#$86
	BEQ	SR
	CMPB	#$81
	BNE	NEU
	LDA	CRB
	EORA	#$08
	STA	CRB
	BRA	NEU

SR	LDA	#$6D
	JSR	SHOWA
	LDX	#0	
	JSR	SHOWDATA
	STA	SR_T3
	STA	SR3
	BRA	ANZEIGE

LATCH	LDA	#$38
	JSR	SHOWA
	LDX	#2
	JSR	SHOWADR
	CMPY	#$0100
	BHS	L2
	LDY	#$0100
L2	STY  	LATCH_T3 
	STY	LATCH3
	BRA	ANZEIGE


ANZ	JSR  	CLRDISP  ; Loeschen der Anzeige
	LDX	#0
	LDB	SR3
	STB	SR_T3
	JSR	SHOWB7SG
	LDX	#2
	LDD	LATCH3
	STD	LATCH_T3
	JSR	SHOWD7SG
	JSR	V24
	RTS

* Subroutine zur V24-Uebertragung, Puffer 0 - 3
V24: 	PSHS	X,U,Y,D,CC; Register retten
	LDB	#$0D
	JSR	TDRE	

	LDU	#0

TFR	LDB 	,U
    	LSRB
	LSRB
	LSRB
	LSRB
    	JSR	AUSG

	LDB	,U+
 	ANDB	#$0F
	JSR	AUSG

    	CMPU	#LATCH3+3
	BNE	TFR

	PULS	X,U,Y,D,CC;
    	RTS     

AUSG	ORB 	#$30
	CMPB	#$39
	BLE	TDRE
	ADDB	#$7

TDRE	LDA 	V24SR   ; Statusregister 6551 lesen
    	ANDA	#$10	; TDRE-Bit abfragen
    	BEQ 	TDRE	; Warten, bis leer
    	STB 	V24DATA ; Zeichen ausgeben
	RTS

	


T3_INT	PSHS	D
	LDA	BLINK
	STA	$F027
	EORA	#$40
	STA	BLINK
	LDB	STREG
	LDD	LATCH_T3
	PULS	D
	RTI

INTCB1	LDA	DRB
	LDB	CRB
	ANDB	#8
	BNE	L1
	TSTA
	BNE	L3
	LDA	#$01
	CLR	LATCH3+1
L3	STA	LATCH3
	BRA	ENDE
L1	STA	SR3
ENDE	JSR	ANZ
	RTI



	END	
