;Praktikum 	Aufgabe 5
;***********************************************************************************
		ORG	$0400		;Beginn des Programmbereichs	
		JSR	CLRDISP		;Anzeige loeschen
V24		LDA	#$0B		;In Befehlsregister 00001011
		STA	BR_V24		;  laden
		LDA	#$9C		;In Steuerregister 10011100
		STA	SR_V24		;  laden
Zaehler		CLR	<BLINKEN	;Loeschen von BLINKEN  
		LDD	#INTZAEHL	;Interruptvektor laden
		STD	<INT_Z3
		CLR	SR_Z2		;Steuerregister von Zaehler #3 selektieren
		LDA	#$00		;Steuerregister von Zaehler#3 
		STA	<PSTEUER	;  laden und auch in Puffer
		STA	>SR_Z3		;  abspeichern
		LDD	#$00		;Auffangregister von Zaehler#3 mit
		STD	<PSTART		;  mini. Impulsdauer laden, in Latch
		STD	>LATCH_Z3	;  und Puffer speichern
		LDA	#$01		;Steuerregister von Zaehler#1
		STA	>SR_Z2		;  waehlen
		CLR	>SR_Z1		;Zaehler starten

HAUPTS		LDX	#$0002		;Startwert aus Puffer laden und
		LDD	<PSTART		;  an Stellen 2-4 der Anzeige
		JSR	SHOWD7SG	;  darstellen
		LDX	#$0000		;Steuerwert aus Puffer laden und
		LDB	<PSTEUER	;  an Stellen 0-1 der Anzeige
		JSR	SHOWB7SG	;  darstellen
LOOP		JSR	PRUEFEN		;Sprung zu Pruefen	
		LDA	EMPF_REG	;Empfangsregister laden
		CMPA	#$0D		;Ist $0D empfangen worden?
		BNE	LOOP		;Wenn nein,erneut pruefen
		JSR	CODE		;Sprung zu CODE
		CLR	SR_Z2		;Steuerreg. Zaehler#3 selektieren	
		STA	<PSTEUER	;neuen Wert in Puffer und
		;STA	>SR_Z3		;  Steuerregister speichern
		JSR	CODE		;Sprung zu CODE
		STA	<LATCH1		;MSB der Latches speichern
		JSR	CODE		;Sprung zu CODE
		STA	<LATCH2		;
		LDA	<LATCH1
		LDB	<LATCH2		;In Akku B LSB der Latches laden
		STD	>LATCH_Z3	;neuen wert in Puffer und
		STD	<PSTART		;  Latches speichern
		LDA	<PSTEUER
		STA	>SR_Z3
		
		BRA	HAUPTS		;Zurueck zur Hauptschleife

CODE		JSR	PRUEFEN		;Sprung zu Pruefen
		LDA	EMPF_REG	;Empfangsregister laden
		JSR	V24E		;Sprung zu V24E
		LSLA			;4X linksschieben
		LSLA
		LSLA
		LSLA
		STA	<MSB		;Akku A in MSB speichern
		JSR	PRUEFEN		;Erneut Empfangsbereitschaft pruefen
		LDA	EMPF_REG	;Empfangsregister laden
		JSR	V24E		;Sprung zu V24E
		ADDA	<MSB		;MSB zu Akku A addieren
		RTS			;Ruecksprung

PRUEFEN		LDB	STR_V24		;Statusregister laden
		ANDB	#$08		;UND verknuepfen mit $08
		CMPB	#$08		;Vergleich, ob Empfangsreg. frei
		BNE	PRUEFEN		;  Wenn nicht erneut pruefen
		RTS			;Ruecksprung

V24E		CMPA	#$39		;A mit $39 vergleichen
		BLS	VNEXT		;Wenn <= Sprung zu VNEXT
		SUBA	#$07		;$7 von A subtrahieren
VNEXT		SUBA	#$30		;$30 von A subtrahieren
		RTS			;Ruecksprung

;***********************************************************************************		
;Beginn der Interruptroutine fuer den Zaehler
		
INTZAEHL:	LDX	#$07		;Stelle 7 der Anzeige selektieren
		LDA	<BLINKEN	;den Wert in BLINKEN laden
		EORA	#$40		;Wert mit $40 exklusiv-oder verknuepfen
		JSR	SHOWA		;Wert darstellen (Segment g oder 0)
		STA	<BLINKEN	;aktuellen Wert speichern
		LDB	ST_REG		;Loeschen des Interruptflag durch
		LDD	LATCH_Z3	;  Lesen der Register
		RTI			;Ruecksprung

;***********************************************************************************
;Definitionen der Hilfsroutinen und Adressen der Hardwareregister

INT_Z3		EQU	$002E		;Interruptvektor Zaehler #3
SR_Z1		EQU	$F018		;Steuerregister Zaehler #1
SR_Z2		EQU	$F019		;Steuerregister Zaehler #2
SR_Z3		EQU	$F018		;Steuerregister Zaehler #3
ST_REG		EQU	$F019		;Statusregister aller Zaehler
LATCH_Z3	EQU	$F01E		;Auffangregister Zaehler #3
STR_V24		EQU	$F009		;Statusregister V24
SR_V24		EQU	$F00B		;Steuerregister V24
BR_V24		EQU	$F00A		;Befehlsregister V24
EMPF_REG	EQU	$F008		;Senderegister V24
CLRDISP		EQU	$F110		;Anzeige loeschen
SHOWD7SG	EQU	$F123		;Tetraden von D darstellen
SHOWB7SG	EQU	$F120		;Tetraden von B darstellen
SHOWA		EQU	$F113		;Segment in Anzeige darstellen
PSTEUER		EQU	$0000		;Speicher fuer Steuerwort
PSTART		EQU	$0002		;Speicher fuer Startwert
BLINKEN		EQU	$0004		;Speicher fuer Blinken von Segment g
MSB		EQU	$0006		;Speicher fuer MSB in CODEroutine
LATCH1		EQU	$0008		;Speicher fuer MSB der Latches
LATCH2		EQU	$000A		;Speicher fuer LSB der Latches		
			