ZAEHLER		EQU	$0000	;Variablen
HZAEHLER	EQU	$0000
LZAEHLER	EQU	$0001
INT_FLAG	EQU	$0002
PB_FLAG		EQU	$0003

CLRDISP		EQU	$F110	;Subroutinen
SHOWT7SG	EQU	$F11C
SHOWD7SG	EQU	$F123
KEY		EQU	$F140
HALTKEY		EQU	$F143
DLY1MS		EQU	$F160

INT_T1		EQU	$002C	;Interrupt-Vektoren
INT_CA1		EQU	$0036
INT_CB1		EQU	$0038

DDR_PB		EQU	$F002	;Register
DR_PA		EQU	$F000
DR_PB		EQU	$F002
SR_PA		EQU	$F001
SR_PB		EQU	$F003
DR_V24		EQU	$F008
SR_V24		EQU	$F009
CR_V24		EQU	$F00A
IR_V24		EQU	$F00B
SR_T1		EQU	$F018
SR_T2		EQU	$F019
LATCH_T1	EQU	$F01B


	ORG	$0400		;Programmstart

	LDD	#INTR_T1	;Interrupt-Vektoren
	STD	<INT_T1		;  setzen
	LDD	#INTR_F4
	STD	<INT_CA1
	LDD	#INTR_PB
	STD	<INT_CB1
	
	LDA	#$0B		;V.24-Schnittstelle
	STA	CR_V24		;  initialisieren
	LDA	#$9C
	STA	IR_V24

INIT	CLR	<INT_FLAG	;Flags loeschen
	CLR	<PB_FLAG	
	
	LDA	#$01		;Laufende Timer
	STA	SR_T2		;  stoppen
	STA	SR_T1		;

	LDA	#$35		;Parallel-Port
	STA	SR_PA		;  initialisieren
	LDA	#$39		
	STA	SR_PB		
	LDA	#$FF
	STA	DDR_PB		;Ein/Ausgnge def.
	LDA	#$3D
	STA	SR_PB

			;*** STARTDISPLAY ***
START	JSR	CLRDISP
	LDD	#$0000
	LDX	#$0002
	JSR	SHOWD7SG
	LDX	#$0005

			;*** ZEICHENEINGABE ***
EINGABE	JSR	HALTKEY		;Warten auf Taste
	CMPB	#$0A		;Ruecksprung, wenn
	BHS	EINGABE		;Taste != 0..9

	LSL	<LZAEHLER	;4 Bits nach links
	ROL	<HZAEHLER	;  schieben
	LSL	<LZAEHLER
	ROL	<HZAEHLER
	LSL	<LZAEHLER
	ROL	<HZAEHLER
	LSL	<LZAEHLER
	ROL	<HZAEHLER
	ORB	<LZAEHLER	;LZAEHLER verodern
	STB	<LZAEHLER	;Neue Ziffer speichern	
	JSR	SHOWT7SG	;und anzeigen

	LDA	,-X		;Zeichenzaehler und
				;Anzeigestelle -1
	CMPX	#$0001		;Abfrage 4. Zeichen? (5-4=1)
	BNE	EINGABE		;Ruecksprung wenn nicht

PLUSKEY	JSR	HALTKEY	
	CMPB	#$80		;Taste ='+' ?
	BNE	PLUSKEY	

			;*** TIMER ***	
	LDA	#$01		;Timer#1 auswaehlen
	STA	SR_T2
	LDA	#$C2		;Timer#1 init.
	STA	SR_T1
	LDX	#$FFFF		;max. Loop-Zeit
	STX	LATCH_T1	;Timer starten

			;*** WARTESCHLEIFE ***
LOOP	JSR	KEY		;	
	CMPB	#$81		;Taste='-'
	BEQ	INIT		;Ruecksprung, wenn ja
	
	LDA	<INT_FLAG	;Timer-Int_Flag gesetzt?
	BEQ	LOOP		;LOOP, wenn nicht

			;*** ZAEHLER ERHOEHEN ***
	LDA	<LZAEHLER
	INCA
	DAA			;Decimal Adjust
	STA	<LZAEHLER
	BCC	DISPLAY		;Rausspringen, wenn
	CLRA			;Carry-Flag = 0
	LDA	<HZAEHLER	
	INCA
	DAA
	STA	<HZAEHLER

			;*** NEUEN ZAEHLER ANZEIGEN ***
DISPLAY	LDD	<ZAEHLER
	LDX	#$0002
	JSR	SHOWD7SG
	CLR	<INT_FLAG	;Timer-Int_Flag loeschen

			;*** DATUM AN PB ***
	LDA	<HZAEHLER	
	LDB	<PB_FLAG	;Wenn Flag nicht gesetzt,
	BEQ	SHOW_PB		;springe zur Anzeige
	LDA	<LZAEHLER
SHOW_PB	STA	DR_PB		;Zaehler in PB anzeigen

	JSR	SENDV24		;Zaehler via V.24 schicken

	BRA	LOOP		;Endlosschleife


			;*** INTERRUPT-ROUTINE T1 ***
INTR_T1	INC	<INT_FLAG	;Flag setzen
	LDD	SR_T2		;Reg-Int_Flag loeschen
	LDD	LATCH_T1
	RTI

			;*** INTERRUPT-ROUTINE PB ***
INTR_PB	LDA	DR_PB		;Reg-Int_Flag loeschen
	LDA	<PB_FLAG	;PB_Flag lesen
	BEQ	SWITCH		;Sprung wenn PB_Flag=0
	CLR	<PB_FLAG
	LDA	#$3D
	STA	SR_PB		;Lampe anschalten
	RTI
SWITCH	INC	<PB_FLAG	;PB_Flag setzen
	LDA	#$35
	STA	SR_PB		;Lampe ausschalten
	RTI

			;*** INTERRUPT-ROUTINE F4 ***
INTR_F4	LDA 	#$39
	STA	SR_PB
	CLR	DDR_PB		;Aus- zu Eingaengen
	LDA	#$35
	STA	SR_PB	

	LDY	#$5000		;ca. 5 Sek. warten
	JSR 	DLY1MS

	LDA	DR_PB		;erste Stelle prfen
	CMPA	#$A0
	BHS	ENDE_F4

	ANDA	#$0F		;zweite Stelle prfen
	CMPA	#$0A
	BHS	ENDE_F4

	LDA	DR_PB
	STA	<HZAEHLER	;Neuer HZAEHLER
	CLR	<PB_FLAG
	
ENDE_F4	LDA	#$39
	STA	SR_PB
	COM	DDR_PB		;Ein- zu Ausgaengen
	LDA	#$3D
	STA	SR_PB
	LDA	<HZAEHLER
	STA	DR_PB		;HZAEHLER anzeigen
	LDA	DR_PA		;Reg-Int_Flag loeschen	
	RTI	

			;*** Zeichen via ACIA senden ***
SENDV24	LDA	<HZAEHLER
	LSRA			;Obere Haelfte von HZAEHLER
	LSRA
	LSRA
	LSRA
	ADDA 	#$30		;ASCII
	JSR 	CHECK24		;Pruefen, ob V.24 bereit
	STA 	DR_V24		;Wert ins Datenregister
	LDA	<HZAEHLER
	ANDA	#$0F		;Untere Haelfte von HZAEHLER
	ADDA	#$30
	JSR	CHECK24		;Pruefen
	STA	DR_V24		;Senden
	LDA	<LZAEHLER
	LSRA			;Obere Haelfte von LZAEHLER
	LSRA
	LSRA
	LSRA
	ADDA 	#$30
	JSR 	CHECK24		;Pruefen
	STA 	DR_V24		;Senden
	LDA	<LZAEHLER
	ANDA	#$0F		;Untere Haelfte von LZAEHLER
	ADDA	#$30
	JSR	CHECK24		;Pruefen
	STA	DR_V24		;Senden

	LDA	#$0D		;Endsignal
	JSR	CHECK24		;Pruefen
	STA	DR_V24		;Senden
	RTS

CHECK24	LDB	SR_V24
	ANDB	#$10		;TDRE gesetzt?
	BEQ	CHECK24		;Ruecksprung wenn TDRE=0
	RTS
	


