CLRDISP		EQU	$F110
SHOWD7SG 	EQU	$F123
HALTKEY		EQU	$F143
KEY		EQU	$F140
DLY1MS		EQU	$F160
ZAEHLER		EQU	$0000
LZAEHLER 	EQU	$0001
HZAEHLER 	EQU	$0000
ZEIZAEH		EQU	$0002

		ORG	$0400
START	JSR	CLRDISP		; Lschen der Anzeige
	LDX	#2		; Adrefeld der Anzeige selektieren
	LDA	#4		; Zeichenzhler nach
	STA 	<ZEIZAEH	; Speicherstelle 2
	CLR	<HZAEHLER	; Dezimalzhler H-Byte loeschen
	CLR	<LZAEHLER	; L-Byte lschen

EINGABE	LDD	<ZAEHLER	; Zaehlerstand lesen
	JSR	SHOWD7SG	; und darstellen
	DEC	<ZEIZAEH	; Zeichenzaehler dekrementieren
	BMI	EINENDE		; falls alle Zeichen  eingegeben

TASTE	JSR	HALTKEY		; Tastaturabfrage
	CMPB	#$A		; Taste aus {0,..,9} oder {A,..,F}
	BHS	TASTE		; Sprung, falls nicht aus {0,..,9}

	LSL	<LZAEHLER	; neues Zeichen in den Zaehler bringen
	ROL	<HZAEHLER	; dazu diesen zunchst viermal nach
	LSL	<LZAEHLER	; links verschieben
        ROL	<HZAEHLER
	LSL	<LZAEHLER
	ROL	<HZAEHLER 	; und dann
	LSL	<LZAEHLER
	ROL	<HZAEHLER
	ORB	<LZAEHLER	; Tastendruck verodern
	STB	<LZAEHLER	; und abspeichern
	BRA	EINGABE 	; weiter mit Eingabe des Anfangszustandes

EINENDE	JSR	HALTKEY		; Tastaturabfrage
	CMPB	#$80		;  Taste '+' gedrueckt ?
	BNE	EINENDE		; Ruecksprung, falls nicht

ZAEHLEN	LDA	<LZAEHLER	; Inkrementieren des Zaehlers
	ADDA	#1		; zunaechst L-Byte
	DAA			; Dezimalkorrektur
	STA	<LZAEHLER	; abspeichern
	LDA	#0		; loeschen von A
	ADCA	<HZAEHLER	; Addieren des H-Bytes
	DAA			; Dezimalkorrektur
	STA	<HZAEHLER	; abspeichern
	LDD	<ZAEHLER	; Zaehlerstand lesen
	JSR	SHOWD7SG	; und darstellen
	LDY	#$03E8		; Ma fr 1 Sekunde Verzgerung
	JSR	DLY1MS		; verzgern

	JSR 	KEY		; Tastaturabfrage ohne Halt
	CMPB	#$81		; Taste '-' gedrueckt ?
	BNE	ZAEHLEN		; falls nein, weiterzhlen
	BRA	EINENDE		; falls ja, auf Taste '+' warten

	END

	
