;******************************************************************************
; P1a.ASM
;
; Programm zur Addition von BCD-Zahlen mit maximal 7 Ziffern ohne Verwendung
; des 6809-Befehls DAA. Der Befehl wird durch das Unterprogramm UP_ADD ersetzt.
; Erweiterung der Wortbreite ohne Probleme moeglich (P.-Rechner max. 8 Stellen).
; Bei Ueberlauf Aktivierung der Anzeige.
; Abbruch der Eingabe mit der Taste "S" des Praktikumsrechners.
;
	ORG	$0400	 ;Beginn des Programmbereiches

NEW:	JSR	CLRDISP	 ;Anzeige loeschen
	CLRA		 ;A loeschen
	CLRB		 ;B loeschen
	STD	>$0600	 ;Datenbereich $0600 - $0607 
	STD	>$0602	 ;mit Null initialisieren 
	STD	>$0604	 ; 
	STD	>$0606	 ; 
START:	LDX	#$0000	 ;X loeschen
	LDY	#$0600	 ;Datenzeiger laden
	LDU	#ZWIDTH	 ;Zahlenbreite laden
	JSR	HALTKEY	 ;Zeichen von Tastatur lesen
	CMPB	#$86	 ;Vergleich, auf Ende der Eingabe (Taste "S")
	BEQ	END	 ;
	CMPB	#$09	 ;Test der Eingabe auf gueltige Ziffer (0..9)
	BHI	START	 ;bei ungueltiger Ziffer zurueck zur Eingabe
CARRY:	JSR	UP_ADD	 ;Aufruf UP zur Addition von zwei BCD-Ziffern
	JSR	SHOWT7SG ;korrigierte Ziffer in Anzeige
	LEAX	1,X	 ;X:=X+1
	LEAY	1,Y	 ;Y:=Y+1
	LEAU	-1,U	 ;U:=U-1
	LDB	#$01	 ;Reg. B fuer Addition des Uebertragsbits auf 1 setzen
	CMPA	#$00	 ;Vergleich auf Ueberlauf
	BEQ	START	 ;wenn nein, zurueck zur naechsten Eingabe
	CMPU	#$0000	 ;Vergleich auf max. Zahlenbreite
	BEQ	OVERFL	 ;Overflow, Uebertrag ignorieren; zur OV-Behandlung
	BRA	CARRY	 ;Uebertrag addieren und anzeigen
OVERFL:	LDA	#$5C	 ;
	JSR	SHOWA	 ;Overflow-Symbol in Anzeigestelle S7
	JSR	HALTKEY	 ;Zeichen einlesen
	CMPB	#$86	 ;Programmende?
	BNE	NEW	 ;nein, neuer Lauf
END:	SWI1		 ;Programmende

;========================
; Unterprogramm UP_ADD: Addition von zwei BCD-Ziffern
; In:   Y: Speicherstelle der ersten BCD-Ziffer (liegt im unteren Nibble)
;       B: zweite BCD-Ziffer (liegt im unteren Nibble)
; Out:  A: gleich Null: kein Uebertrag, sonst Uebertrag fuer naechsth. Ziffer
;       B: korrigierte Ziffer, vorbereitet zur Anzeige
	
	ORG	$500	 ;Beginn Unterprogramm

UP_ADD:	ADDB	0,Y	 ;Addition der Eingabe mit erster BCD-Ziffer der Summe
	TFR	B,A	 ;
	ANDA	#$F0	 ;Test auf Ueberlauf durch vorherige Addition
	BNE	BCDADD	 ;wenn ja, Korrektur
	TFR	B,A	 ;
	CMPA	#$09	 ;Test auf gueltige BCD-Ziffer
	BLS	CARRY2	 ;wenn nein, Korrektur
BCDADD:	ADDB	#$06	 ;Korrektur, als Ergebnis gueltige BCD-Ziffer
CARRY2:	TFR	B,A	 ;
	ANDA	#$F0	 ;Vorbereitung zum Test auf Ueberlauf (Hauptprogramm)
	ANDB	#$0F	 ;eventl. Uebertrag der korrigierten Ziffer loeschen
	STB	0,Y	 ;korrigierte Ziffer abspeichern
	RTS		 ;Rcksprung in das Hauptprogramm

ZWIDTH	EQU	$0007	 ;Maximale Ziffernanzahl einer zu speichernden BCD-Zahl 

U_END	ORG	*	 ;Ende des Programmbereichs

;------------------------------------------------------------------------------
; Hier beginnen die Definitionen der Monitorroutinen und der Adressen der
; Hardware-Register.
;
;       Monitorroutinen
;
CLRDISP	 EQU	$F110	;Loeschen der Anzeige, In:-, Out:-
SHOWT7SG EQU    $F11C	;unteres Nibble von B in Siebensegmentcode wandeln 
			;und anzeigen, Position in X
SHOWA	 EQU	$F113	;Direkte Ansteuerung der Segmente der Anzeige-
			;stelle durch das Byte in A, Position in X
HALTKEY  EQU    $F143	;Lesen der Tastatur mit Warten, In:-, Out:B
