*******************************************************************************
* P2.ASM
*
* Programm zur Addition von BCD-Zahlen ohne Verwendung 
* des DAA-Befehls (fehlerbehaftet)
*
	ORG	$0400	 ;Beginn des Programmbereichs

	JSR	CLRDISP	 ;Anzeige loeschen
	LDY	#$0600	 ;Datenzeiger laden
	CLR	0,Y	 ;Datenbereich mit Null initialisieren
	CLR	1,Y	 ;
START:	LDX	#$0000	 ;X loeschen
	JSR	HALTKEY	 ;Zeichen von Tastatur lesen
	CMPB	#$86	 ;Vergleich, auf Ende der Eingabe (Taste "S")
	BEQ	ENDE	 ;
	CMPB	#$09	 ;Test der Eingabe auf gueltige Ziffer (0..9)
	BGT	START	 ;bei ungueltiger Ziffer zurueck zur Eingabe
	ADDB	0,Y	 ;Addition der Eingabe mit erster BCD-Ziffer der Summe
	TFR	B,A	 ;
	ANDA	#$F0	 ;Test auf Ueberlauf durch vorherige Addition
	BNE	BCDADD	 ;wenn ja, Korrektur
	TFR	B,A	 ;
	CMPA	#$09	 ;Test auf gueltige BCD-Ziffer
	BLS	CARRY2	 ;wenn nein, Korrektur
BCDADD:	ADDB	#$06	 ;Korrektur, als Ergebnis gueltige BCD-Ziffer
CARRY2:	TFR	B,A	 ;
	ANDA	#$0F	 ;
	BEQ		 ;Test auf Ueberlauf durch vorherige Addition/Korrektur
	LDA	#$01	 ;
	ADDA	1,Y	 ;naechsthoeherwertige Ziffer um Eins erhoehen
	STA	1,Y	 ;naechsthoeherwertige Ziffer abspeichern
SHOW:	ANDB	#$0F	 ;eventl. Uebertrag der korrigierten Ziffer loeschen
	ST	0,Y	 ;korrigierte Ziffer abspeichern
	JSR	SHOWT7SG ;korrigierte Ziffer in Anzeige
	LDB	1,Y	 ;naechsthoeherwertige Ziffer laden
	LEAX	,1,X	 ;Anzeigestelle nach links verschieben, X:=X+1
	JSR	SHOWT7SG ;naechsthoeherwertige Ziffer in Anzeige
	BRA	START	 ;zurueck zur naechsten Eingabe
ENDE:	SWI1

CLRDISP	 EQU	$F110	;Loeschen de Anzeige, In:-, Out:-
SHOWT7SG EQU    $F11C	;unteres Nibble von B in Anzeige, Position in X
HALTKEY  EQU    $F143	;Lesen der Tastatur mit Warten, In:-, Out:B
