;************************************************************************
; P3.ASM
;
; Zaehlprogramm ueber drei Unterprogramme zur Darstellung der verschiedenen
; Moeglichkeiten zur Zwischenspeicherung sowie der verschachtelten Progr.
; von Unterprogrammen.
;		Zaehler des HP erscheint in den Anzeigestellen S7,S6
;		Register B und X werden ueber Speicherbereiche gerettet
;
	ORG	$0400	 ;Beginn des Programmbereiches

	JSR	CLRDISP	 ;Anzeige loeschen
	LDX	#$0006   ;Vorbereitung der Anzeige (S7,S6)
	LDB	#$FF	 ;Zaehler initialisieren
NEXT0:	INCB		 ;Zaehler inkrementieren
	JSR	SHOWB7SG ;Zaehlerstand anzeigen
	STB	MEM1	 ;Zaehler und Anzeigeposition ueber 
	STX	MEM2	 ;Speicherbereich retten
	JSR	UP1	 ;Aufruf des ersten UP
	LDB	MEM1	 ;Zaehler und Anzeigeposition einlesen
	LDX	MEM2	 ;
	CMPB	#$FF	 ;Abbruchbedingung erfuellt?
	BNE	NEXT0	 ;wenn nein, zurueck zu NEXT0
	SWI		 ;Programmende


;========================================================================
;Unterprogramm  UP1: Zaehler, der in den Anzeigestellen S5,S4 erscheint
;		Register B und X werden ueber den Stack gerettet.
;
UP1:	LDX	#$0004	 ;Anzeigeposition laden (S5,S4)
	LDB	#$FF	 ;Zaehler initialisieren
NEXT1:	INCB		 ;Zaehler inkrementieren
	JSR	SHOWB7SG ;Zaehlerstand anzeigen
	PSHS	B	 ;Zaehler und Anzeigeposition ueber
	PSHS	X	 ;den Stack retten
	JSR	UP2	 ;Aufruf des zweiten UP
	PULS	X	 ;Zaehler und Anzeigeposition einlesen
	PULS	B	 ;
	CMPB	#$FF	 ;Abbruchbedingung erfuellt?
	BNE	NEXT1	 ;wenn nein, zurueck zu NEXT1
	RTS		 ;Ende Unterprogramm


;========================================================================
;Unterprogramm  UP2: Zaehler, der in den Anzeigestellen S3, S2 erscheint
;		Register B und X werden ueber Register gerettet.
;
UP2:	LDX	#$0002	 ;Anzeigeposition laden (S3,S2)
	LDB	#$FF	 ;Zaehler initialisieren
NEXT2:	INCB		 ;Zaehler inkrementieren
	JSR	SHOWB7SG ;Zaehlerstand anzeigen
	TFR	B,A	 ;Zaehler und Anzeigeposition ueber
	TFR	X,Y	 ;andere Prozessorregister retten
	JSR	UP3	 ;Aufruf des dritten (letzten) UP
	TFR	A,B	 ;Zaehler und Anzeigeposition wieder 
	TFR	Y,X	 ;zurueckschreiben
	CMPB	#$FF	 ;Abbruchbedingung erfuellt?
	BNE	NEXT2	 ;wenn nein, zurueck zu NEXT3
	RTS		 ;Ende Unterprogramm


;========================================================================
;Unterprogramm  UP3: Zaehler, der in den Anzeigestellen S1,S0 erscheint
;
UP3:	LDX	#$0000
	LDB	#$FF
NEXT3:	INCB
	JSR	SHOWB7SG
	CMPB	#$FF
	BNE	NEXT3
	RTS


MEM1 	  EQU	$0500	;Speicherbereiche zum Zwischenspeichern
MEM2	  EQU   $0502	;von Daten
CLRDISP   EQU   $F110	;Anzeige des Praktikumsrechners loeschen
SHOWB7SG  EQU	$F120	;Anzeige der Hexzahl, die in B steht; Position in X