; ****************************************************************************
; P4.ASM
;
; Ziffern-Zaehlprogramm mittels einer Software-Interruptroutine.
; Software-Interrupt wird als Monitor- (Betriebssystem-) Gate benutzt, um 
; Funktionen des Monitors zu benutzen. Eingegebener Wert wird in S0 dargestellt,
; Anzahl der eingebenen Werte fuer "0" in S7, fuer "1" in S6.
; Uebergabeparameter: X-Reg.: call-by-value, B-Reg.: call-by-reference.
;   Parameter werden in der Interruptroutine Stack-relativ geladen/gespeichert.
;
	ORG  $0400	;Beginn des Programmbereiches	
	
	LDX  #MRGATE	;Interruptroutine in der Vektortabelle
	STX  <$004C	;an Adresse $004C, $004D eintragen
NEW:	LDX  #$0008	;Uebergabeparameter nach A (Anzeige loeschen)
	SWI3		;Software-Interrupt ausfuehren
	CLRB		;Zaehler in den Speicherstellen
	LDX  #$0006	;$06 und $07 in der Zero-Page
	STB  ,X		;mit Null initialisieren
	SWI3		;und jeweiliger Wert (0)
	LEAX 1,X	;in den Anzeigestellen
	STB  ,X		;S6 und S7 anzeigen
	SWI3		;
INPUT:	LDX  #$0009	;Uebergabeparameter fuer Tastatur nach X und
	SWI3		;zur Interruptroutine verzweigen
	CMPB #$01	;Wurde Taste "1" betaetigt?
	BNE  INPUT0	;Wenn nein, vielleicht "0"
	LDX  #$0000	;Wert in Anzeigestelle
	SWI3		;S0 anzeigen
	LEAX 6,X	;Zaehler fuer den
	LDB  ,X		;Wert "1" laden,
	INCB		;inkrementieren und wieder
	STB  ,X		;abspeichern
	SWI3		;In S6 anzeigen
	BRA  INPUT	;zurueck zur naechsten Eingabe
INPUT0: CMPB #$00	;Vergleich auf Taste "0"
	BNE  INPUT+	;wenn nein, vielleicht "+"-Taste
	LDX  #$0000	;Wert in Anzeigestelle
	SWI3		;S0 anzeigen
	LEAX 7,X	;Zaehler fuer "0"
	LDB  ,X		;laden,
	INCB		;inkrementieren und
	STB  ,X		;abspeichern
	SWI3		;In S7 anzeigen
	BRA  INPUT	;zurueck zur naechsten Eingabe
INPUT+:	CMPB #$80	;Vergleich auf "+"-Taste
	BEQ  NEW	;Wenn ja, Zaehler neu initialisieren
	BRA  INPUT	;ungueltige Taste, zurueck zur Eingabe
	

; Interruptroutine
MRGATE:	LDX  4,S	;X-Register vom Stack holen (Stack-relativ)
	CMPX #$0008	;Routine fuer Anzeige gefordert ?
	BHS  DISP	;Wenn nein, vielleicht Anzeige loeschen
	JSR  SHOWT7SG	;Anzeige des unteren Nibbles aus B
	BRA  SUBEND	;zum RTI
DISP:	CMPX #$0008	;Routine zum Loeschen der Anzeige gefordert?  
	BNE  TAST	;Wenn nein, vielleicht Routine zur Tastatureingabe
	JSR  CLRDISP	;Anzeige loeschen
	BRA  SUBEND	;zum RTI
TAST:	CMPX #$0009	;Routine zur Tastatureingabe gefordert?
	BNE  SUBEND	;Wenn nein, falscher Uebergabeparameter; zurueck
	JSR  HALTKEY	;auf Eingabe von Tastatur warten
	STB  2,S	;B-Register auf den Stack legen (Stack relativ)
SUBEND: RTI		;Ruecksprung zum Hauptprogramm


CLRDISP	  EQU   $F110	;Loeschen der Anzeige, In:-, Out:-
SHOWT7SG  EQU   $F11C	;unteres Nibble von B in Anzeige, Position in X
HALTKEY	  EQU   $F143	;Lesen der Tastatur mit Warten, In:-, Out:B