CLRDISP	EQU	$F110
SHOWB7SG EQU	$F120
SHOWDATA EQU	$F150
HALTKEY	EQU	$F143
DLY1MS	EQU	$F160
DRB	EQU	$F002
DDRB	EQU	$F002
CRB	EQU	$F003

		ORG	$0400
START	JSR	CLRDISP	; Loeschen der Anzeige
			; Port PB als Eingnge 
PINIT	CLR	CRB	; DDRB ansprechen 
	CLR	DDRB	; PBi Eingang i=0,..,7
	LDA	#$14	; DRB ansprechen, 
	STA	CRB	; auf positive Flanke an CB2 warten
			; kein Interrupt zur CPU

WARTE2	LDB	CRB	; Steuerregister lesen
	ANDB	#$40	; Interrupt-Flag CB2 maskieren
	BEQ	WARTE2	; Flag nicht gesetzt

	LDB	DRB	; PB lesen, Flag wird gelscht
	LDX	#$0	; Datenfeld selektieren
	JSR	SHOWB7SG; Datum ausgeben
	LDA	#$3C	; CB2 als statischen Ausgang 
	STA	CRB	; und LED an
	LDY	#$0400 	; ca. 1 Sekunde
	JSR	DLY1MS	;  warten
	LDA	#$34	; LED aus
	STA	CRB	;

	LEAX	6,X	; Operationsfeld anwhlen
	JSR	SHOWDATA; Hex-Zahl einlesen und darstellen

WARTE1	LDB	CRB	; 
	BPL	WARTE1	; kein Interrupt an CB1

	LDB	DRB	; Dummy-Read, lscht Flag

			; Port PB umsteuern
	CLR	CRB	; Steuerregister selektieren
	LDB	#$FF	; PBi als Ausgang, i=0,..,7
	STB	DDRB	;  programmieren
	LDB	#$3C	; Datenregister selektieren
	STB	CRB	;  und LED an
	STA	DRB	; eingelesene Zahl ausgeben
	JSR	DLY1MS	; 1 Sekunde verzgern
	BRA	PINIT	; zum Einlesen

	END

	
	



