CLRDISP	EQU	$F110
SHOWB7SG EQU	$F120
SHOWDATA EQU	$F150
HALTKEY	EQU	$F143
DLY1MS	EQU	$F160
DRB	EQU	$F002
DDRB	EQU	$F002
CRB	EQU	$F003

		ORG	$0400
START	JSR	CLRDISP	; Lschen der Anzeige
			; Port PB als Eingnge 
PINIT	CLR	CRB	; DDRB ansprechen 
	CLR	DDRB	; PBi Eingang i=0,..,7
	LDA	#$14	; DRB ansprechen, 
	STA	CRB	; auf positive Flanke an CB2 warten
			; kein Interrupt zur CPU

WARTE2	LDB	CRB	; Steuerregister lesen
	ANDB	#$40	; Interrupt-Flag CB2 maskieren
	BEQ	WARTE2	; Flag nicht gesetzt

	LDB	DRB	; PB lesen, Flag wird gelscht
	LDX	#$0	; Datenfeld S1, S0 selektieren
	JSR	SHOWB7SG; Datum ausgeben
	LDA	#$3C	; CB2 als statischen Ausgang 
	STA	CRB	; und LED an
	LDY	#$1000 	; Wert fr Zeitverzgerung
	JSR	DLY1MS	;  warten
	LDA	#$34	; auf Interrupt an CB1 warten
	STA	CRB	;

	LEAX	6,X	; Operationsfeld anwhlen
	JSR	SHOWDATA; Hex-Zahl einlesen und darstellen

WARTE1	LDB	CRB	; 
	BPL	WARTE1	; kein Interrupt an CB1

	LDB	DRB	; Dummy-Read, lscht Flag

			; Port PB umsteuern
	CLR	CRB	; Steuerregister selektieren
	LDB	#$FF	; PBi als Ausgang, i=0,..,7
	STB	DDRB	;  programmieren
	LDB	#$3C	; Datenregister selektieren
	STB	CRB	;  und LED an
	STA	DRB	; eingelesene Zahl ausgeben
	JSR	DLY1MS	; 1 Sekunde verzgern
	BRA	PINIT	; zum Einlesen

	END

	
	



