	ORG	$0400	;Beginn des Programmbereichs
;
ANFANG	JSR	CLRDISP	;Anzeige loeschen
EINGABE	JSR	HALTKEY	;Zeichen von Tastatur lesen
	ASLB		;viermal shift links, um das eingegebene Zeichen 
	ASLB		;in das obere Halbbyte von B zu uebertragen. Falls eine
	ASLB		;Funktionstaste gedrueckt wurde, bleibt davon nur der
	ASLB		;"Ziffernteil" im unteren Halbbyte ueber.
	STB	DATA	;Eingabe sichern
	JSR	HALTKEY	;zweites Zeichen von Tastatur lesen
	ANDB	#$0F	;oberes Halbbyte loeschen (falls Funktionstaste)
	ORB	DATA	;mit erstem Zeichen verknuepfen
	LDX	#0	;Anzeigeposition
	JSR	SHOWB7SG;B im Siebensegmentcode ausgeben
;
;	nun beginnt das neue Programm




;
;
;	Datenbereich
;
DATA	RMB	1	;Datenbereich zur Zwischenspeicherung der Eingabe

HEX	FCB	$00	;hier beginnt die Hex.-Tabelle. Alle Werte werden
	FCB	$01	;einfach einzeln als Byte-Datum definiert.
	FCB	$02	;
	FCB	$03	;
	FCB	$04	;
	FCB	$05	;
	FCB	$06	;
	FCB	$07	;
	FCB	$08	;
	FCB	$09	;
	FCB	$0A	;
	FCB	$0B	;
	FCB	$0C	;
	FCB	$0D	;
	FCB	$0E	;
HEXEND	FCB	$0F	;Ein Hilfs-Label zur Laengenberechnung

ASCII	FDB	$3031	;die zweite Tabelle wird aehnlich definiert, jedoch
	FDB	$3233	;mit dem Befehl FDB statt FCB.
	FDB	$3435	;
	FDB	$3637	;
	FDB	$3839	;
	FDB	$4142	;
	FDB	$4344	;
ASCIIE	FDB	$4546	;ASCIIEND als Label ist leider zu lang

TABLEN	EQU	15	;15 ist maximaler Offset auf Tabellenanfang

U_END	ORG	*	;Ende des Programmbereichs
;==============================================================================
; Konstanten
;
;-----------------------
;parallele Schnittstelle
;-----------------------
DRA	EQU	$?	;Port A: Datenregister
DDRA	EQU	$?	;        Datenrichtungsregister
CRA	EQU	$?	;        Steuerregister
DRB	EQU	$?	;Port B: dto.
DDRB	EQU	$?
CRB	EQU	$?
;
;----------------------
;serielle Schnittstelle
;----------------------
ACDATA  EQU     $?	;ACIA1: Datenregister
ACSTAT  EQU     $?	;       Statusregister
ACCOMM  EQU     $?	;       Befehlsregister (Commandreg.)
ACCONT  EQU     $?	;       Steuerregister (Controlreg.)
;
;-----
;Timer
;-----
TICR1	EQU	$?	;Timer1: Kontrollregister (schreiben)
TILAT1	EQU	$?	;        Latch (schreiben)
TICOU1	EQU	$?	;        Zaehler (lesen)
TICR2	EQU	$?	;Timer3: Kontrollregister (schreiben)
TILAT2	EQU	$?	;        Latch (schreiben)
TICOU2	EQU	$?	;        Zaehler (lesen)
TICR3	EQU	$?	;Timer2: Kontrollregister (schreiben)
TILAT3	EQU	$?	;        Latch (schreiben)
TICOU3	EQU	$?	;        Zaehler (lesen)
TISTAT	EQU	$?	;alle Timer: Statusregister (lesen)
;
;-----------------
;Tastatur, Anzeige
;-----------------
KEY0	EQU	$?	;0te Tastaturspalte
DISP	EQU	$?	;erstes Zeichen im Anzeigepuffer
;
;------------
;Userroutinen
;------------
T7SG     EQU    $?	;Umwandeln der unteren Tetrade von B in 7-Segmentcode
B7SG     EQU    $?	;Umwandeln beider Tetraden von B in 7-Segmentcode
D7SG     EQU    $?	;Umwandeln der vier Tetraden von D in 7-Segmentcode
CLRDISP  EQU    $?	;Loeschen der Anzeige
SHOWA    EQU    $?	;Bringt A in die Anzeige, Position in X
SHOWD    EQU    $?	;Bringt D in die Anzeige, Position in X
SHOWYD   EQU    $?	;Bringt Y,D in die Anzeige, Position in X
SHOWT7SG EQU    $?	;Umwandeln von Tetr. in B, darstellen, Position in X
SHOWB7SG EQU    $?	;Umwandeln von B, darstellen, Position in X
SHOWD7SG EQU    $?	;Umwandeln von D, darstellen, Position in X
CLDBUF   EQU    $?	;Loeschen des Anzeigepuffers
SHOWDBUF EQU    $?	;Uebertragen des Puffers in die Anzeige
RRDBUF   EQU    $?	;Rotieren des Puffers um eine Stelle nach rechts
RLDBUF   EQU    $?	;Rotieren des Puffers um eine Stelle nach links
COPYDBUF EQU    $?	;Kopieren eines zweiten Puffers in den Anzeigepuffer
KEY      EQU    $?	;Lesen der Tastatur ohne Warten, Tastencode nach B
HALTKEY  EQU    $?	;Lesen der Tastatur mit Warten, Tastencode nach B
SHOWKEY  EQU    $?	;Lesen ohne Warten, darstellen, Tastencode nach B
SHOWHKEY EQU    $?	;Lesen mit Warten, darstellen, Tastencode nach B
INDATA   EQU    $?	;Einlesen eines 8-Bit-Wertes nach A, Tastencode nach B
SHOWDATA EQU    $?	;Einlesen nach A, darstellen, Tastencode nach B
INADR    EQU    $?	;Einlesen eines 16-Bit-Wertes nach Y, Tastencode nach B
SHOWADR  EQU    $?	;Einlesen nach Y, darstellen, Tastencode nach B
DLY1MS   EQU    $?	;Schleife zur Zeitverzoegerung, Zeitdauer in Y
RANDOM   EQU    $?	;Pseudo-Zufallszahlen, alter und neuer Wert in Y
COPYXD   EQU    $?	;Kopieren von Speicher, Startadr. in X,Y, Laenge in D
