CLRDISP	EQU	$F110
SHOWB7SG EQU	$F120
INT3	EQU	$002E
CR1	EQU	$F018
CR3	EQU	$F018
CR2	EQU	$F019
LATCH3	EQU	$F01E
SR	EQU	$F019
IMPULS	EQU	$00
MOD	EQU	$01
FLAG	EQU	$02

		ORG	$0400
START	JSR	CLRDISP	; Lschen der Anzeige
	LDD	#INTROU	; Interruptvektor
	STD	<INT3	;   fr Z. #3 laden
	LDA	#$01	; Initialisieren von
	STA	<MOD	;   Modifizierer
	STA	<FLAG	;   Halbwellen-Flag
	CLR	<IMPULS	;   Impulsdauer
	CLR	CR2	; CR3 anwhlen
	LDA	#$C2	; zyklischer Zhlbetrieb, 
	STA	CR3	; Ausgang/Interrupt aktiviert
	LDA	<IMPULS	; Anfangswert fr Zhler #3 
	LDB	#$FF	;   $00FF
	STD	LATCH3	;   in Latch3 eintragen 

	LDA	#$01	; CR1 
	STA	CR2	;   anwhlen
	CLR	CR1	; Zhler starten

LOOP	BRA	LOOP	; Endlosschleife

INTROU	LDA	SR	; Interrupt-Flag
	LDD	LATCH3	;   lschen
	NEG	<FLAG	; nchste Halbwelle 
	BPL	L1	; 2. zuende
	RTI		; Rcksprung

L1	LDA	#$01	; Zhler
	STA	CR2	;  anwhlen &
	STA	CR1	;   stoppen
	LDB	<IMPULS	; Impulsdauer modifizieren
	ADDB	<MOD	;   mit MOD
	CMPB	#$FF	;                               
	BNE	L2	; Ende nicht erreicht
	NEG	<MOD	; Modifizierer +1/-1 wechseln
	BPL	L2	; verhindert +1, falls
	ADDB	<MOD	;   IMPULS=$00

L2	STB	<IMPULS	; neue Impulslnge speichern
	STB	LATCH3	; in den Zhler bringen
	LDX	#$0	; Anzeige S1, S0 selektieren
	JSR	SHOWB7SG; Impulsdauer darstellen
	LEAX	6,X	; Anzeige S7, S6 selektieren
	LDB	<MOD	; Modifizierer
	JSR	SHOWB7SG;   darstellen
	LDA	#$FF	; Zhler #3
	STA	LATCH3+1;   LSB-Latch laden
	CLR	CR1	; Zhler erneut starten
	RTI		; Rcksprung

	END


		
	END

	
	



