#include "de.h"

//------global variable for the objective function--------------
float gfa_bound[21] ={0,1.2,1.88,3.119,6.06879,
		  11.25312,20.93868,38.99973,
		  72.66066687999998,135.385869312,
		  252.2654194687999, 470.0511374131198,
		  875.857310322687,  1632.00640736133,
		  3040.958067344504, 5666.29295426548,
		  10558.14502289265, 19673.25510067688,
		  36657.66721873185, 68305.14622427958,
		  127274.6837195391};


//------objective function---------------------------------------

t_pop evaluate(int i_D, t_pop t_tmp, long *l_nfeval, t_pop *tpa_array, int i_NP)
/**C*F****************************************************************
**                                                                  
** Function       :t_pop evaluate(int i_D, t_pop t_tmp, long *l_nfeval,
**                                t_pop *tpa_array, int i_NP)                                        
**                                                                  
** Author         :Rainer Storn                                     
**                                                                  
** Description    :Evaluates the actual cost function (objective function)
**                 which in this case evaluates the Chebychev fitting problem.                 
**                                                                  
** Functions      :-                                                
**                                                                  
** Globals        :- 
**                                                                  
** Parameters     :i_D         (I)    number of parameters
**                 t_tmp       (I)    parameter vector
**                 l_nfeval   (I/O)   counter for function evaluations
**                 tpa_array   (I)    pointer to current population (not needed here)
**                 i_NP   	   (I)    number of population members (not needed here)
**                                                                  
** Preconditions  :-                     
**                                                                  
** Postconditions :- 
**
** Return Value   :TRUE if trial vector wins, FALSE otherwise.                                            
**                                                                  
***C*F*E*************************************************************/
{
   int   i,j;
   float f_px, f_x=-1, f_dx=100.0, f_result=0;

   (*l_nfeval)++;  //increment function evaluation count

   //---checking the pass band---------------------------
   f_dx = 2.0/f_dx; //sampling granularity
   for (i=0;i<=100;i++)
   {
      f_px = t_tmp.fa_vector[0];
	  //---computation of polynomial according to Horner's rule
      for (j=1;j<i_D;j++)
      {
	    f_px = f_x*f_px+t_tmp.fa_vector[j];
      }
	  //---bounds check in pass band
      if (f_px<-1 || f_px>1) 
	  {
		  f_result += (1-f_px)*(1-f_px);
	  }
      f_x += f_dx;  //next sampling point
   }

   //---checking the stop band corners--------------------
   f_px = t_tmp.fa_vector[0];
   for (j=1;j<i_D;j++) 
   {
	   f_px = 1.2*f_px+t_tmp.fa_vector[j];
   }
   f_px = f_px - gfa_bound[i_D-1];
   if (f_px<0) f_result += f_px*f_px;

   f_px = t_tmp.fa_vector[0];
   for (j=1;j<i_D;j++) 
   {
	   f_px = -1.2*f_px+t_tmp.fa_vector[j];
   }

   //---take even or odd polynomial degree into account----
   if (i_D%2 == 1)
   {
     f_px = f_px-gfa_bound[i_D-1];
   }
   else
   {
     f_px = f_px+gfa_bound[i_D-1];
   }

   if (f_px<0) f_result += f_px*f_px;

   t_tmp.fa_cost[0] = f_result;
   return(t_tmp);
}

int left_vector_wins(t_pop t_trial, t_pop t_target)
/**C*F****************************************************************
**                                                                  
** Function       :int left_vector_wins(t_pop t_trial, t_pop t_target)                                        
**                                                                  
** Author         :Rainer Storn                                     
**                                                                  
** Description    :Selection criterion of DE. Decides when the trial
**                 vector wins over the target vector.                 
**                                                                  
** Functions      :-                                                
**                                                                  
** Globals        :-                                                
**                                                                  
** Parameters     :t_trial    (I)   trial vector
**                 t_target   (I)   target vector   
**                                                                  
** Preconditions  :-                     
**                                                                  
** Postconditions :- 
**
** Return Value   :TRUE if trial vector wins, FALSE otherwise.                                            
**                                                                  
***C*F*E*************************************************************/
{
	//---trial wins against target even when cost is equal.-----
	if (t_trial.fa_cost[0] <= t_target.fa_cost[0]) return(TRUE);
	else return(FALSE);
}

