#include "de.h"
#include "math.h"

//------defines----------------------------------------------------
#define MAXS 120

//------problem specific stuff-------------------------------------
//------Note: this is doubly defined in graphics.h-----------------
#define MAXUP1 1.1
#define MAXUP2 0.5
#define MAXLOW 0.4

//------global variable for the objective function (dummy)-------
float gfa_bound[21];

//------externals------------------------------------------------
extern int gi_NP;


//------objective function---------------------------------------


t_pop evaluate(int i_D, t_pop t_tmp, long *l_nfeval, t_pop *tpa_array, int i_NP)
/**C*F****************************************************************
**                                                                  
** Function       :t_pop evaluate(int i_D, t_pop t_tmp, long *l_nfeval,
**                                t_pop *tpa_array, int i_NP)                                        
**                                                                  
** Author         :Rainer Storn                                     
**                                                                  
** Description    :Evaluates the actual cost function (objective function)
**                 which in this case evaluates a design centering problem.                 
**                                                                  
** Functions      :-                                                
**                                                                  
** Globals        :- 
**                                                                  
** Parameters     :i_D         (I)    number of parameters
**                 t_tmp       (I)    parameter vector
**                 l_nfeval   (I/O)   counter for function evaluations
**                 tpa_array   (I)    pointer to current population
**                 i_NP   	   (I)    number of population members
**                                                                  
** Preconditions  :-                     
**                                                                  
** Postconditions :- 
**
** Return Value   :TRUE if trial vector wins, FALSE otherwise.                                            
**                                                                  
***C*F*E*************************************************************/
{
   int   i,j;
   float f_fmax, f_fmin, f_z, f_c, f_d, f_tau, f_tmin, f_tmax;

   (*l_nfeval)++;

   //======upper constraints first=========================================
   f_tmin = 0.0;
   f_tmax = 10.0;
   f_fmax = 1.0/(1.0 + t_tmp.fa_vector[0]*f_tmin + t_tmp.fa_vector[1]*f_tmin*t_tmp.fa_vector[1]*f_tmin);
   for (i=1; i<=MAXS; i++)
   {
	   f_tau = float(i)*(f_tmax -f_tmin)/(float)MAXS + f_tmin;
	   f_z = 1.0/(1.0 + t_tmp.fa_vector[0]*f_tau + t_tmp.fa_vector[1]*f_tau*t_tmp.fa_vector[1]*f_tau);
	   if (f_z > f_fmax) f_fmax = f_z;
   }
   t_tmp.fa_constraint[0] = f_fmax - MAXUP1;


   f_tmin = 10.0;
   f_tmax = 20.0;
   f_fmax = 1.0/(1.0 + t_tmp.fa_vector[0]*f_tmin + t_tmp.fa_vector[1]*f_tmin*t_tmp.fa_vector[1]*f_tmin);
   for (i=1; i<=MAXS; i++)
   {
	   f_tau = float(i)*(f_tmax -f_tmin)/(float)MAXS + f_tmin;
	   f_z = 1.0/(1.0 + t_tmp.fa_vector[0]*f_tau + t_tmp.fa_vector[1]*f_tau*t_tmp.fa_vector[1]*f_tau);
	   if (f_z > f_fmax) f_fmax = f_z;
   }
   t_tmp.fa_constraint[1] = f_fmax - MAXUP2;


   //======lower constraints next=========================================
   f_tmin = 0.0;
   f_tmax = 5.0;
   f_fmin = 1.0/(1.0 + t_tmp.fa_vector[0]*f_tmin + t_tmp.fa_vector[1]*f_tmin*t_tmp.fa_vector[1]*f_tmin);
   for (i=1; i<=MAXS; i++)
   {
	   f_tau = float(i)*(f_tmax -f_tmin)/(float)MAXS + f_tmin;
	   f_z = 1.0/(1.0 + t_tmp.fa_vector[0]*f_tau + t_tmp.fa_vector[1]*f_tau*t_tmp.fa_vector[1]*f_tau);
	   if (f_z < f_fmin) f_fmin = f_z;
   }
   t_tmp.fa_constraint[2] = MAXLOW - f_fmin;


   f_tmin = 5.0;
   f_tmax = 20.0;
   f_fmin = 1.0/(1.0 + t_tmp.fa_vector[0]*f_tmin + t_tmp.fa_vector[1]*f_tmin*t_tmp.fa_vector[1]*f_tmin);
   for (i=1; i<=MAXS; i++)
   {
	   f_tau = float(i)*(f_tmax -f_tmin)/(float)MAXS + f_tmin;
	   f_z = 1.0/(1.0 + t_tmp.fa_vector[0]*f_tau + t_tmp.fa_vector[1]*f_tau*t_tmp.fa_vector[1]*f_tau);
	   if (f_z < f_fmin) f_fmin = f_z;
   }
   t_tmp.fa_constraint[3] = 0.0 - f_fmin;
   
   //======cost value (with center index)================================================
   f_c = 0;//center index
   for (i=0; i<gi_NP; i++)
   {
	   f_d = 0; //distance measure squared
	   for (j=0; j<i_D; j++)
	   {
		   f_d += (t_tmp.fa_vector[j] - tpa_array[i].fa_vector[j])*(t_tmp.fa_vector[j] - tpa_array[i].fa_vector[j]);
	   }
	   f_c += exp(-f_d);
   }
   t_tmp.fa_cost[0] = -f_c;

   return(t_tmp);
}

int left_vector_wins(t_pop t_trial, t_pop t_target)
/**C*F****************************************************************
**                                                                  
** Function       :int left_vector_wins(t_pop t_trial, t_pop t_target)                                        
**                                                                  
** Author         :Rainer Storn                                     
**                                                                  
** Description    :Selection criterion of DE. Decides when the trial
**                 vector wins over the target vector.                 
**                                                                  
** Functions      :-                                                
**                                                                  
** Globals        :-                                                
**                                                                  
** Parameters     :t_trial    (I)   trial vector
**                 t_target   (I)   target vector   
**                                                                  
** Preconditions  :-                     
**                                                                  
** Postconditions :- 
**
** Return Value   :TRUE if trial vector wins, FALSE otherwise.                                            
**                                                                  
***C*F*E*************************************************************/
{
	int i;
	int i_ctrial_satisfy  = TRUE;
	int i_ctarget_satisfy = TRUE;
	int i_constraints_improve = TRUE;

    //----all constraints are satisfied ?----------
	for (i=0; i<4; i++)
	{
		if (t_trial.fa_constraint[i] > VTR) i_ctrial_satisfy = FALSE;
	}
	for (i=0; i<4; i++)
	{
		if (t_target.fa_constraint[i] > VTR) i_ctarget_satisfy = FALSE;
	}

	//----make the decision dependend on the constraints-------
	if ((i_ctrial_satisfy == TRUE) && (i_ctarget_satisfy == TRUE))
	{
	   if (t_trial.fa_cost[0] <= t_target.fa_cost[0]) return(TRUE);
	   else return(FALSE);
	}

	if ((i_ctrial_satisfy == TRUE) && (i_ctarget_satisfy == FALSE))
	{
	   return(TRUE); //constraints satisfaction is always best, trial wins
	}

	if ((i_ctrial_satisfy == FALSE) && (i_ctarget_satisfy == TRUE))
	{
	   return(FALSE); //constraints satisfaction is always best, target wins
	}

	if ((i_ctrial_satisfy == FALSE) && (i_ctarget_satisfy == FALSE))
	{
	   for (i=0; i<4; i++)
	   {
		  if (t_trial.fa_constraint[i] > VTR) //make sure to not promote constraint values which are better than needed
		  {
		    if (t_trial.fa_constraint[i] > t_target.fa_constraint[i]) i_constraints_improve = FALSE;
		  }
	   }
	   if (i_constraints_improve == TRUE) return(TRUE);//trial wins if all constraints are equal or better
	   else return(FALSE);
	}
	return(FALSE); //default value (only compiler needs it)

}
