#include "plot.h"
//-------Global variables relevant for graphics-----------------------

  char  gca_sbuft[80];        // Stringbuffer for trial display

  float gf_x_low, gf_x_high, gf_y_low, gf_y_high;

//-----Initialization of graphics-------------------------------------

void graphics_init(void)
/**C*F****************************************************************
**                                                                  
** Function       :void graphics_init()                                        
**                                                                  
** Author         :Rainer Storn                                     
**                                                                  
** Descripton     :Defines the coordinate system.                 
**                                                                  
** Functions      :axis()                                                
**                                                                  
** Globals        :(see code)                                                
**                                                                  
** Parameters     :-   
**                                                                  
** Preconditions  :-                     
**                                                                  
** Postconditions :-       
**
** Return Value   :-                                                                                  
**                                                                  
***C*F*E*************************************************************/
{
  // define coordinate system
  gf_x_low  = -1.5;
  gf_x_high =  1.5;
  gf_y_low  = -5;
  gf_y_high = 10;

  // define axes
  axis(gf_x_low,gf_x_high,gf_y_low,gf_y_high); 

  gca_sbuft[0] = '\0';            // Initialize string buffer
}


void update_graphics(float best[], int i_D, float fa_bound[], long l_nfeval, int i_gen, float f_emin, int i_strategy, int gi_genmax)
/**C*F****************************************************************
**                                                                  
** Function       :void update_graphics()                                        
**                                                                  
** Author         :Rainer Storn                                     
**                                                                  
** Description    :Custom program which updates the graphics part of the
**                 differential evolution optimization.                 
**                                                                  
** Functions      :xflt(), yflt(), frect(), Cls(), axis(), draw_graph(), box(),
**                 sprintf(), myprint().                                                
**                                                                  
** Globals        :(see code)  
**                                                                  
** Parameters     :best[]        (I)    Parameter vector
**                 i_D           (I)    Dimension of the parameter vector  
**                 fa_bound[]    (I)    Array defining a tolerance scheme for the current example
**                 l_nfeval      (I)    Current number of acumulated function evaluations                                          
**                 i_gen         (I)    Current number of accumulated generations
**                 f_emin        (I)    Current best objective function value
**                 i_strategy    (I)    DE-strategy used (coded as a number)
**                 gi_genmax     (I)    Maximum number of generations   
**                                                                  
** Preconditions  :graphics_init() must have been called.                     
**                                                                  
** Postconditions :-                                             
**                  
** Return Value   :-                                                                                  
**                                                                                                                  
***C*F*E*************************************************************/
{
	int j;

	
//======Begin with the new drawings.==================================
//------draw surrounding box------------------------------------------
		box('y');//grey box

//------Display current number of trials----------------------------------
// x-positioning (gf_x_low + k*(gf_x_high - gf_x_low))

		for (j=0; j<i_D; j++)
		{
		   sprintf(gca_sbuft,"best[%d] = %f",j,best[j]);
		   myprint((gf_x_low + 0.1*(gf_x_high - gf_x_low)),(gf_y_high - 0.9*((float)(j+1)/(float)i_D)*(gf_y_high - gf_y_low)),gca_sbuft);
		}

		 sprintf(gca_sbuft,"No. of trials:  %ld",l_nfeval);
		 myprint((gf_x_low + 0*(gf_x_high - gf_x_low)),(gf_y_low - 0.1*(gf_y_high - gf_y_low)),gca_sbuft);

//------Display current Iteration-----------------------------------------
		 sprintf(gca_sbuft,"Iteration:       %d",i_gen);
		 myprint((gf_x_low + 0.3*(gf_x_high - gf_x_low)),(gf_y_low - 0.1*(gf_y_high - gf_y_low)),gca_sbuft);

//------Display current pathlength----------------------------------------
		 sprintf(gca_sbuft,"best OFUNC value: %-11.10g",f_emin);
		 myprint((gf_x_low + 0.5*(gf_x_high - gf_x_low)),(gf_y_low - 0.1*(gf_y_high - gf_y_low)),gca_sbuft);

//------Display DE strategy-----------------------------------------------
		 sprintf(gca_sbuft,"DE-strategy No.: %d",i_strategy);
		 myprint((gf_x_low + 0.9*(gf_x_high - gf_x_low)),(gf_y_low - 0.1*(gf_y_high - gf_y_low)),gca_sbuft);

}