/***************************************************************
**                                                            **
**   Examples for permutation generation. Note that not all   **
**   functions are included in the test program to keep the   **
**   code simple. The tests should be changed according to    **
**   ones needs.                                              **
**                  Rainer Storn, 2004                        **
**                                                            **
***************************************************************/

//----Includes--------------------------------------------------
#include <stdio.h>

//----Defines---------------------------------------------------
#define NP    16     //population size

//----Globals---------------------------------------------------
unsigned long gul_seed = 534627;

//----Function declarations-------------------------------------

void permute1(int ia_urn2[], int i_urn2_depth);
void permute2(int ia_urn2[], int i_urn2_depth);
void permute3(int ia_urn2[], int i_urn2_depth);


//----Function definitions--------------------------------------

unsigned int rand15a(unsigned long *ulp_seed)
//Generates random numbers ex [0,2^15-1], so
//it is suited as a fixed point random number
//in 1.15 format.
//Initialize *ulp_seed with 1 (for example)
{
   *ulp_seed = *ulp_seed*1664525 + 1013904223;
   return(unsigned int)((*ulp_seed)& 32767);//modulo 2^15
}


//----Main program----------------------------------------------
void main(void)
//=====test of the "urn algorithm"=====================
{
	int  i, i_indexes;
	int  ia_urn2[NP] = {0};      //urn holding all indices

	i_indexes = NP;  //number of indexes to be permuted
//    permute1(ia_urn2, i_indexes);
//    permute2(ia_urn2, i_indexes);
    permute3(ia_urn2, i_indexes);

	printf("\nUrn results\n");
	for (i=0; i<i_indexes; i++)
	{
	   printf("%d   ",ia_urn2[i]);
	}
	printf("\n");
}

void permute1(int ia_urn2[], int i_urn2_depth)
/**C*F****************************************************************
**                                                                  
** Function       :void permute1(int ia_urn2[], int i_urn2_depth)                                        
**                                                                  
** Author         :Rainer Storn                                     
**                                                                  
** Description    :Performs a permutation of indexes 0, 1, ..., 
**                 i_urn2_depth-1 and returns this permutation
**                 in array ia_urn2[]. The permutation algorithm
**                 used is the "urn algorithm".               
**                                                                  
** Functions      :-                                                
**                                                                  
** Globals        :NP           (I)     maximum number of indexes
**                 gul_seed     (I)     seed value for random number generator
**                                               
** Parameters     :ia_urn2[]    (O)     contains permuted indexes
**                 i_urn2_depth (I)     number of indexes   
**                                                                  
** Preconditions  :i_urn2_depth must be > 0  and <= NP                   
**                                                                  
** Postconditions :permuted indexes are stored in ia_urn2[0], 
**                 ia_urn2[1], ..., ia_urn2[i_urn2_depth-1] 
**
** Return Value   :-                                            
**                                                                  
***C*F*E*************************************************************/
{
	int  i;
	int  k, i_urn1, i_urn2;
	int  ia_urn1[NP] = {0};      //urn holding all indices

	k      = NP;
	i_urn1 = 0; 
	i_urn2 = 0;
	for (i=0; i<NP; i++) ia_urn1[i] = i; //initialize urn1

	while (k >= NP-i_urn2_depth+1)//i_urn2_depth is the amount of indices wanted (must be <= NP) 
	{
       i_urn1 = (rand15a(&gul_seed)*k)>>15;  //choose a random index

	   ia_urn2[i_urn2] = ia_urn1[i_urn1];      //move it into urn2
	   ia_urn1[i_urn1] = ia_urn1[k-1]; //move highest index to fill gap
	   k = k-1;                        //reduce number of accessible indices
	   i_urn2 = i_urn2 + 1;            //next position in urn2
	}
}

void permute2(int ia_urn2[], int i_urn2_depth)
/**C*F****************************************************************
**                                                                  
** Function       :void permute2(int ia_urn2[], int i_urn2_depth)                                        
**                                                                  
** Author         :Rainer Storn                                     
**                                                                  
** Description    :Performs a permutation of indexes 0, 1, ..., 
**                 i_urn2_depth-1 and returns this permutation
**                 in array ia_urn2[]. The permutation does not
**                 require an additional local array since it 
**                 operates with local swaps.
**                 NOTE: if this method is embedded into the
**                 DE-kernel it doesn't require an array. The
**                 array ia_urn2[] is just needed as a function
**                 interface here.              
**                                                                  
** Functions      :-                                                
**                                                                  
** Globals        :NP           (I)     maximum number of indexes
**                 gul_seed     (I)     seed value for random number generator
**                                               
** Parameters     :ia_urn2[]    (O)     contains permuted indexes
**                 i_urn2_depth (I)     number of indexes   
**                                                                  
** Preconditions  :i_urn2_depth must be > 0  and <= NP                   
**                                                                  
** Postconditions :permuted indexes are stored in ia_urn2[0], 
**                 ia_urn2[1], ..., ia_urn2[i_urn2_depth-1] 
**
** Return Value   :-                                            
**                                                                  
***C*F*E*************************************************************/
{
	int  i;
	int  k, i_urn1, i_swap;

	for (i=0; i<NP; i++) ia_urn2[i] = i; //initialize urn1

	for (k=0; k<i_urn2_depth; k++) //i_urn2_depth is the amount of indices wanted (must be <= NP) 
	{
       i_urn1 = ((rand15a(&gul_seed)*(NP-k))>>15) + k;  //choose a random index
       i_swap = ia_urn2[i_urn1];     //element to be swapped
	   ia_urn2[i_urn1] = ia_urn2[k]; //move highest index to fill gap
	   ia_urn2[k]      = i_swap;
	}
}

void permute3(int ia_urn2[], int i_urn2_depth)
/**C*F****************************************************************
**                                                                  
** Function       :void permute3(int ia_urn2[], int i_urn2_depth)                                        
**                                                                  
** Author         :Rainer Storn                                     
**                                                                  
** Description    :Performs a permutation of indexes 0, 1, ..., 
**                 i_urn2_depth-1 and returns this permutation
**                 in array ia_urn2[]. The permutation algorithm
**                 is based on the fact that i = (a*j) mod NP,
**                 is a permutation of j = 0,1,2,...,NP-1 if
**                 a and NP are relatively prime.              
**                                                                  
** Functions      :-                                                
**                                                                  
** Globals        :NP           (I)     maximum number of indexes
**                 gul_seed     (I)     seed value for random number generator
**                                               
** Parameters     :ia_urn2[]    (O)     contains permuted indexes
**                 i_urn2_depth (I)     number of indexes   
**                                                                  
** Preconditions  :i_urn2_depth must be > 0  and <= NP
**                 NP must be a power of two !!!                   
**                                                                  
** Postconditions :permuted indexes are stored in ia_urn2[0], 
**                 ia_urn2[1], ..., ia_urn2[i_urn2_depth-1] 
**
** Return Value   :-                                            
**                                                                  
***C*F*E*************************************************************/
{
	int  i;
	int  i_alpha;

	i_alpha = (rand15a(&gul_seed)*(NP-1))>>15;
	if ((i_alpha%2) == 0 || (i_alpha == 0)) //make sure i_alpha is odd
	{
       i_alpha = i_alpha+1;
	}

	for (i=0; i < i_urn2_depth; i++)//generate permuted sequence 
	{    
       ia_urn2[i] = (i*i_alpha)&(NP-1);  //bitwise AND makes mod NP if NP=2^k
	}
}