/* Program: conf1.sas    */
/* Author:  ojk/ipp      */
/* Date:    febr. 2003   */
/* Update:               */
/* Input file: conf1.dat (ascii)      */
/* Purpose: confinement data analysis */
/*          using SAS PROC NLIN       */
/*          (illustration only)       */

options nocenter mprint;

filename inp './conf1.dat';
filename out './conf1_log.dat';

data conf1;
 infile inp firstobs=6;
 input wth ip bt nel pl;
run;

data conf1b;
 set conf1;
  elwth = log(wth);
  elip  = log(ip);
  elbt  = log(bt);
  elnel = log(nel);
  elpl  = log(pl);
 label
  elwth= 'ln(Wth)'
  elip = 'ln(Ip)'
  elbt = 'ln(Bt)'
  elnel= 'ln(nel)'
  elpl = 'ln(PL)'
 ;
run;

data _null_;
 set conf1b;
  file out;
  put elwth 8.4 elip 8.4 elbt 8.4 elnel 8.4  elpl 8.4;
run;

proc insight data=conf1b;
*mult elip elbt elnel elpl elwth;
 scatter  elwth * elip elbt elnel elpl / yaxis=-2.5 -1.5 0.5 0.5 -3 -1 ;
 mult     elip elbt elnel elpl ;
run;

title 'simple log-linear regression model';

proc reg data=conf1b;
model elwth = elip elbt elnel elpl;
run;

title ' four offset and linear parameters, Newton method';
title2 'automatic derivatives ';
proc nlin data=conf1b method=marquardt smethod=golden 
          hougaard maxiter=600 noitprint;
parms
  a1=-4.1 to 4 by 1.0
  aI=1
  aB=0.2
  an=-0.5 to 0.5 by 0.5
  aP=0.2

  b1=-4.1 to 4 by 1.0
  bI=0.5
  bB=0.5 1.0
  bn=-0.5 to 0.5 by 0.5
  bP=0.5 0.7
  ;
  term1=(a1+
         aI*elip+
         aB*elbt+
         an*elnel+
         aP*elpl)
        ;

  term2=(b1+
         bI*elip+
         bB*elbt+
         bn*elnel+
         bP*elpl)
        ;
    w=exp(term1)+exp(term2);
    lw=log(w);
    model elwth=lw;
run;
********* end of program conf1.sas ************************;
