/* Program: conf2.sas                         */
/* Author:  ojk/ipp                           */
/* Date:    febr. 2003                        */
/* Update:  2004                              */
/* Input file: conf2.dat (ascii)              */
/* Purpose:    confinement data analysis      */
/*             using PROC REG and SAS INSIGHT */
/*             (illustration only)            */
/*                                            */

options nocenter mprint;

filename inp './conf2.dat';

data conf2;
 infile inp firstobs=6;
  input wth   wthe   wthcf   wthcf2  ip     bt     nel   pl ;
run;

data conf2b;
 set conf2;
  elwth     = log(wth);
  elwthe    = log(wthe);
  elwthcf   = log(wthcf);
  elwthcf2  = log(wthcf2);
  elip      = log(ip);
  elbt      = log(bt);
  elnel     = log(nel);
  elpl      = log(pl);
 label
  elwth    = 'ln(Wth)'
  elwthe   = 'ln(Wthe)'
  elwthcf  = 'ln(Wthcf)'
  elwthcf2 = 'ln(Wthcf2)'
  elip     = 'ln(Ip)'
  elbt     = 'ln(Bt)'
  elnel    = 'ln(nel)'
  elpl     = 'ln(PL)'
;
run;

proc reg data=conf2b;
 model elwth   elwthe   = elip elbt elnel elpl;
 model elwthcf elwthcf2 = elip elbt elnel elpl;
run;

proc insight data=conf2b;
*mult elip elbt elnel elpl elwth;
 scatter  elwth * elip elbt elnel elpl 
        / yaxis=-2.5 -1.5 0.5 0.5 -3 -1 ;
 mult     elip elbt elnel elpl ;
 fit      elwthcf2 = elip elbt elnel elpl ;
run;

********* end of program conf2.sas ************************;
