/* Program:   halo1.sas            */
/* Author(s): ojk/ipp              */
/* Date:      2004                 */
/* Update:                         */
/* Input file(s):  halo1.dat       */
/* Output file(s): halo1.sas7bdat  */
/* Purpose: Example SAS program to read data file */
/*          and for analysis with PROC INSIGHT    */
/*          (prepared by G. Pautasso)             */

filename inp  './halo1.dat';
libname c '.';

data halo1;
 infile inp firstobs=6;
 input shot maxI_o maxI_i Idt_o Idt_i polasy ip bt;
run;
 
data one;
  set halo1;
  eip = ip*1e-3;
  if (bt < 1.5 and polasy<0.15) then ip_1=eip;
  if (bt > 1.5 and polasy<0.15) then ip_2=eip;
  if (polasy > 0.15) then ip_3=eip;
  if (polasy < 0.15) then ip_4=eip;
  elip   = log(eip);
  elbt   = log(bt);
  lIdt_o = log(Idt_o);
  lIdt_i = log(Idt_i);
  lIdt   = log(Idt_o+Idt_i);
label
  elbt   = 'ln(Bt)'
  elip   = 'ln(Ip)'
  lIdt   = 'ln(Idt)'
  lIdt_o = 'ln(Idt_outer)'
  lIdt_i = 'ln(Idt_inner)'
  ;
run;

proc insight data=one;
  mult elip elbt lIdt;
  fit lIdt = elip;
run;

********* end of program halo1.sas ************************;
