! File: komplot_ext_mod.f90
! Purpose: Extension of standard KOMPLOT
! Version: September, 2004
           

!===============================================================================
Module set_KOMPLOT_Ext_Precision

   Integer, Parameter :: wp = Kind(1.0e0) !single
!  Integer, Parameter :: wp = Kind(1.0d0) !double
   Integer, Parameter :: sp = Kind(1.0e0) !single
 
End Module set_KOMPLOT_Ext_Precision
!===============================================================================

!
Module KOMPLOT_EXT
!===============================================================================
!------------------------------------------------------------------------------+
! Starting date: Aug 1, 2001
! Use: Subroutines extending some aspects of komplot
! Main authors: Otto Kardaun (Version I)
!

! (C) 2004 O. Kardaun, free software, released under GNU lesser general public 
!     license, Version 2.1, June 1999, 
!     see http://www.gnu.org/copyleft/lesser.html

!     Utilises routines from public domain KOMPLOT library (Version 8.0),
!     authored by J. Kraak, and available on internet, see
!     http://www.rug.nl/rc/hpcv/visualisation/komplot

! Modification history (Version I):
!               March 27, 2003: included in discrim1.f90
!               May 2004: small editing, of comments only
!               September 2004: small editing only, compatible with discrim1.f90
!                          
!
! Contains the following subroutines: format_x_axisnumbers_f90
!                                     format_y_axisnumbers_f90
!                                     x_margins_f90
!                                     sec_axis

Use set_KOMPLOT_Ext_Precision

! -End of Header Module KOMPLOT_EXT--------------------------------------------+

Contains

!===============================================================================
Subroutine Format_x_axisnumbers_f90 (n_dec_pos, n_exp_10)

Implicit None

! imported arguments:
Integer, Intent(in), Optional :: n_dec_pos, n_exp_10
! local arguments:
Integer :: un_dec_pos, un_exp_10

!-End of subroutine header------------------------------------------------------

! Set default values:
If (Present(n_dec_pos)) Then
  un_dec_pos=n_dec_pos
Else
  un_dec_pos=2
End If
If (Present(n_exp_10)) Then
  un_exp_10=n_exp_10
Else
  un_exp_10=0   ! default if subroutine is called !
End If

! call F-77 routine:
Call Format_x_axisnumbers (un_dec_pos,un_exp_10)

End Subroutine Format_x_axisnumbers_f90
!===============================================================================

!===============================================================================
Subroutine Format_y_axisnumbers_f90 (n_dec_pos, n_exp_10)

Implicit None

! imported arguments:
Integer, Intent(in), Optional :: n_dec_pos, n_exp_10
! local arguments:
Integer :: un_dec_pos, un_exp_10

!-End of subroutine header------------------------------------------------------

! Set default values:
If (Present(n_dec_pos)) Then
  un_dec_pos=n_dec_pos
Else
  un_dec_pos=2
End If
If (Present(n_exp_10)) Then
  un_exp_10=n_exp_10
Else
  un_exp_10=0   ! default if subroutine is called !
End If

! call F-77 routine:
Call Format_y_axisnumbers (un_dec_pos,un_exp_10)

End Subroutine Format_y_axisnumbers_f90
!===============================================================================


!===============================================================================
Subroutine x_margins_f90 (xm_left, xm_right)

Implicit None

! imported arguments:
Real(wp), Intent(in), Optional :: xm_left, xm_right
! local arguments:
Real :: uxm_left, uxm_right

!-End of subroutine header-----------------------------------------------------

! Set default values:
If (Present(xm_left)) Then
  uxm_left=xm_left
Else
  uxm_left=2.0
End If
If (Present(xm_right)) Then
  uxm_right=xm_right
Else
  uxm_right=2.0
End If

! call F-77 routine:
Call x_margins (uxm_left,uxm_right)

End Subroutine x_margins_f90
!===============================================================================


!===============================================================================
Subroutine sec_axis(axis_Type, xl, xh, yl, yh, axis_label, axis_pos, tick_pct  &
     &, num_fmt, num_dens, num_par_pct, num_per_pct, lab_par_pct, lab_per_pct  &
     &, sf_an, debug)

!  Called procedures: < KOMPLOT : disjoint_line, greal, gstrng 

  Implicit None

  ! Imported arguments
  ! check precision
  Character(LEN=1), Intent (IN)      :: axis_Type
  Real(sp), Intent (IN)              :: xl, xh, yl, yh 
  Character(LEN=*), Intent (IN)      :: axis_label
  Real(sp), Intent (IN),    Optional :: axis_pos  
  Real(sp), Intent (IN),    Optional :: tick_pct
  Integer,  Intent (IN),    Optional :: num_fmt
  Integer,  Intent (IN),    Optional :: num_dens 
  Real(sp), Intent (IN),    Optional :: num_par_pct, num_per_pct,              &
 &                                      lab_par_pct, lab_per_pct
  Real(sp), Intent (IN),    Optional :: sf_an
  Logical,  Intent (IN),    Optional :: debug
  ! meaning of some variables:
  ! num_dens: factor to dilute the tick density

  ! Local scalars (prefix u means locally used copies)
  Integer, Parameter :: nmax_sa=100, n_sa=41
  Integer, Parameter :: out=6
  Integer :: unum_fmt, unum_dens
  Integer :: i, np, np_f
  Real(sp)    :: xpct, ypct, xp, yp, angle, height
  Real(sp)    :: unum_par_pct, unum_per_pct, ulab_par_pct, ulab_per_pct
  Real(sp)    :: uaxis_pos, utick_pct, usf_an
  Logical :: udebug

  ! Local arrays
  Real(sp) :: numval(nmax_sa), lnumval(nmax_sa)
  Real(sp) :: xw1_f(nmax_sa),yw1_f(nmax_sa) 
  Real(sp) :: xsy_f(nmax_sa),ysy_f(nmax_sa) 
  Real(sp) :: xw1(nmax_sa),xw2(nmax_sa),yw1(nmax_sa),yw2(nmax_sa)
  Real(sp) :: xsy(nmax_sa),ysy(nmax_sa) 
  Real(sp) :: xw(2*nmax_sa),yw(2*nmax_sa) 
  Logical  :: in_axis_Range(nmax_sa)

  Data (numval(i),i=1,n_sa)                                                    & 
       & /   0.0001,0.0002,0.0003,0.0005,0.0008,                               &
       &    0.001, 0.002, 0.003, 0.005, 0.008, 0.01, 0.02, 0.03, 0.05, 0.08,   &
       &    0.1,   0.2,   0.3,   0.5,   0.8,   1.0,  2.0,  3.0,  5.0,  8.0,    &
       &   10,    20,    30,    50,    80,   100,  200,  300,  500,  800,      &
       & 1000,  2000,  3000,  5000,  8000, 10000   /

! -End of subroutine header ----------------------------------------------------

  ! -General default specification of optional parameters

  If (Present(tick_pct)) Then 
     utick_pct=tick_pct
  Else   
     utick_pct=4
  End If
  If (Present(num_fmt))  Then 
     unum_fmt=num_fmt
  Else
     unum_fmt=202
  End If
  If (Present(num_dens))  Then 
     unum_dens=num_dens
  Else
     unum_dens=1
  End If
  If (Present(sf_an))    Then 
     usf_an=sf_an
  Else
     usf_an=1.0
  End If
  If (Present(debug))    Then 
     udebug=debug
  Else
     udebug=.False.
  End If

  ! -Horizontal secondary axis--------------------------------------------------

  If (axis_Type=='h' .Or. axis_Type=='H') Then

     ! Specific default specification of optional parameters

     If (Present(axis_pos)) Then 
        uaxis_pos=axis_pos
     Else   
        uaxis_pos=yh
     End If
     If (Present(num_par_pct)) Then 
        unum_par_pct=num_par_pct
     Else
        unum_par_pct= -1.0*2.0*(Mod(unum_fmt,100) + unum_fmt/100)*usf_an
     End If
     If (Present(num_per_pct)) Then 
        unum_per_pct=num_per_pct
     Else
        unum_per_pct=2.0*usf_an
     End If
     If (Present(lab_par_pct)) Then
        ulab_par_pct=lab_par_pct   
     Else 
        ulab_par_pct=-1.0*2.0*Len_trim(axis_label)*usf_an
     End If
     If (Present(lab_per_pct)) Then 
        ulab_per_pct= lab_per_pct
     Else
        ulab_per_pct=7.5*usf_an ! was 6.5
     End If

     ! plot unadorned axis line
     xw(1)=xl ;        xw(2)= xh
     yw(1)=uaxis_pos ; yw(2)= uaxis_pos
     Call disjoint_line(' ',2,xw,yw)

     ! calculate and plot tickmarks 

     !
     ! The following program below applies only to the special case: 
     ! func=exp, invfunc=log.
     !
    
     ! begin of special case
     lnumval(1:n_sa) = Log(numval(1:n_sa))
     in_axis_Range(1:n_sa)=(xl < lnumval(1:n_sa) .And. lnumval(1:n_sa) < xh)
     np_f=Count(in_axis_Range(1:n_sa))
     xsy_f=Pack(numval,mask=in_axis_range)
     xw1_f=Pack(lnumval,mask=in_axis_range)
     ! end of special case

     ! dilute the density of tickmarks by unum_dens 
     np=np_f/unum_dens     !integer division 
     If (unum_dens .Ge. 2) Then
        np=np_f/unum_dens + 1
     End If
     xsy(1:np) = xsy_f(1:np_f:unum_dens)
     xw1(1:np) = xw1_f(1:np_f:unum_dens)
     xw2=xw1
     ypct=utick_pct
     yw1(1:np)=uaxis_pos
     yw2(1:np)=uaxis_pos-ypct*(yh-yl)/100.0
     Do i=1,np
        xw(2*i-1) = xw1(i)
        xw(2*i)   = xw2(i)
        yw(2*i-1) = yw1(i)
        yw(2*i)   = yw2(i)
     End Do
     Call disjoint_line (' ',2*np,xw,yw) 

     ! plot axis numbers
     xpct=unum_par_pct
     ypct=unum_per_pct
     height=0.21*usf_an
     angle=0.0
     Do i=1,np
        xp=xw1(i)+xpct*(xh-xl)/100.0
        yp=yw1(i)+ypct*(yh-yl)/100.0
        ! insert some space if two neighbouring numbers are too close:
        If (i .Ge. 2) Then 
           If ( Abs(xw1(i)-xw1(i-1)) .Lt.                                      &
    &          ((Mod(unum_fmt,100) +                                           &
    &            unum_fmt/100)*usf_an*4.0*(xh-xl)/100) ) Then  
              xp  = xw1(i) + xpct*(xh-xl)/100.0 + 3.0*(xh-xl)/100
           End If
        End If
        Call greal (xp,yp,height,angle,unum_fmt,xsy(i))
     End Do

     ! plot axis label
     xpct=ulab_par_pct
     ypct=ulab_per_pct
     height=0.28*usf_an
     angle=0.0
     xp=(xh+xl)/2.0+xpct*(xh-xl)/100.0
     yp=uaxis_pos+ypct*(yh-yl)/100.0
     Call gstrng (xp,yp,height,angle,axis_label)

     If (udebug) Then
        Write(out,*) 'np, xl, xh: ', np, xl, xh
        Write(out,*) 'in_axis_range, numval, lnumval'
        Write(out,*) in_axis_Range(12:20), numval(12:20), lnumval(12:20)  
        Write(out,*) 'xw1(1:6)'
        Write(out,*) xw1(1:6)
        Write(out,*) 'xw(1:12)'
        Write(out,*) xw(1:12)
     End If

     ! -Vertical secondary axis-------------------------------------------------

  Else If  (axis_Type=='v' .Or. axis_Type=='V') Then

     ! Specific default specification of optional parameters

     If (Present(axis_pos)) Then 
        uaxis_pos=axis_pos
     Else   
        uaxis_pos=xh
     End If
     If (Present(num_par_pct)) Then 
        unum_par_pct=num_par_pct
     Else
        unum_par_pct= -1.0*usf_an
     End If
     If (Present(num_per_pct)) Then 
        unum_per_pct=num_per_pct
     Else
        unum_per_pct=1.0*usf_an 
     End If
     If (Present(lab_par_pct)) Then
        ulab_par_pct=lab_par_pct   
     Else 
        ulab_par_pct=1.5*Len_trim(axis_label)*usf_an
     End If
     If (Present(lab_per_pct)) Then 
        ulab_per_pct= lab_per_pct
     Else
        ulab_per_pct=3.5*(Mod(unum_fmt,100) + unum_fmt/100)*usf_an
     End If

     ! plot unadorned axis line
     xw(1)=uaxis_pos ; xw(2)= uaxis_pos
     yw(1)=yl        ; yw(2)= yh 
     Call disjoint_line(' ',2,xw,yw)

     ! calculate and plot tickmarks 
     lnumval(1:n_sa) = Log(numval(1:n_sa)) 
     in_axis_Range(1:n_sa)=(yl < lnumval(1:n_sa) .And. lnumval(1:n_sa) < yh)
     np_f=Count(in_axis_Range(1:n_sa))
     ysy_f=Pack(numval,mask=in_axis_range)
     yw1_f=Pack(lnumval,mask=in_axis_range)
     ! dilute the density of tickmarks by unum_dens 
     np=np_f/unum_dens     !integer division 
     If (unum_dens .Ge. 2) Then
        np=np_f/unum_dens + 1
     End If
     ysy(1:np) = ysy_f(1:np_f:unum_dens)
     yw1(1:np) = yw1_f(1:np_f:unum_dens)
     yw2=yw1
     xpct=utick_pct
     xw1(1:np)=uaxis_pos
     xw2(1:np)=uaxis_pos-xpct*(xh-xl)/100.0
     Do i=1,np
        xw(2*i-1) = xw1(i)
        xw(2*i)   = xw2(i)
        yw(2*i-1) = yw1(i)
        yw(2*i)   = yw2(i)
     End Do
     Call disjoint_line (' ',2*np,xw,yw) 

     ! plot axis numbers
     ypct=unum_par_pct
     xpct=unum_per_pct
     height=0.21*usf_an
     angle=0.0
     Do i=1,np
        xp=xw1(i)+xpct*(xh-xl)/100.0
        yp=yw1(i)+ypct*(yh-yl)/100.0
        Call greal (xp,yp,height,angle,unum_fmt,ysy(i))
     End Do

     ! plot axis label
     ypct=ulab_par_pct
     xpct=ulab_per_pct
     height=0.28*usf_an
     angle=270.0
     yp=(yh+yl)/2.0+ypct*(yh-yl)/100.0
     xp=uaxis_pos+xpct*(xh-xl)/100.0
     Call gstrng (xp,yp,height,angle,axis_label)

     Write(6,*) 'Option type=v is implemented'

  Else 
     Write(6,*) 'Error in subroutine sec-axis, type must be h or v'
  End If ! axis_type == 

End Subroutine sec_axis
!===============================================================================

End Module KOMPLOT_EXT
!------------------------------------------------------------------------------+
!===============================================================================


