/* Program: conf3.sas                    */
/* Author:  ojk/ipp                      */
/* Date:    may 2004                     */
/* Update:                               */
/* Input file: conf3.dat (ascii)         */
/* Purpose:    confinement data analysis */
/*             using SAS INSIGHT         */
/*                                       */

options nocenter mprint;

filename inp './conf3.dat';

* BEGIN making datasets;

data conf3;
 infile inp firstobs=8;
 input
 shot   time   wth   hh     ip     bt
        nel    ne0   nev    pl
        delta  Fq   ind;
run;

data conf3b;
 set conf3;
  elwth    = log(wth);
  elip     = log(ip);
  elbt     = log(bt);
  elnel    = log(nel);
  elne0    = log(ne0);
  elnev    = log(nev);
  elpl     = log(pl);
  elnel2   = elnel*elnel;
  elnel3   = elnel*elnel*elnel;
  ldeltap = log(1.0+delta);
  lFq     = log(Fq);
 * density peaking:;
  enel       = exp(elnel);
  ene0       = exp(elne0);
  enev       = exp(elnev);
  gn         = 0.5*(ene0/enel+enel/enev);
  gn0        = (ene0/enel);
  gnv        = (enel/enev);
  lgn0       = log(gn0);
  lgnv       = log(gnv);
  lgn        = log(gn);
 * H98y2 scaling:;
 * note: arbitrary normalising constant equal to -2.1 ! ;
  lwthp982 = 0.93*elip+0.15*elbt+0.31*elpl+0.41*elnel-2.1 ;
  lwthr982 = elwth - lwthp982;
 * interaction terms:;
  elnel_ldeltap  = elnel*ldeltap;
  elnel2_ldeltap = elnel2*ldeltap;
  elnel_lFq     = elnel*lFq;
  elnel2_lFq    = elnel2*lFq;
 label
  elwth   = 'ln(Wth)'
  elip    = 'ln(Ip)'
  elbt    = 'ln(Bt)'
  elnel   = 'ln(nel)'
  elpl    = 'ln(PL)'
  elne0   = 'ln(ne0)'
  elnev   = 'ln(nev)'
  elpl    = 'ln(PL)'
  ldeltap = 'ln(1+delta)'
  lFq     = 'ln(Fq)'
  lgn0    = 'ln(ne0/nel)'
  lgnv    = 'ln(nel/nev)'
  lgn     = 'ln((gn0+gnv)/2)'
 ;
run;

data clean3b;  
 set conf3b;
  if (ind=-1) then delete;
run;

data high_nel3b;
 set clean3b;
  * if (nel>6.0); * not activated ;
run;

* END making datasets;


* ad item a):;
proc insight data=conf3b;
*mult elip elbt elnel elpl elwth;
 dist lwthr982;
 scatter  elwth * elip elbt elnel elpl / yaxis=-2.5 -1.5 0.5 0.5 -3 -1 ;
 mult     elip elbt elnel elpl ;
 fit elwth = elip elbt elnel elpl;
run;

proc insight data=conf3b;
 fit lwthr982 = lFq;
 fit lwthr982 = ldeltap;
 fit lwthr982 = lgn0;
run;

 * ad item b):;
proc insight data = clean3b;
 fit lwthr982     = elnel;
 fit lwthr982     = elnel elnel2 elnel3 ;
run;


* ad item c):;
proc insight data = clean3b;
 fit lwthr982     = lgnv;
 fit lgnv         = lwthr982;
run;

%let sdlgnv         = 0.10;
%let sdlwthr982     = 0.10;

data  clean3b_s;  * s stands for standardised;
 set clean3b;
 lgnvn         = lgnv     / (&sdlgnv);
 lwthr982n     = lwthr982 / (&sdlwthr982);
run;

proc princomp data=clean3b_s covariance outstat=pc1;
 var lwthr982n lgnvn;
run;

data pc1_e;      * e stands for extended;
 set pc1;
  if _type_     = 'SCORE' and (_name_='Prin2' or _name_ = 'Prin1');
 lwthr982r     = -1.0;
 lgnvr         = -1.0*(&sdlwthr982/&sdlgnv)*(lgnvn/lwthr982n);
run;

proc insight data=pc1_e;
run;

* ad items d and e):;
proc insight data=high_nel3b; * see data selection above !;
 fit lwthr982 = lFq lgn0 elnel;
 fit lwthr982 = lFq lgn0 elnel elnel_lFq;
 fit lwthr982 = ldeltap lgn0 elnel;
 fit lwthr982 = ldeltap lgn0 elnel elnel2 elnel3;
 fit lwthr982 = ldeltap lgn0 elnel elnel_ldeltap;
 fit lwthr982 = ldeltap lgn0 elnel elnel2 elnel_ldeltap;
 fit lwthr982 = ldeltap lgn0 elnel elnel2 elnel3 elnel_ldeltap;
run;
 
********* end of program conf3.sas ********************************************;
