/* Program:   divheat1.sas                               */
/* Author(s): ojk/ipp                                    */
/* Date:      1995                                       */
/* Update:    2004                                       */
/* Input  file(s): divheat2.dat                          */
/* Output file(s): divheat2.sas7bdat                     */
/* Purpose: Example SAS program to read ascii file       */
/*          divheat2.dat containing                      */
/*          divertor heat load data                      */
/*          (prepared by A. Herrmann)                    */
/*                                                       */

options nocenter mprint;

libname c '.';
libname p '..';
filename inp2  './divheat2.dat';

data alh2;
 infile inp2 firstobs=6;
 input shot n_e Ip Bt q95 lambda q_plate P_plate;
run;

data c.divheat2;
 set alh2;
  elip=log(ip*1e-6);
  elbt=log(abs(bt));
  if bt<0 then sign_bt=-1;
  if bt>0 then sign_bt=1;
  lnel=log(n_e);
  elnel=log(n_e*1e-19);
  lq95=log(q95);
  llambda=log(lambda);
  lq_plate=log(q_plate);
  lql_plate = llambda+lq_plate;
  ql_plate = exp(lql_plate);
  lp_plate = log(p_plate);
  if sign_bt=1 then delete;     *@;
run;

proc insight data=c.divheat2;
* mult lnel lq95 lp_plate;
* mult llambda   lq_plate;
* fit   lql_plate lp_plate;
* fit    ql_plate  p_plate;
 fit lq_plate = elnel lq95 lp_plate;
 fit lq_plate = elnel lq95 lp_plate elip;
 fit llambda = elnel lq95 lp_plate;
 fit llambda = elnel lq95 lp_plate elip;
run;
 
********* end of program divheat2.sas *****************************************;

