/* Program: dlim1.sas             */
/* Author:  ojk/ipp               */
/* Date:    1995                  */
/* Update:  dec. 2003             */
/* Input file: dlim1.dat          */
/* Output file: augdl1.sas7bdat   */

/* Purpose: PCA analysis of AUG density limit data  (R. Neu) */
/*          (Errors-in-variables, simple log-linear case)    */

options nocenter mprint;

libname p '..';
libname g '/afs/ipp/fusdat/course/graphs';
libname c '.';

filename inp  './dlim1.dat';

data neu1;
 infile inp firstobs=6;
 input shot gr shotbo nmax tdl n12 io co ic cc dco dcc;
run;

%let sdn=0.05; *was 0.02;
%let sdo1=0.2;
%let sdc1=0.4;

data neu2;
 set neu1;
  lnmax=log(nmax);
  ldco=log(dco);
  ldcc=log(dcc);
  lnmaxs=lnmax/(&sdn);
  ldcos1=ldco/(&sdo1);
  ldccs1=ldcc/(&sdc1);
*after pc analysis:;
  lnmaxsc = lnmax + 4.1*ldcc;
  sin_bo  = shot-shotbo; *number of shots since boronisation;
  lsin_bo = log(sin_bo);
  format ldco ldcc lnmax 7.3;
run;

proc means data=neu2;
run;

proc insight data=neu2;
 mult ldco ldcc lnmax;
 fit lnmax = ldcc;
 fit lnmax = ldco;
 fit ldcc  = ldco;
run;

proc means data=neu2;
run;
title 'lnmax';
proc reg data=neu2;
 model lnmax=ldcc ldco;
run;
title 'ldcc';
proc reg data=neu2;
 model ldcc=lnmax ldco;
run;
title 'ldco';
proc reg data=neu2;
 model ldco=lnmax ldcc;
run;
proc princomp data=neu2 covariance;
 var lnmax ldco ldcc;
run;

proc princomp data=neu2 covariance outstat=pc1;
 var lnmaxs ldcos1 ldccs1;
run;

data pc1;
 set pc1;
  if _type_='SCORE' and _name_='Prin3';
  lnmaxr=-1.0*(&sdn/&sdn) *(lnmaxs/lnmaxs);
  ldcosr=-1.0*(&sdn/&sdo1)*(ldcos1/lnmaxs);
  ldccsr=-1.0*(&sdn/&sdc1)*(ldccs1/lnmaxs);
run;

proc print data=pc1;
run;

data c.augdl1;
 set neu2;
* drop tdl n12 io co ic cc;
  keep lnmax ldco ldcc;
run;

proc insight data=c.augdl1;
run;


