/* Program:   magn1.sas                                    */
/* Date:      dec. 5, 2001                                 */
/* Author(s): ojk/IPP, started by pjm/UCC                  */
/* Purpose: analysis of fp dataset, in particular recovery */
/*          accuracy of li at various kappa                */
/*          (prepared by P.J. Mccarthy)                    */
/*                                                         */

/* Conclusion: cancorr selects bp + li/2 as the first, well
   determined canonical coefficient (0.99) the second canonical
   coeffecient (approximately bp-2*li) is reasonably well determined
   for k>1.4 (0.9), but not so well for k<1.25 (0.65) */

/* Note: li against pc12 has a considerably higher curvature than
          log(li) against pc12 (!) */

options linesize=80 mprint dquote;

  libname bin './';
  libname c v8 '.';

*make a permanent sas datafile:;
data c.magn1;
 infile "magn1.dat" firstobs=8;
  input (rin rout rzmin zmin rzmax zmax bp li kappa) (8.4);
  input (pc1-pc10) (7.);
  input (pc11-pc20) (7.);
  array pc{20};
  do i=1 to 20;
     pc{i}=pc{i}/1000;
  end;
run;
proc insight data=c.magn1;
run;

*prepare analysis:;
data in1;
 infile "magn1.dat" firstobs=8;
  input (rin rout rzmin zmin rzmax zmax bp li kappa) (8.4);
  input (pc1-pc10) (7.);
  input (pc11-pc20) (7.);

  array pc{20};
  do i=1 to 20;
     pc{i}=pc{i}/1000;
  end;

  array qc{1:210} y1-y210;
  do j=1 to 20;
     do k=1 to j;
       qc{round(j*(j-1)/2+k)} = pc{j}*pc{k};
     end;
  end;

  array rc{1:1540} z1-z1540;
  do j=1 to 20;
     do k=1 to j;
       do l=1 to k;
         rc{round((j+1)*j*(j-1)/6+k*(k-1)/2+l)} = pc{j}*pc{k}*pc{l};
       end;
     end;
  end;

  if kappa < 1.225 then lowk=1;
  else lowk=0;
  li_2   = li/2;
  bpli_2 = bp + li/2;
  lli_2  = log (li_2);
  lkappa = log (kappa);
  lbp    = log (bp);
  lbpli_2 = log(bpli_2);
 *data selection;
  if _N_ < 1201;
run;

data lowk;
 set in1;
  if lowk=1;
run;

data highk;
 set in1;
  if lowk=0;
run;

*proc contents data=in1;
*run;

proc sort data=in1;
 by lowk;
run;

proc insight data=in1;
run;

********* end of program magn1.sas ************************;
