/* Program:   neutral1.sas                                 */
/* Author(s): ojk/ipp                                      */
/* Date:      1997                                         */
/* Update:    2004                                         */
/* Input  file(s): neutral1.dat                            */
/* Output file(s): neutral1.sas7bdat                       */
/* Purpose: Example SAS program to read ascii file         */
/*          neutral1.dat, containing CX spectra data       */
/*          related to ion temperature and neutral density */
/*          (prepared by H.-U. Fahrbach and J. Stober)     */
/*                                                         */

libname c v8 '.';

data c.neutral1;
   infile 'neutral1.dat' firstobs=7;
   input shot phase $ rho pda;
   lrho=log(rho);
   lpda=log(pda);
run;

proc insight data=c.neutral1;
run;

********* end of program neutral1.sas  ****************************************;
