/* Programm zur molekular-dynamischen Untersuchung
   von Austenit-Martensit Phasenbergngen in 2 D.
   Von Oliver Kastner
   Fakultt III 
   Fachgruppe Thermodynamik Prof. Mller
   Technische Universitt Berlin
   email: o.kastner@olli-kastner.de 

   Copyright (C) 2004  Oliver Kastner

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or any later version. 

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details. 

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  


Hinweise zum Compilieren dieser Datei:
--------------------------------------

Das Programm verwendet die Programmbibliothek
OpenGL (oder MesaGL), sowie das OpenGL Utility Toolkit (GLUT) 
von Mark Kilgard. 
Beide Bibliotheken knnen aus dem Internet bezogen werden. 
Siehe dazu im Internet:
http:www.opengl.org
Diese Bibliotheken unterliegen eigenen Copyright- und Lizenzbestimmungen.
 
*/

#include "./kristall2D.h"

/* *************************************************** */

int main( int argc, char *argv[] )
{
  char *c, s[40],name[]="ollis test";
  int i,k;
  double eps, sig; /*Zu Kontrollezwecken*/

  /* Einlesen der Materialdaten und Steuerparamater aus parameter.dat */
  eingabe(&mu0, &sig0, &eps0, &typ, &dt, &v0, &g, 
	  &nstep, &methode, &abbruch, &fix, &dehnfix, &ds, 
	  &kp, &kt0, &kistenschalter);

  /*Einlesen der Anfangspositionen*/
  nullage(tvek,&nt,&boxx1, &boxx2, &boxy1, &boxy2);
  printf("nt ist:%i",nt);

  /*Wg. Entdimensionalisierung*/
  tau0=2.0*PI/sqrt(57.15)*sqrt(sig0*sig0*mu0/eps0);
  dimlos=pow(tau0,2)*eps0/pow(sig0,2)/mu0; 
  sprintf(stringtau0,"%.3g", tau0);
  printf("tau0=%g\t dimlos=%f\n", tau0, dimlos);
  /*Skalierung der Ausgabe-Plots*/
  ekinfak=2.0e+1;
  epotfak=1.0e+3;
  kkfak=1.0e+0;

  /*Initialisierung der Fenster*/
  window_init( argc, argv);
  
  /*Programmzustand. methode==1: Rechnung; methode!=1: Filmwiedergabe*/
  if(methode==1) /*Simulationsrechnung*/
  {
    energiedatei=fopen(aus2, "w"); /*Speichern von thermodynamischen Gren*/
    filmdatei=fopen(aus1,"w");		/*Speichern der Daten zur spteren Wiedergabe*/

    /*Alles, was von Dateien kommt*/
    /*Reihenfolge IST wichtig!*/
    lastrandlage(lastrand, &ntlr);	  /*Atome, in lastkontrollierten Versuchen belastet werden*/
    dehnrandlage(dehnrand, &ntdr);	  /*Atome, in dehnkontrollierten Versuchen belastet werden*/
    fixrandlage(fixrand, &ntfr);	  /*Atome, die zeitlich fixiert sind*/
    subsyslage(subsys, &nte);		  /*Atme, welche einen Teilkrper bilden*/
    lagerlage(lager, &ntl);			  /*Atome, deren Freiheitsgrad eingeschrnkt wird (^= "Lageratome")*/

    /* Anfangsbedingung aus Anfangsgeschwindigkeit */
    ab(tvek,v0);					  /*Erster Iterationsschritt (Anfangsbed. der Geschwindigkeiten)*/

    /* Energieauswertung nach erstem Iterationsschritt*/
    schreibrmat(); /*Abstandsmatrix*/
    scherwinkel(tvek, matrix,&winkel);/*Schwerwinkel einer ausgewhlten Zelle*/
    nl=tvek[atomA][0]- tvek[atomB][0];/*Anfangsabstand zweier ausgewhlter Teilchen*/
    printf("nl=%f\n", nl);
    energieberechnung();			  /*Berechnung thermodynamischer Gren*/
    disp=0.0;

 
    zeit+=dt;

    /*Einstieg in Iterationsschleife. Alle weiteren Zeitschritte werden in der 
	  Sub-Routine idle veranlat*/
    animation();

    /* Ende und Tsch*/
    fclose(filmdatei);
    fclose(energiedatei);

    
  }
  else /*Wiedergabe bereits vorhandener Rechnungen*/
    {
      
      filmdatei=fopen(aus1,"r");	/*ffne die Filmdatei*/
      projektor_init();					/*Initiallisierung der Wiedergabe*/
      animation();						/*Wiedergabe*/
      /* Ende und Tsch*/
      fclose(filmdatei);
    }
  printf("Programmende!\n");
  return 0;
}




/******************************************************/
/*****************  Funktionen    *********************/
/******************************************************/

static void Idle( void )
{
  int i,j,k, d, h, m, s;
  char c;
  double swinkel;

  /* unterbrecher: Unterbricht das Programm. Wird mit 'w' gesteuert */
  /* unterbrecher ==1 : Pause */
  /* unterbrecher ==0 : Weiter */
  if (unterbrecher==0)
    {
      if(methode==1) /*Simulationsrechnung*/
	{
	  /*hist, klemmhist indizieren die Vektoren, welche die Diagrammdaten enthalten.
	  Wenn der Vektoren voll und damit die Graphen am rechten Diagrammende sind, 
	  wird von vorn neu beschrieben. 
	  Rcksetzen der Plothistory*/
	  if(hist==2100)
	    hist=0;	  
	  if(klemmhist==20000)
	    klemmhist=0;

	  fixieren();	/*Merke die Positionen ausgewhlter Atome vor einem Zeitschritt*/

	  if(schalter==1) /*zwischen Last- und Dehnungskontrole
			      Lastkontrolle: schalter=0 
                  Dehnungskontrolle(default): schalter=1*/
	    { 
	      dehnx=+dehns; /*Dehnschritt aller Atome in dehnrand.dat*/
	      dehny=+dehns;
	    } 
	  else if (schalter==0)
	    {
	      lastx+=lasts;/*Lastschritt aller Atome in lastrand.dat*/
	    }


/*Wir rechnen immer nstep Zeitschritte und mitteln die Gren
  klemmkraft, ekinzm, ekinzmcc, ekinsubsyszm, epotzm, epotsubsyszm,
  disp und winkel arithmetisch ber diesen Zeitraum.*/
	  klemmkraft=0.0;
	  ekinzm=0.0;
	  ekincczm=0.0;
	  epotzm=0.0;
	  ekinsubsyszm=0.0;
	  epotsubsyszm=0.0;
	  disp=0.0;
	  winkel=0.0;
	  
	  /*Jetzt werden nstep Zeitschritte berechnet.*/
	    for(k=0;k<nstep;k++)    
	      { 
		    /*Core!*/
			schreibrmat();		/*Berechnung der Abstandsmatrix*/		     
			schritt(tvek,typ,matrix,g);				/*Berechnung der neuen Atompositionen*/
			if(kistenschalter==1)
				{
					kiste(tvek);
				}
			energieberechnung();					/*Berechnung der thermodynamischen Gren*/

			ekinzm+=ekin;
			epotzm+=epot;
			ekincczm+=ekincc;

			ekinsubsyszm+=ekinsubsys;
			epotsubsyszm+=epotsubsys;


			disp+=tvek[atomA][0]-tvek[atomB][0]-nl; /*Berechnung der Verschiebung ausgewhlter Teilchen*/
			scherwinkel(tvek, matrix,&swinkel);		/*Scherwinkel einer ausgewhlten Zelle*/
			winkel+=swinkel;
			zeit+=dt;								/*Inkrementierung der dim'losen Zeit*/
			schrittzaehler++;						/*Zhler fr gerechnete Zeitschritte*/ 
	      } /*Ende for(k=0->nstep)*/

		waerme(tvek,q);			/*Heizen, Khlen: Nach jeden nstep'en Zeitschritt*/

		/*Auswertungen der Megren*/
		/*Macht aus den summatorischen Gren  Zeitmittel-Gren:*/
 	    ekinzm=ekinzm/((double)nstep);					
	    ekincczm=ekincczm/((double)nstep);
 	    epotzm=epotzm/((double)nstep);
	    ekinsubsyszm/=((double)nstep);
	    epotsubsyszm/=((double)nstep); 
	    disp/=((double)nstep);
	    winkel/=((double)nstep);
	    klemmkraft=klemmkraft/((double)nstep);
	    temp=1.0/KB*mu0*pow(sig0/tau0,2)*ekincczm/((double)nt); /*Temperatur*/

		/*Speichern in Dateien*/
		if (ds == 1) 
		{
		  schreibe_energie(energiedatei);
		  schreibe_film(filmdatei);
		}


	    /*Einige Vorbereitungen fr die graphische Ausgabe:*/
	    sprintf(stringkt,"%3.6f",ekincczm/((double)nt));
	    sprintf(stringtemp,"%7.2f",temp);   
	    sprintf(stringrechenschritte,"%10i",schrittzaehler);
	    sprintf(stringwinkel,"%4.2f", winkel);
	    sprintf(stringload, "P = %5.2f", klemmkraft);
	    sprintf(stringstrain, "Dehnung= %5.4f Prozent", disp/nl);


     	/*Plotvektoren*/

	    ekinhist[hist]=ekinzm;       
	    ekinhistcc[hist]=ekincczm; 
	    epothist[hist]=epotzm;
	    dehnhist[klemmhist]=disp;
	    klemmkrafthist[klemmhist]=klemmkraft;
		/*Verschiebung der Bildschirm-Plots, so da alles im Bild bleibt*/
		if( ((ekinfak*(ekincczm-ekincc0)/ekincc0+60.0)>105.0) || 
		((ekinfak*(ekincczm-ekincc0)/ekincc0+60.0)<0.0) ) 
			ekincc0=ekincczm;       
		if( ((epotfak*(epotzm-epot0)/epot0+60.0)>105.0) || 
		((epotfak*(epotzm-epot0)/epot0+60.0)<0.0) )
			epot0=epotzm;

		/*Im Falle von Dehn-Kontrolle: Berechnung der freien Energie*/
	    if(schalter==1)
	      f+=klemmkraft*dehns;
		      
	    /*Zeitachse der Bildschirmplots*/
	    /*Bemerkung: nstep Zeitschritte werden gemittelt*/
	    /*und ergeben einen Zeitschritt auf der Plotachse*/
     	hist++;
	    klemmhist++;
      


	    /*Temperaturregelung. Wir fhren den Heiz/Khl-Faktor
		proportional zur  Temperaturabweichung von der Solltemperatur nach.
		Parameter:
		Proportionalittsfaktor: Kp (Definition in parameter.dat)
		Solltemperatur: kt0 (Definition in parameter.dat)*/
     	qregel(&q);

	    
		/*Automatisches Programmende, falls maximale Anzahl 
		von Zeitschritten erreicht ist (parameter abbruch aus parameter.dat)...*/
		if (schrittzaehler==abbruch)
	      exit(0);
		/*...oder falls maximale Dehnung erreicht ist.*/
		if((disp/nl)>0.25)
			exit(0);
	      
	}/*Ende Methode 1: Simulationsrechnung*/


    else /*Programm liest Rechendaten aus film.dat ein und stellt diese graphisch dar.*/
	{
		  	  /*Rcksetzen der Plothistory*/
	  if(hist==2100)
	    hist=0;	  

	  if(klemmhist==20000)
	    klemmhist=0;
	  projektor(); /*Projektor ist die Sub-Routine, welche ein Einzelbild einliest.*/
	  ekinhistcc[hist]=ekincczm;
	  epothist[hist]=epotzm;
	  dehnhist[klemmhist]=tvek[atomA][0]-tvek[atomB][0]-nl;
	  klemmkrafthist[klemmhist]=klemmkraft;
	  sprintf(stringtemp,"%3.6f",ekincczm/((double)nt));
	  sprintf(stringrechenschritte,"%10i",schrittzaehler);
	  sprintf(stringload, "P = %5.2f", klemmkraft);
	  disp=tvek[atomA][0]-tvek[atomB][0]-nl;
	  sprintf(stringstrain, "Dehnung= %5.2f Prozent", disp/nl*100.0);
	  temp=1.0/KB*mu0*pow(sig0/tau0,2)*ekincczm/((double)nt); 
 	  sprintf(stringtemp,"%7.2f",temp);
	  sprintf(stringkt,"%3.6f",ekincczm/((double)nt));

	  if( ((ekinfak*(ekincczm-ekincc0)/ekincc0+60.0)>105.0) || 
	  ((ekinfak*(ekincczm-ekincc0)/ekincc0+60.0)<0.0) ) 
	ekincc0=ekincczm; 
      
      if( ((epotfak*(epotzm-epot0)/epot0+60.0)>105.0) || 
	  ((epotfak*(epotzm-epot0)/epot0+60.0)<0.0) )
	epot0=epotzm;

	  hist++;
	  klemmhist++;	  
	}/*Ende Methode Filmwiedergabe*/	  

      glutPostRedisplay();
    }

  else  /*unterbrecher==1: Pause*/
    glutPostRedisplay();
  
}

/***************************************************************************************/
void window_init(int argc, char *argv[]) /*OpenGL-Steuerung*/
{
  int w,h;
  glutInit( &argc, argv );

  /*Window 0:In diesem Fenster die Teilchen*/
  w=20*(fabs(boxx1)+fabs(boxx2));
  h=20*(fabs(boxy1)+fabs(boxy2));
  printf("w=%i\th=%i\n", w, h);
  glutInitWindowPosition(10, 10);
  glutInitWindowSize(w, h);
  glutInitDisplayMode( GLUT_RGB | GLUT_DOUBLE /*| GLUT_DEPTH */);
  fensterid[0]=glutCreateWindow("Animation");
  
  /*Window 1: kin. Energie = Temperatur*/ 
  glutInitWindowPosition(612, 10);
  glutInitWindowSize( 400, 220 );
  glutInitDisplayMode( GLUT_RGB | GLUT_DOUBLE /*| GLUT_DEPTH */);
  fensterid[1]=glutCreateWindow("Mittlere kinetische Energie vs. Zeit");
  
  /*Window 2: pot. Energie */ 
  glutInitWindowPosition(612, 265);
  glutInitWindowSize( 400, 220 );
  glutInitDisplayMode( GLUT_RGB | GLUT_DOUBLE /*| GLUT_DEPTH */);
  fensterid[2]=glutCreateWindow("Mittlere potentielle Energie vs. Zeit");
  
  /*Window 3: Last-Dehnung */ 
  glutInitWindowPosition(612, 510);
  glutInitWindowSize( 400, 220 );
  glutInitDisplayMode( GLUT_RGB | GLUT_DOUBLE /*| GLUT_DEPTH */);
  fensterid[3]=glutCreateWindow("Last vs. Deformation");

  /*Window 4: Kontrolle I: Ausgaben*/ 
  glutInitWindowPosition(0, h+50);
  glutInitWindowSize( 600, 200 );
  glutInitDisplayMode( GLUT_RGB | GLUT_DOUBLE /*| GLUT_DEPTH */);
  fensterid[4]=glutCreateWindow("Kontrolle");

}
/* ****************************************************/

static void Reshape( int width, int height )/*OpenGL-Steuerung*/
{
   glViewport( 0, 0, width, height );
   glMatrixMode( GL_PROJECTION );
   glLoadIdentity();
   glFrustum(boxx1,boxx2,boxy1,boxy2, 
	     12.0, FAR);
   glMatrixMode( GL_MODELVIEW );
   glLoadIdentity();
    glTranslatef( 0.0, 0.0,STATIVPOS);
}

/* *************************************************** */

static void Reshape_ekin( int width, int height )/*OpenGL-Steuerung*/
{
   glViewport( 0, 0, width, height );
   glMatrixMode( GL_PROJECTION );
   glLoadIdentity();
   glFrustum(0.0,630.0,0.0, 100.0, 
	     NEAR, FAR);
   glMatrixMode( GL_MODELVIEW );
   glLoadIdentity();
   glTranslatef( 0.0, 0.0,-STATIVPOS);
}
/* *************************************************** */

static void Reshape_epot( int width, int height )/*OpenGL-Steuerung*/
{
   glViewport( 0, 0, width, height );
   glMatrixMode( GL_PROJECTION );
   glLoadIdentity();
   glFrustum(0.0,630.0,0.0, 100.0, 
	     NEAR, FAR);
   glMatrixMode( GL_MODELVIEW );
   glLoadIdentity();
   glTranslatef( 0.0, 0.0,-STATIVPOS);
}


/* *************************************************** */

static void Reshape_ld( int width, int height )/*OpenGL-Steuerung*/
{
   glViewport( 0, 0, width, height );
   glMatrixMode( GL_PROJECTION );
   glLoadIdentity();
   glFrustum(-8.0,8.0,-100.0, 100.0, 
	     NEAR, FAR);
   glMatrixMode( GL_MODELVIEW );
   glLoadIdentity();
   glTranslatef( 0.0, 0.0,-STATIVPOS);
}
/* *************************************************** */

static void Reshape_control( int width, int height )/*OpenGL-Steuerung*/
{
   glViewport( 0, 0, width, height );
   glMatrixMode( GL_PROJECTION );
   glLoadIdentity();
   glFrustum(0.0,600.0,100.0,290.0, 
	     NEAR, FAR);
   glMatrixMode( GL_MODELVIEW );
   glLoadIdentity();
   glTranslatef( 0.0, 0.0,-STATIVPOS);
}
/* *************************************************** */

void animation()/*OpenGL-Steuerung*/
{

   /*Erstes Fenster: Animation*/
   glutSetWindow(fensterid[0]);
   Init();
   glutIdleFunc(Idle); 
   glutDisplayFunc(Display);
   glutReshapeFunc( Reshape );
   glutKeyboardFunc( Key );
   glutSpecialFunc( SpecialKey );

   /*Zweites Fenster: Kin. Energie vs. Zeit*/ 
   glutSetWindow(fensterid[1]);
   Init();
   glutDisplayFunc(Display_ekin);
   glutReshapeFunc( Reshape_ekin );
   glutKeyboardFunc( Key );
   glutSpecialFunc( SpecialKey );

   /*Drittes Fenster: Pot. Energie vs. Zeit*/ 
   glutSetWindow(fensterid[2]);
   Init();
   glutDisplayFunc(Display_epot);
   glutReshapeFunc( Reshape_epot );
   glutKeyboardFunc( Key );
   glutSpecialFunc( SpecialKey );

   /*Viertes Fenster: Last vs. Dehnung*/
   glutSetWindow(fensterid[3]);
   Init();
   glutDisplayFunc(Display_ld);
   glutReshapeFunc( Reshape_ld );
   glutKeyboardFunc( Key );
   glutSpecialFunc( SpecialKey );

   /*Fnftes Fenster: Kontrolle*/
   glutSetWindow(fensterid[4]);
   Init();
   glutDisplayFunc(Display_control);
   glutReshapeFunc( Reshape_control );
   glutKeyboardFunc( Key );
   glutSpecialFunc( SpecialKey );

   glutMainLoop();
}

/* *************************************************** */

/*In dieser Sub-Routine wird das zu zeigende Bild aus OpenGL-Komponenten
  zusammengestellt*/

static void Display( void )
{
  int i, j, k;

   glClear( GL_COLOR_BUFFER_BIT );

   glLoadIdentity();
   gluLookAt(0.0,0.0,14.0,0.0,0.0,0.0,0.0,1.0,0.0);
   

   /*Die Kiste:*/
   glPushMatrix();
   if(q==1.0){
     glColor3f(1.0, 1.0, 1.0);
	 pstr="Adiabat";
   }
   else if(q<1.0){
     glColor3f(0.0, 0.0, 1.0);
	 pstr="Kuehlen";	
   }
   else{
     glColor3f(1.0, 0.0, 0.0);
	 pstr="Heizen";
	}	
	if(unterbrecher==1)
		pstr="Pause";
   glPushMatrix();
   glRasterPos2f(0,boxy2+OFFSET);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_18, pstr);
   glPopMatrix(); 

   glBegin(GL_LINE_STRIP);
     glVertex3d(boxx1-R, boxy1-R,0.0);
     glVertex3d(boxx2+R, boxy1-R,0.0);
     glVertex3d(boxx2+R, boxy2+R,0.0);
     glVertex3d(boxx1-R, boxy2+R,0.0);
     glVertex3d(boxx1-R, boxy1-R,0.0);
   glEnd();
   glPopMatrix();
 
   glPushMatrix();
   glColor3f(1.0, 1.0, 1.0);
   if(schalter==1)
	pstrld="Deformationskontrolle";
   else if (schalter==0)
	pstrld="Lastkontrolle";
   else 
	pstrld="Temperaturkontrolle";
   glRasterPos2f(-boxx2,boxy2+OFFSET);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_18, pstrld);
   glPopMatrix(); 



   /*Der Krper bewegt sich, aber wir fhren die Kamera mit! 
    Kiste wird mit SP mitbewegt und mit Drehwinkel mitgedreht! 6.12.2001*/
/*    glTranslated(spx, spy, 0.0); */
   if(kistenschalter==1)
   {
    winkelsp=0.0;
    spx=0.0;
    spy=0.0;
   }
   
    glRotated(-winkelsp/PI*180.0, 0, 0, 1.0); 

   /*Die Teilchen:*/
   for(i=0;i<nt;i++)
    {
      glPushMatrix();
      /*Farbzuordnung*/
      /*Zuerst gelb und rot:*/
      if(farbe[i]=='g')
	glColor3f(1.0, 1.0, 0.0);
      else
	glColor3f(1.0, 0.0, 0.0);
      
      /*_unten_ fixierte Teilchen sind blau;*/
      /*das sind die reihenbreite ersten Teilchen*/
      if (fix!=0)
	{
	  for(k=0;k<ntfr;k++)
	    if (i==fixrand[k])
	      glColor3f(0.0, 0.0, 1.0);
	}
      /*_oben fixierte Teilchen sind blau*/
      if (dehnfix==1)
	{
	  for(k=0;k<ntdr;k++)
	    if (i==dehnrand[k])
	      glColor3f(0.0, 0.0, 1.0);
	}
      


      /*Die Esambleatome bekommen eine Extra-Farbe.*/
      for(k=0;k<nte;k++)
	if(i==subsys[k])
	  {
	    if(farbe[i]=='g')
	      glColor3f(1.0, 1.0, 0.7);
	    else
	      glColor3f(1.0, 0.6, 0.4);
	  }

      for(k=0;k<ntlr;k++) 
	{ 
	  /*_oben fixierte Teilchen sind blau*/ 
	  /* 	  if (dehnfix==1) */
	  /* 	    { */
	  /* 		if (i==dehnrand[k]) */
	  /* 		  glColor3f(0.0, 0.0, 1.0); */
	  /* 	    } */
	  
	  
	  /*belastete Teilchen*/
	  if (lastx !=0.0 || lasty != 0.0)
	    {
	      /*positive Belastung: hellblau*/
	      if ((lastx>0.0) || (lasty>0.0))
		{
		  if (i==lastrand[k])
		    glColor3f(0.0, 1.0, 1.0);
		}
	      /*negative Belastung: wei*/
	      else
		{
		  if (i==lastrand[k])
		    glColor3f(1.0, 1.0, 1.0);
		}
	    }
	}
      
      /*Abbildung der Teilchen als runde Punkte:*/
      glPointSize(PSIZE);
      glBegin(GL_POINTS);
      glVertex2d(tvek[i][0]-spx,tvek[i][1]-spy);
      glEnd(); 
      
      glPopMatrix();
    }    /*Ende for-Schleife Teilchen*/

   /*Markierung der Primrzelle*/
 	
      glColor3f(1.0, 1.0, 0.0);
      glBegin(GL_LINE_STRIP);
      glVertex2d(tvek[markiere[0]][0]-spx,tvek[markiere[0]][1]-spy);
      glVertex2d(tvek[markiere[1]][0]-spx,tvek[markiere[1]][1]-spy);
      glVertex2d(tvek[markiere[2]][0]-spx,tvek[markiere[2]][1]-spy);
      glVertex2d(tvek[markiere[3]][0]-spx,tvek[markiere[3]][1]-spy);
      glVertex2d(tvek[markiere[0]][0]-spx,tvek[markiere[0]][1]-spy);
      glEnd(); 
 

   glutPostRedisplay();
   glutSwapBuffers();
}
/* ****************************************************/

static void Display_control( void )
{

  int j,k;
  glClear( GL_COLOR_BUFFER_BIT );
   glColor3f(1.0, 1.0, 1.0);
   glRasterPos2f(10.0,320.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, 
     "Charakteristische Groessen:");
   glRasterPos2f(10.0,300.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12,
		    "mu0 =                                   eps0 =");
  glRasterPos2f(60.0,300.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, stringmu0);
  glRasterPos2f(140.0,300.0);
      DrawBitmapString(GLUT_BITMAP_HELVETICA_12,"kg");
  glRasterPos2f(280.0,300.0);
      DrawBitmapString(GLUT_BITMAP_HELVETICA_12,stringeps0);
  glRasterPos2f(360.0,300.0);
      DrawBitmapString(GLUT_BITMAP_HELVETICA_12,"J");
   glRasterPos2f(  10  ,285.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, 
     "sig0 =                                   tau0 =");
  glRasterPos2f(60.0,285.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, stringsig0);
  glRasterPos2f(140.0,285.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12,"m");
  glRasterPos2f(280.0,285.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, stringtau0);
  glRasterPos2f(360.0,285.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, "s");

   glRasterPos2f(10.0,265.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, 
     "Paare der Sorten     A-A       B-B       A-B");
   glRasterPos2f(10.0,250.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, 
     "       epsilon:");
   glRasterPos2f(10.0,235.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, 
     "         sigma:");
   glRasterPos2f(10.0+135.0,250.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, stringepsAA);
   glRasterPos2f(10.0+135.0,235.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, stringsigAA);
   glRasterPos2f(10.0+200.0,250.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, stringepsBB);
   glRasterPos2f(10.0+200.0,235.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, stringsigBB);
   glRasterPos2f(10.0+265.0,250.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, stringepsAB);
   glRasterPos2f(10.0+265.0,235.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, stringsigAB);


   if((pow(vx,2)+pow(vy,2))!=0.0)
     {
       glRasterPos2f(10,210.0);
       glColor3f(1.0, 1.0, 1.0);
	   if(kistenschalter==1)
	       DrawBitmapString(GLUT_BITMAP_HELVETICA_12, "(Inertial System)");
	   else
		   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, "(Bewegtes System)");
     }
   glRasterPos2f(200.0,210.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, "Zeitschritte =");
   glRasterPos2f(350.0,210.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, stringrechenschritte);


   glRasterPos2f(10.0,180.0);
   glColor3f(1.0, 1.0, 1.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, "kT(dim'less)=");
   glRasterPos2f(110.0,180.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, stringkt);
   glRasterPos2f(10.0,160.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, "T =");
   glRasterPos2f(110.0,160.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, stringtemp);
   glRasterPos2f(170.0,160.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, "K");
   glRasterPos2f(300.0,160.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, stringload);
   glRasterPos2f(400.0,160.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, stringstrain);
   glRasterPos2f(10.0,140.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, "Scherwinkel =");
   glRasterPos2f(110.0,140.0);
   DrawBitmapString(GLUT_BITMAP_HELVETICA_12, stringwinkel);

   glPushMatrix();


  glutPostRedisplay();
  glutSwapBuffers();


}

/* *************************************************** */
static void Display_ekin( void )
{
  int j,k;
  double z;

  glClear( GL_COLOR_BUFFER_BIT );
  /*Hintergrundfarbe*/
  glClearColor( 0.4, 0.4, 0.4, 0.0 );
  /*Das Raster:*/
  glColor3f( 0.6, 0.5, 0.5 );
  glBegin( GL_LINES );
  for ( j = 0 ; j < 110 ; j += 10 )
    {
      glVertex2i( 0, j );
      glVertex2i( 700, j );
    }
  glEnd();

  

  /*Die mittlere kinetische Energie (Memittel!) der Exzegeschwindigkeiten  in rot:*/
  glColor3f(1.0, 0.0, 0.0);	  
  glBegin(GL_LINE_STRIP);
  for(k=0;k<hist;k++)
    {
      glVertex2d((double)k*0.33, ekinfak*(ekinhistcc[k]-ekincc0)/ekincc0 +60.0);
    }
  glEnd();



  glutPostRedisplay();
  glutSwapBuffers();
}
/* ****************************************************/

static void Display_epot( void )
{

  int j,k;
  glClear( GL_COLOR_BUFFER_BIT );
  /*Hintergrundfarbe*/
  glClearColor( 0.4, 0.4, 0.4, 0.0 );
  /*Das Raster:*/
  glColor3f( 0.6, 0.5, 0.5 );
  glBegin( GL_LINES );
  for ( j = 0 ; j < 110 ; j += 10 )
    {
      glVertex2i( 0, j );
      glVertex2i( 700, j );
    }
  glEnd();


  /*Der Plot in gelb:*/
  glColor3f(1.0, 1.0, 0.0);	  
  glBegin(GL_LINE_STRIP);
  for(k=0;k<hist;k++)
    {
      glVertex2d((double)k*0.33, -epotfak*(epothist[k]-epot0)/epot0+60.0);
    }
  glEnd();

  glutPostRedisplay();
  glutSwapBuffers();


}
/* ****************************************************/

static void Display_ld( void )
{

  int i,j,k;
  glClear( GL_COLOR_BUFFER_BIT );
  /*Hintergrundfarbe*/
  glClearColor( 0.4, 0.4, 0.4, 0.0 );
  /*Das Raster:*/

  glBegin( GL_LINES );

      for ( j = -100 ; j < 110 ; j += 10 )
	{
	  if(j==0)
	    {
	      glColor3f( 0.0, 0.5, 0.5 );
	      glVertex2i( -8, j );
	      glVertex2i( 8, j );

	    }
	  else
	    {
	      glColor3f( 0.6, 0.5, 0.5 );
	      glVertex2i( -8, j );
	      glVertex2i( 8, j );
	    }

	}
      for (i=-8;i<9;i++)
	{
	 
	  if(i==0)
	    {
	      glColor3f( 0.0, 0.5, 0.5 );
	      glVertex2i( i, -100 );
	      glVertex2i( i, 100 );
	    }
	  else
	    {
	      glColor3f( 0.6, 0.5, 0.5 );
	      glVertex2i( i, -100 );
	      glVertex2i( i, 100 );
	    }
	}
      glEnd();
   
  /*Der Plot in gelb:*/
  glColor3f(1.0, 1.0, 0.0);	  
  glBegin(GL_LINE_STRIP);
  for(k=0;k<klemmhist;k++)
    {
	  if(schalter==1)
		glVertex2d(dehnhist[k]/(double)nl*32.0,kkfak*klemmkrafthist[k]);
	  else
		glVertex2d(dehnhist[k]/(double)nl*32.0,kkfak*klemmkrafthist[k]);
    }

  glEnd();

  glutPostRedisplay();
  glutSwapBuffers();


}


/* *************************************************** */

static void Key( unsigned char key, int x, int y )
{
   switch (key) {
   /*kontrolliert Parameter-Update auf Slave*/
   case 'k':     
     q=0.999;
     break;

   case 'K':     
     q=0.975;
     break;
   
   /*Adiabasie*/
   case 'a':      
     q=1.0; 
     break;

   /*Heizen ein*/
   case 'h':     
     q= 1.001; 
     break;

   case 'H':      
     q= 1.005; 
     break;

   case 'c':
     printf("Temperaturregelung ein!\n");
     tempregel=1; 
     break;

   case 'C':
     printf("Temperaturregelung aus!\n");
     tempregel=-1;
     q=1.0;
     break;

   /*Erzwingt Einlesen der Parameter-Datei*/
   case 'r':
     eingabe(&mu0, &sig0, &eps0, &typ, &dt, &v0, &g, 
	  &nstep, &methode, &abbruch, &fix, &dehnfix, 
	  &ds, &kp, &kt0, &kistenschalter);
     break;

   /*Fixieren der Futeilchen*/
   case 'f':
     fix=1;
     break;
   /*Entbinden der Futeilchen*/
   case 'F':
     fix=0;
     break;

   /*Fixieren der Kopfteilchen*/
	 case 'b':
	 dehnfix=1;
     break;
   /*Entbinden der Kopfteilchen*/
     case 'B':
     dehnfix=0;
     break;
   /*Umkehrung der Dehnrichtung*/
     case 'u':
     dehns=-1.0*dehns;
     lasts=-1.0*lasts;
     break;
   /*Erhhung der Belastung in positive x-Richtung*/
    case 'p':
	 schalter=0;
	 fix=1;
	 lasts=LASTSCHRITT;
     break;
   /*Abschalten von Last- und Deformationszuwachs*/
   case '0':
     lasts=0.0;
     dehns=0.0;
     break;

   /*Erhhung der Dehnung in positive x-Richtung*/
  case 'd':
     schalter=1;
	 fix=1;
	 dehnfix=1;
	 dehns=DEHNSCHRITT;
     break;
   /*Schreibe die _aktuelle_Lage auf File*/
   case 's': 
	 schreibe_lage(lagendatei); 
	 break;

   /*Unterbreche den Programmablauf*/
   case 'w': 
     if(unterbrecher==0) 
       unterbrecher=1;
     else unterbrecher=0;
     break;

	/*Nchster Frame in Wiedergabe*/
   case 'n': 
	 projektor();
	 ekinhistcc[hist]=ekincczm;
	 epothist[hist]=epotzm;
	 dehnhist[klemmhist]=tvek[lastrand[0]][0]-nl;
	 klemmkrafthist[klemmhist]=klemmkraft;
	 sprintf(stringtemp,"%3.6f",ekincczm/((double)nt));
	 sprintf(stringrechenschritte,"%10i",schrittzaehler);
	 temp=1.0/KB*mu0*pow(sig0/tau0,2)*ekincczm/((double)nt); 
 	 sprintf(stringtemp,"%7.2f",temp);
	 sprintf(stringkt,"%3.6f",ekincczm/((double)nt));
     break;
   case 'V': 
	 ekinfak*=10.0;
	 epotfak*=10.0;
     break;
   case 'v': 
	 ekinfak/=10.0;
	 epotfak/=10.0;
     break;
   case '+': 
	 kkfak*=10.0;
     break;
   case '-': 
	 kkfak/=10.0;
     break;
  case 'q': 
	 exit(0);
     break;
       
   /*Alle brigen: nix*/
   default:		
     break;
   } 
   glutPostRedisplay(); 
} 

/* *************************************************** */

static void SpecialKey( int key, int x, int y )
{
   switch (key) {
      case GLUT_KEY_UP:
         break;
      case GLUT_KEY_DOWN:
         break;
      case GLUT_KEY_LEFT:
         break;
      case GLUT_KEY_RIGHT:
         break;
   }
   glutPostRedisplay();
}


/* *************************************************** */

static void Init( void )
{
   glEnable(GL_POINT_SMOOTH);
   glClearColor(0.0,0.0, 0.0, 0.0);
   glMatrixMode( GL_PROJECTION );
}



/* *************************************************** */

void eingabe (double *pmu0, double *psig0, double *peps0,
	      struct mattyp *ptyp, 
	      double *pdt, double *pv0, double *pg, 
	      int *pnschritt, int *pmethode, int *pabb,
	      int *pfix, int *pdehnfix, int *pds,
	      double *pkp, double *pkt0, int *pkistenschalter)
{
FILE *liesdat1;
char s[40];
double dummy;

  liesdat1=fopen(ein1, "r");

  fscanf(liesdat1,"%s", s);
  fscanf(liesdat1,"%s", s);
  fscanf(liesdat1,"%s", s); 
  fscanf(liesdat1,"%s", s);
  fscanf(liesdat1,"%lf %lf %lf",pmu0,psig0,peps0);


  fscanf(liesdat1,"%s", s);
  fscanf(liesdat1,"%s", s);
  fscanf(liesdat1,"%s", s); 
  fscanf(liesdat1,"%lf %lf %lf", &(ptyp->eps1), &(ptyp->sig1), &(ptyp->m1));
  fscanf(liesdat1,"%s", s); 
  fscanf(liesdat1,"%s", s);
  fscanf(liesdat1,"%lf %lf %lf", &(ptyp->eps2), &(ptyp->sig2), &(ptyp->m2));
  fscanf(liesdat1,"%s", s); 
  fscanf(liesdat1,"%s", s);
  fscanf(liesdat1,"%lf %lf", &(ptyp->eps12), &(ptyp->sig12));
  fscanf(liesdat1,"%s", s); 
  fscanf(liesdat1,"%s", s);

  fscanf(liesdat1,"%lf", pdt);
  fscanf(liesdat1,"%s", s); 
  fscanf(liesdat1,"%s", s);
  fscanf(liesdat1,"%lf", pv0);
  fscanf(liesdat1,"%s", s); 
  fscanf(liesdat1,"%s", s);
  fscanf(liesdat1,"%lf", pg);
  fscanf(liesdat1,"%s", s); 
  fscanf(liesdat1,"%s", s);

  fscanf(liesdat1,"%i", pnschritt);
  fscanf(liesdat1,"%s", s); 
  fscanf(liesdat1,"%s", s);
  fscanf(liesdat1,"%i %i", pmethode, pds);
  fscanf(liesdat1,"%s", s); 
  fscanf(liesdat1,"%s", s);
  fscanf(liesdat1,"%i", pabb);
  fscanf(liesdat1,"%s", s); 
  fscanf(liesdat1,"%s", s);
  fscanf(liesdat1,"%i %i ", pfix, pdehnfix);
  fscanf(liesdat1,"%s", s); 
  fscanf(liesdat1,"%s", s);
  fscanf(liesdat1,"%s", s);

  fscanf(liesdat1,"%lf %lf", pkp, pkt0);
  fscanf(liesdat1,"%s", s);
  fscanf(liesdat1,"%s", s); 
  fscanf(liesdat1,"%s", s); 

  fscanf(liesdat1,"%i", pkistenschalter);



  fclose(liesdat1);
  
  sprintf(stringepsAA,"%.3f", ptyp->eps1);
  sprintf(stringepsBB,"%.3f", ptyp->eps2);
  sprintf(stringepsAB,"%.3f", ptyp->eps12);
  sprintf(stringsigAA,"%.3f", ptyp->sig1);
  sprintf(stringsigBB,"%.3f", ptyp->sig2);
  sprintf(stringsigAB,"%.3f", ptyp->sig12);
  sprintf(stringdt,"%.3f", *pdt);
  sprintf(stringmu0,"%.3g", *pmu0);
  sprintf(stringsig0,"%.3g", *psig0);
  sprintf(stringeps0,"%.3g", *peps0);
  sprintf(stringnstep,"%i", *pnschritt);


}

/* *************************************************** */


void nullage (double ptvek[N][4], int *pnt, 
	      double *pboxx1, double *pboxx2,
	      double *pboxy1, double *pboxy2)
{
  FILE *liesdat2;
  char s[60],c;
  int counter,dummi,j;
  double x,y,dummy ;

  liesdat2=fopen("nullage.dat", "r");
  fscanf(liesdat2,"%s", s);
  fscanf(liesdat2,"%i %i %i %i %i", 
	 &markiere[0], &markiere[1], &markiere[2], &markiere[3], &markiere[4]);
  fscanf(liesdat2,"%s", s);
  fscanf(liesdat2,"%i %i", &atomA, &atomB);
  atomA-=1; atomB-=1;
  fscanf(liesdat2,"%s", s);
  fscanf(liesdat2,"%lf %lf %lf %lf",pboxx1, pboxx2, pboxy1, pboxy2);
  fscanf(liesdat2,"%s", s);  
  fscanf(liesdat2,"%s", s); 

  for(dummi=0;dummi<5;dummi++)
  {
	markiere[dummi]-=1;
  }
  
  /* Durchgang 1: Ermittle die tatschliche Teilchenzahl <= N*/
  while((c=fgetc(liesdat2))!=EOF)
    {
      if(c=='\n')
 	fscanf(liesdat2, "%i", &counter);
    }
  *pnt=counter;
  printf("counter=%i\n", counter);


  /* Durchgang 2: Einlesen der Nullagen der Teilchen.*/
  rewind(liesdat2);
  /*Zeilen berlesen...*/
  fscanf(liesdat2,"%s", s); 
  fscanf(liesdat2,"%i %i %i %i %i %i", 
	 &dummi, &dummi, &dummi, &dummi, &dummi, &dummi);
  fscanf(liesdat2,"%s", s); 
  fscanf(liesdat2,"%i %i", &dummi, &dummi);
  fscanf(liesdat2,"%s", s);
  fscanf(liesdat2,"%lf %lf  %lf %lf",&dummy, &dummy,&dummy, &dummy);
  fscanf(liesdat2,"%s", s);
  fscanf(liesdat2,"%s", s);
  for (j=0;j < counter;j++)
    {
      fscanf(liesdat2,"%i %c %lf %lf", &dummi,&c, &x, &y );
      ptvek[j][0]=ptvek[j][2]=x;
      ptvek[j][1]=ptvek[j][3]=y;
      farbe[j]=c;
      if (c=='g')
	mges+= typ.m1;
      else
	mges+= typ.m2;	
 /*      printf("%i\t%c\t%f\t%f\n", dummi, c, x, y); */
    }

  printf("nt=%i\n", dummi);
  fclose(liesdat2);
  /*Anfangslage in x von Teilchen lastrand[0] zur Verschiebungsberechnung*/
  /*nl=ptvek[lastrand[0]][0];*/


    printf("nullagen gelesen!\nmges=%f\n",mges);
  
}

/***************************************************************************************/

void schreibe_lage (FILE *dateizeiger)
{
  int i;

  dateizeiger=fopen("nullage_gerechnet.dat", "w");

  fprintf(dateizeiger,"%s \n","------Nullagen_berechnet-----");

  fprintf(dateizeiger, "%i\t%i\t%i\t%i\t%i\n",
	  markiere[0]+1,markiere[1]+1,markiere[2]+1,markiere[3]+1, markiere[4]+1);
  fprintf(dateizeiger,"%s \n","Atome_zur_Dehnungsderechnung.");
  fprintf(dateizeiger,"%i\t%i\n",atomA+1, atomB+1);
  fprintf(dateizeiger, "%s\n","Reihenbreite,boxx,boxy");
  fprintf(dateizeiger, "%f\t%f\t%f\t%f\n",boxx1, boxx2, boxy1, boxy2);
  fprintf(dateizeiger, "%s\n%s\n","Nr,Farbe,x,y","------Nullagen_berechnet-----");
  for(i=0;i<nt;i++)
    {
       fprintf(dateizeiger,"%i\t%c\t%f\t%f\n",
	       i+1,farbe[i],tvek[i][0],tvek[i][1]);
    }
   fclose(dateizeiger);
  return; 
}
/***************************************************************************************/

void schreibe_energie (FILE *dateizeiger)
{
  fprintf(dateizeiger,"%f %f %f %f %f %f %f %f %f %f %f %f %f %f %f %f\n",
	  /* 1*/  zeit,						/*Dimensionslose Zeit t*/
	  /* 2*/  ekin,						/*Absolute kin. Energie zur Zeit t*/
	  /* 3*/  ekinzm,					/*ber die letzten nstep Schritte gemittelte absolute kin. Energie*/
	  /* 4*/  ekincc,					/*Relative kin. Energie zur Zeit t*/
	  /* 5*/  ekincczm,					/*ber die letzten nstep Schritte gemittelte relative kin. Energie*/
	  /* 6*/  ekinsubsys,				/*Absolute kin. Energie des Teilkrpers*/
	  /* 7*/  ekinsubsyszm,				/*ber die letzten nstep Schritte gemittelte relative kin. Energie des Teilkrpers*/
	  /* 8*/  temp,						/*Temperatur in K*/
	  /* 9*/  epot,						/*Potentielle Energie zur Zeit t*/
	  /*10*/  epotzm,					/*ber die letzten nstep Schritte gemittelte pot. Energie*/
	  /*11*/  epotsubsys,				/*Pot. Energie des Teilkrpers*/
	  /*12*/  epotsubsyszm,				/*ber die letzten nstep Schritte gemittelte pot Energie des Teilkrpers*/
	  /*13*/  klemmkraft,				/*Last*/
	  /*14*/  disp,						/*Verschiebung*/
	  /*15*/  f,						/*freie Energie*/
	  /*16*/  winkel);					/*Scherwinkel*/
  return;
}
/***************************************************************************************/

void schreibe_film (FILE *dateizeiger)
{
  int i;
  fprintf(dateizeiger,"%f\t%i\t%i\t%i\n",zeit, schrittzaehler, hist, klemmhist);
    for (i=0;i<nt;i++)
      fprintf(dateizeiger,"%f\t%f\t%c\n",
	      tvek[i][0], tvek[i][1], farbe[i] );
      fprintf(dateizeiger,"%i\t%i\t%i\t%f\t%f\t%f\t%f\t%f\t%f\t%f\t%f\t%f\t%f\n",
	  schalter, fix, dehnfix, 
	  q, lastx, klemmkraft, epotzm, ekincczm, winkelsp, spx, spy, vx, vy);
  return;
}


/* *************************************************** */

void ab (double ptvek[N][4], double v0)
/*Berechnung des ersten Zeitschrittes aus AB btgl. der Geschwindigkeiten.*/
{
int i;
double v1,v2,v,m;

 vx=0.0;
 vy=0.0;
 srand(time(0));		/*Die 'Saat' des Zufallsgenerators wird aus der Zeit berechnet -> Bei jedem Programmstart andere Richtungen des Geschwindigkeitsvektors!*/
 for(i=0;i<nt;i++)
   {
     if (farbe[i]=='g')
       m = typ.m1;
     else
       m = typ.m2;
     /* Normierter Zufalls-Richtungsvektor der Anfangsgeschwindigkeit */
     v1=(double)rand()*pow(-1.0, rand());
     v2=(double)rand()*pow(-1.0, rand());
     v=sqrt(v1*v1 + v2*v2);
     v1=v0/v*v1;
     v2=v0/v*v2;
     /* Aktuelle Lage x^\alpha_i (t) */
     ptvek[i][0]=ptvek[i][2]+v1*dt;
     ptvek[i][1]=ptvek[i][3]+v2*dt;
     /*Schwerpunktsgeschwindigkeit am Anfang:*/ 
     vx+=m/mges*v1;
     vy+=m/mges*v2;
   }


}

/* *************************************************** */

double r (double xa, double xb, double ya, double yb)
/*Abstandsvektor zwischen den Teilchen A und B*/
{
  return sqrt((xa-xb)*(xa-xb)+(ya-yb)*(ya-yb));
}

/* *************************************************** */

double bkraft (double br, double eps, double sig)
/*Betrag der WW-Kraft*/
{
  return (4.0 *eps*((6.0*pow(sig,6))/pow(br,7) - 
     (12.0*pow(sig,12))/pow(br,13))); 

}

/* *************************************************** */

void schreibrmat ()
/*Abstandsmatrix*/
{
  int i,j,k,l,elem=0;

	for (i=0;i<nt;i++)
		{
			for (j=i;j<nt;j++)
				{
					matrix[i][j]=matrix[j][i]=
					r(tvek[i][0],tvek[j][0], tvek[i][1], tvek[j][1]);
				}
		}
}
/* *************************************************** */


void schritt (double ptvek[N][4], 
	      struct mattyp typ, double mat[N][N], double hg)
/* Der Kern der Prozedur: Berechne die neuen Positionen*/
{
  int i,j,k,l;
  double m,kraftx[N], krafty[N], hilfx[N], hilfy[N], eps, sig, mt, di, ix, iy, omega;
  int entscheideri, entscheiderj;


  for (i=0;i<nt;i++)
    {
      hilfx[i]=ptvek[i][0]; /*Zwischenspeichern der aktuellen Positionen*/
      hilfy[i]=ptvek[i][1];
      
      kraftx[i]=0.0;	/*Initialisierung des Kraft auf Atom i in x-Richtung ....*/
      krafty[i]=-hg;	/*.... und in y-Richtung. hg: Gravitation.*/

      for(k=0;k<ntlr;k++)
	{
	  if(i == lastrand[k]) /*Externe Last auf Atome in lastrand[]*/
	    {
	      kraftx[i]+=lastx;
	      krafty[i]+=lasty;
	    }
	}
      /*Jetzt kommt die Berechnung der Kraft aller Teilchen j!=i*/
      /*auf das Teilchen i. Die kraft wird auf die Vektoren kraftx/y[i] */
      /*gespeichert.*/
      for(j=0;j<nt;j++)
	{	  
	  /*Zuweisung der Materialparameter und Berechnung der Kraft auf Teilchen i*/
	  if((farbe[i]=='g') && (farbe[j]=='g'))
	    {eps=typ.eps1; sig=typ.sig1;}
	  else if ((farbe[i]=='r') && (farbe[j]=='r'))
	    {eps=typ.eps2; sig=typ.sig2;}
	  else
	    {eps=typ.eps12; sig=typ.sig12;}
      	  /*Ende Zuweisung*/
	  
	  /*Hier wird die Kraft _aller_ Teilchen j!=i auf das Teilchen i ausgerechnet:*/
	  if(j != i)
	    {
	      kraftx[i] += (ptvek[j][0] - ptvek[i][0]) * 1.0/
		mat[i][j]*bkraft(mat[i][j], eps, sig);
	      krafty[i] += (ptvek[j][1] - ptvek[i][1]) * 1.0/
		mat[i][j]*bkraft(mat[i][j], eps, sig);
	    }/*Ende Anweisung if(j != i)*/

	}/*Ende for in j*/
    }/*Ende for in i*/


  /******************************************************/
  /*                                                    */
  /*Jetzt kommt die Position von i im neuen Zeitschritt:*/
  /*                                                    */
  /******************************************************/
  for(i=0;i<nt;i++)
    {
      /*Zuweisung der Massen*/
      if (farbe[i]=='g')
	m = typ.m1;
      else
	m = typ.m2;

/*Achtung: dt dimensionslos mit Eigenfrequenz!*/
      /*Lage in x*/
      ptvek[i][0] = (2.0*ptvek[i][0] - ptvek[i][2] 
		     + dt*dt/m * dimlos* kraftx[i]);
      /*Lage in y*/
      ptvek[i][1] = (2.0*ptvek[i][1] - ptvek[i][3] 
		     + dt*dt/m * dimlos* krafty[i]);
      
      /*Die alten Lagen werden gespeichert*/
      ptvek[i][2] = hilfx[i];
      ptvek[i][3] = hilfy[i];
      
      /*Ende neue Positionen*/
    }

  /**************************************/
  /*    Fixieren, Dehnen, Lagern       */
  /**************************************/


  if (fix!=0)
    {
      for(k=0;k<ntfr;k++)
		{
			ptvek[fixrand[k]][0]=fixvek[k];
			ptvek[fixrand[k]][1]=fiyvek[k];
		}
	}

  if (dehnfix==1)
    {
      for(k=0;k<ntdr;k++)
		{
			ptvek[dehnrand[k]][0]=dehnfixvek[k]+dehnx;
			/*ptvek[dehnrand[k]][1]=dehnfiyvek[k]+dehny;*/  
		}
    }

  for(k=0;k<ntl;k++)
    {
		if (lager[k][1]==0) /* "0": Gebe x frei und bind nur y*/
			ptvek[lager[k][0]][1]=lagery[k];
		else /* "1": Gebe y frei und bind nur x*/
			ptvek[lager[k][0]][0]=lagerx[k];
    }
  
  /*Berechnung der Kraft auf die Teilchen im Vektor "lastrand" */
  /*Es wird immer der Betrag der Reaktionskraft berechnet.*/



    for(k=0;k<ntlr;k++)
      {
		if(schalter!=0)
		  klemmkraft+=-kraftx[lastrand[k]]; /*wir korregieren das VZ. Reaktionskraft!*/
		if(schalter==0)
		  klemmkraft+=(double)ntlr*lastx;
      }
}

/* *************************************************** */
void kiste (double tvek[N][4])
/*Kontrolliert, ob Atome im letzten Zeitschritt aus der Kiste geraten sind.
Falls ja -> "Elastische Reflektion" */
{
	double zx, zy, o11, o22;
	int i;


 for(i=0;i< nt;i++)
   {
     o11 = o22 = 1.0;
     zx = zy = 0.0;
     if((fabs(tvek[i][0])>(boxx2)) || (fabs(tvek[i][1])>(boxy2)))
       {
	 tvek[i][0] = tvek[i][2] +  (tvek[i][0] - tvek[i][2]);
	 tvek[i][1] = tvek[i][3] +  (tvek[i][1] - tvek[i][3]);
	 if(fabs(tvek[i][0])>(boxx2) && fabs(tvek[i][1])< (boxy2))
	   {
	     o11 = -1.0;
	     if(tvek[i][0] < 0.0)
	       zx = -1.0;
	     else
	       zx = 1.0;
	     tvek[i][2] = o11 * tvek[i][2] + 2.0 * zx * (boxx2);
	     tvek[i][3] = o22 * tvek[i][3] + 2.0 * zy * (boxy2);
	     tvek[i][0] = o11 * tvek[i][0] + 2.0 * zx * (boxx2);
	     tvek[i][1] = o22 * tvek[i][1] + 2.0 * zy * (boxy2);
	   }
	 if(fabs(tvek[i][1])>(boxy2) && fabs(tvek[i][0])< (boxx2))
	   {
	     o22 = -1.0;
	     if(tvek[i][1] < 0.0)
	       zy = -1.0;
	     else
	       zy = 1.0;	     
	     tvek[i][2] = o11 * tvek[i][2] + 2.0 * zx * (boxx2);
	     tvek[i][3] = o22 * tvek[i][3] + 2.0 * zy * (boxy2);
	     tvek[i][0] = o11 * tvek[i][0] + 2.0 * zx * (boxx2);
	     tvek[i][1] = o22 * tvek[i][1] + 2.0 * zy * (boxy2);	     
	   }
	 if(fabs(tvek[i][1])>(boxy2) && fabs(tvek[i][0]) > (boxx2))
	   {
	     o11 = -1.0;
	     o22 = -1.0;
	     
	     if(tvek[i][1] < 0.0)
		 zy = -1.0;
	     else
	       zy = 1.0;
	     if(tvek[i][0] < 0.0)
	       zx = -1.0;
	     else
	       zx = 1.0;
	     tvek[i][2] = zx * (boxx2);
	     tvek[i][3] = zy * (boxy2);
	     tvek[i][0] = o11 * tvek[i][0] + 2.0 * zx * (boxx2);
	     tvek[i][1] = o22 * tvek[i][1] + 2.0 * zy * (boxy2);	     
	   }
       }
   }

}

/* *************************************************** */
void waerme (double tvek[N][4], double q)
/*Heiz- bzw. Khlschritt.*/
{
	double zx, zy, o11, o22;
	double d[2];
	int i;

 if(q != 1.0)
	for(i=0;i< nt;i++)
	{
		d[0]=q*(tvek[i][0]-tvek[i][2]);
		d[1]=q*(tvek[i][1]-tvek[i][3]);
	
		tvek[i][0]=tvek[i][2]+d[0];
		tvek[i][1]=tvek[i][3]+d[1];
	}

}




/***************************************************************************************/

void fixieren()
/*Speichert Atompositionen, welche sich im Zeitschritt nicht verndern sollen,
in den Hilfsvektoren *vek[]. Nach Berechnung des neuen Schrittes werden die betreffenden
Atome dann auf diese Positionen zurckgesetzt. */
{
int k;

/*Fixrand-Atome*/

	  for(k=0;k<ntfr;k++)
		{
		  fixvek[k]=tvek[fixrand[k]][0];
		  fiyvek[k]=tvek[fixrand[k]][1];
		}


/*Dehnrand-Atome*/	


	for(k=0;k<ntdr;k++)
	    {
	      dehnfixvek[k]=tvek[dehnrand[k]][0];
	      dehnfiyvek[k]=tvek[dehnrand[k]][1];
	    }	


/*Gleitlager-Atome*/
	for(k=0;k<ntl;k++)
		{
		 lagerx[k]=tvek[lager[k][0]][0];
		 lagery[k]=tvek[lager[k][0]][1];
		}
  
  

}

/***************************************************************************************/ 

double potential (double br, double eps, double sig)
/*Lennard-Jones Potential*/ 
 { 
   return (4.0 *eps*(pow((sig/br),12) -  
      pow((sig/br),6)));  
 } 

/***************************************************************************************/ 

static void DrawBitmapString(void *font, const char *string)
/*OpenGL. Dient der Darstellung von Schrift*/
{
    int i;

    for (i = 0; string[i]; i++){
	glutBitmapCharacter(font, string[i]);
	}
}

/***************************************************************************************/ 


void projektor()
/*Liest einen Satz berechneter Positionen aus der Datei film.dat ein.
Wird nur im Wiedergabemodus aufgerufen.*/
{

  int i, dummi;
char c;

  	c=fgetc(filmdatei); 
  	if(c!=EOF) 
  	{ 

	  fscanf(filmdatei,"%lf %i %i %i ",&zeit, &schrittzaehler, &dummi, &dummi);
	  
	  for(i=0;i<nt;i++)
	    fscanf(filmdatei," %lf %lf %c ",
		  &tvek[i][0], &tvek[i][1], &farbe[i] );
	  
	  fscanf(filmdatei," %i %i %i %lf %lf %lf %lf %lf %lf %lf %lf %lf %lf",
		 &schalter, &fix, &dehnfix, 
		 &q, &lastx, &klemmkraft,
		 &epotzm, 
		 &ekincczm, 
		 &winkelsp,
		 &spx, &spy, &vx, &vy);
  	} 
	else
		unterbrecher=1;
  return;
}

/***************************************************************************************/ 

void projektor_init()
/*Initialisierungsroutine fr den Wiedergabemodus.*/
{

  /*Einlesen der allgemeinen Daten*/

  /*Alles, was von Dateien kommt*/
  /*Reihenfolge IST wichtig!*/
  lastrandlage(lastrand, &ntlr);
  nullage(tvek,&nt,&boxx1, &boxx2, &boxy1, &boxy2);
  nl=tvek[atomA][0]- tvek[atomB][0];
  subsyslage(subsys, &nte);
    dehnrandlage(dehnrand, &ntdr);
    fixrandlage(fixrand, &ntfr);
    lagerlage(lager, &ntl);

  projektor();
  hist=1;
  klemmhist=1;
  ekincc0=ekincczm;
  epot0=epotzm;

  return;
}

/***************************************************************************************/

void subsyslage (int subsys[NTEMAX], int *pnte)
/*Einlesen der Datei subsys.dat: Atome, die dem Teilkrper angehren.*/
{
  FILE *liessubsys;
  char s[60],c;
  int counter,dummi,j,k,cnt;
  double x,y,dummy ;

  liessubsys=fopen("subsys.dat", "r");

  fscanf(liessubsys,"%s", s);
  fscanf(liessubsys,"%s", s);	



counter=0;
  /* Durchgang 1: Ermittle die tatschliche Teilchenzahl <= N*/
  while((c=fgetc(liessubsys))!=EOF)
    {
      if(c=='\n')
	{
	  counter++;
	}
    }
  *pnte=counter;
  printf("%i Atome im Subsys!\n",*pnte);
  
  /* Durchgang 2: Einlesen der Nullagen der Teilchen.*/
   rewind(liessubsys); 
/*   Zeilen berlesen...*/
   fscanf(liessubsys,"%s", s);  
   fscanf(liessubsys,"%s", s); 
  
   for (j=0;j<*pnte;j++) 
     { 
       fscanf(liessubsys,"%i",  
 	     &subsys[j]);
       printf("subsys[%i] = %i\n", j, subsys[j]);
       subsys[j]-=1; 
     } 

   fclose(liessubsys); 

    printf("subsys.dat gelesen!\n");

}

/***************************************************************************************/

void lastrandlage (int lastrand[NLR], int *pntlr)
/*Einlesen der Datei lastrand.dat: Atome, die extern belastet werden, oder deren Reaktionslast 
ausgewertet werden soll.*/
{
  FILE *lieslr;
  char s[60],c;
  int counter,dummi,j,k,cnt;
  double x,y,dummy ;
  

  lieslr=fopen("lastrand.dat", "r");

  fscanf(lieslr,"%s", s);
  fscanf(lieslr,"%s", s);	



counter=0;
  /* Durchgang 1: Ermittle die tatschliche Teilchenzahl <= N*/
  while((c=fgetc(lieslr))!=EOF)
    {
      if(c=='\n')
	{
	  counter++;
	}
    }

  *pntlr=counter;
  printf("Anzahl Atome auf Lastrand:%i\n", counter);

  
  /* Durchgang 2: Einlesen der Nullagen der Teilchen.*/
   rewind(lieslr); 
/*   Zeilen berlesen...*/
   fscanf(lieslr,"%s", s);  
   fscanf(lieslr,"%s", s); 
  
   for (j=0;j<counter;j++) 
     { 
       fscanf(lieslr,"%i",  
 	     &lastrand[j]);
       printf("lastrand[%i] = %i\n", j, lastrand[j]);
       lastrand[j]-=1; 
     } 

   fclose(lieslr); 

    printf("lastrand.dat gelesen!\n");

}
/***************************************************************************************/

void dehnrandlage (int dehnrand[NDR], int *pntdr)
/*Einlesen der Datei dehnrand.dat: Atome, die verschoben werden sollen */
{
  FILE *liesdr;
  char s[60],c;
  int counter,dummi,j,k,cnt;
  double x,y,dummy ;
  

  liesdr=fopen("dehnrand.dat", "r");

  fscanf(liesdr,"%s", s);
  fscanf(liesdr,"%s", s);	



counter=0;
  /* Durchgang 1: Ermittle die tatschliche Teilchenzahl <= N*/
  while((c=fgetc(liesdr))!=EOF)
    {
      if(c=='\n')
	{
	  counter++;
	}
    }

  *pntdr=counter;
  printf("Anzahl Atome auf Dehnrand:%i\n", counter);

  
  /* Durchgang 2: Einlesen der Nullagen der Teilchen.*/
   rewind(liesdr); 
/*   Zeilen berlesen...*/
   fscanf(liesdr,"%s", s);  
   fscanf(liesdr,"%s", s); 
  
   for (j=0;j<counter;j++) 
     { 
       fscanf(liesdr,"%i",  
 	     &dehnrand[j]);
       printf("dehnrand[%i] = %i\n", j, dehnrand[j]);
       dehnrand[j]-=1; 
     } 

   fclose(liesdr); 

    printf("dehnrand.dat gelesen!\n");

}



/***************************************************************************************/

void fixrandlage (int fixrand[NFR], int *pntfr)
/*Einlesen der Datei fixrand.dat: Atome, welche zeitl. fixiert werden sollen */
{
  FILE *liesfr;
  char s[60],c;
  int counter,dummi,j,k,cnt;
  double x,y,dummy ;
  

  liesfr=fopen("fixrand.dat", "r");

  fscanf(liesfr,"%s", s);
  fscanf(liesfr,"%s", s);	



counter=0;
  /* Durchgang 1: Ermittle die tatschliche Teilchenzahl <= N*/
  while((c=fgetc(liesfr))!=EOF)
    {
      if(c=='\n')
	{
	  counter++;
	}
    }

  *pntfr=counter;
  printf("Anzahl Atome auf Fixrand:%i\n", counter);

  
  /* Durchgang 2: Einlesen der Nullagen der Teilchen.*/
   rewind(liesfr); 
/*   Zeilen berlesen...*/
   fscanf(liesfr,"%s", s);  
   fscanf(liesfr,"%s", s); 
  
   for (j=0;j<counter;j++) 
     { 
       fscanf(liesfr,"%i",  
 	     &fixrand[j]);
       printf("fixrand[%i] = %i\n", j, fixrand[j]);
       fixrand[j]-=1; 
     } 

   fclose(liesfr); 

    printf("fixrand.dat gelesen!\n");

}
/***************************************************************************************/

void lagerlage (int lager[NL][2], int *pntl)
/*Einlesen der Datei lager.dat: Atome, die gleitend gelagert sein sollen*/
{
  FILE *liesll;
  char s[65],c;
  int counter,dummi,j,k,cnt;
  double x,y,dummy ;
  

  liesll=fopen("lager.dat", "r");

  fscanf(liesll,"%s", s);
  fscanf(liesll,"%s", s);
  fscanf(liesll,"%s", s);



counter=0;
  /* Durchgang 1: Ermittle die tatschliche Teilchenzahl <= N*/
  while((c=fgetc(liesll))!=EOF)
    {
      if(c=='\n')
	{
	  counter++;
	}
    }

  *pntl=counter;
  printf("Anzahl Gleitlager-Atome:%i\n", counter);

  
  /* Durchgang 2: Einlesen der Nullagen der Teilchen.*/
   rewind(liesll); 
/*   Zeilen berlesen...*/
   fscanf(liesll,"%s", s);  
   fscanf(liesll,"%s", s); 
   fscanf(liesll,"%s", s);
  
   for (j=0;j<counter;j++) 
     { 
       fscanf(liesll,"%i %i",  
 	     &lager[j][0], &lager[j][1]);
       lager[j][0]-=1; 
       printf("lager[%i][0] = %i \t lager[%i][1] = %i\n", 
	      j, lager[j][0],j, lager[j][1]);
     
     } 

   fclose(liesll); 

    printf("lager.dat gelesen!\n");

}


/***************************************************************************************/

void qregel(double *pq)
/*Temperaturregelung: Proportionalregler*/
{

  if(tempregel==1)
    {
      *pq = 1.0 + kp*(kt0 - ekincczm/((double)nt));  
	}	

}


/***************************************************************************************/

void energieberechnung()
/*Berechnung der Energiegren.*/
{
  int i,j,k,l,entscheideri, entscheiderj;
  double m, eps, sig, mt, di, ix, iy, omega;
  double vxhilfe, vyhilfe;

  
  epot=0.0; 
  ekin=0.0;
  ekincc=0.0;
  epotsubsys=0.0;
  ekinsubsys=0.0;

 

  
  cx=0.0;   /* absolute Atomgeschwindigkeitskompomponenten */
  cy=0.0;
  vxhilfe=0.0;
  vyhilfe=0.0;
  ccx=0.0;  /* relative Atomgeschwindigkeitskompomponenten */
  ccy=0.0; 

  di=0.0;	/*Drehimpuls des Gesamtkrpers*/
  omega=0.0; /**/
  mt=0.0;	/*Gesamtmasse*/

  spx=0.0;	/*Komponetneten der Schwerpunktsgeschwindigkeit*/
  spy=0.0;

  ix=0.0;	/*Impulskomponenten des Krpers*/
  iy=0.0;

  for (i=0;i<nt;i++)
    {

	  /*potentiellen Energien des Teilkpers und des Gesamtkrpers.*/

      entscheideri=0;
      for(k=0;k<nte;k++)
	  if (i==subsys[k]) 
	    { 
	      entscheideri=1; /*Ist das i-Atom im Teilkrper? Ja=1*/
	      break;
	    }

      for(j=0;j<nt;j++)
	{
	  
	  /*Zuweisung der Materialparameter und Berechnung der Kraft auf Teilchen i*/
	  if((farbe[i]=='g') && (farbe[j]=='g'))
	    {eps=typ.eps1; sig=typ.sig1;}
	  else if ((farbe[i]=='r') && (farbe[j]=='r'))
	    {eps=typ.eps2; sig=typ.sig2;}
	  else
	    {eps=typ.eps12; sig=typ.sig12;}
      	  /*Ende Zuweisung*/
	  

	  if(j != i)
	    {
              epot+=0.5*potential(matrix[i][j],eps,sig);
       
	      /*epotsubsys: pot.Energie des gew"ahlten Subsyss (8.10.01):*/	
	      entscheiderj=0;
	      if(entscheideri==1)
		{
		  for(l=0;l<nte;l++)
		    {
		      if(j==subsys[l])
			{	
			  entscheiderj=1; /*Ist das j-Atom auch im Teilkrper? Ja=1*/
			  break;
			}
		    }
		}  	      
	      if(entscheideri==1 && entscheiderj==1) /*Beide im Teilkrper*/
		epotsubsys+=0.5*potential(matrix[i][j],eps,sig);
	      
	    }/*Ende Anweisung if(j != i)*/
	  
	}/*Ende for in j*/
      
      
      /*Absolutgeschwindigkeit*/
      cx=(tvek[i][0] - tvek[i][2])/dt;
      cy=(tvek[i][1] - tvek[i][3])/dt;

      /*Zuweisung der Massen*/
      if (farbe[i]=='g')
		m = typ.m1;
      else
		m = typ.m2;

	/*Gewichtete Summen der Atomsgeschwindigkeiten: Krperschwerpunktsgeschwindigkeit.*/      
      vxhilfe+=m/mges*cx; vyhilfe+=m/mges*cy;

    /*Gewichtete Summen der Atompositione:Koordinaten des Schwerpunktes*/
      spx+=tvek[i][0]*m/mges;
      spy+=tvek[i][1]*m/mges;
      
    /*Gesamt-Drehimpuls um Koordinatenursprung*/
      di+=m*(tvek[i][0]*cy-tvek[i][1]*cx);

    /*Komponenten des Gesamtimpulses*/
      ix+=m*cx;
      iy+=m*cy;
    }/*Ende for in i*/
  
  /*Komponenten der Schwerpunktsgescshwindigkeit:*/
  vx=vxhilfe;
  vy=vyhilfe;


  for(i=0;i<nt;i++)
    { /*Zuweisung der Massen*/
      if (farbe[i]=='g')
		m = typ.m1;
      else
		m = typ.m2;
      
      /*Massentr"agheitsmoment um Schwerpunkt*/
      mt+=m*(pow(tvek[i][0]-spx, 2)+pow(tvek[i][1]-spy, 2));

      /*Atomgeschwindigkeit*/
      cx=(tvek[i][0] - tvek[i][2])/dt;
      cy=(tvek[i][1] - tvek[i][3])/dt;

	  /*Relative Atomsgeschwindigkeit ("Exzegeschwindigkeit")*/
      ccx=cx-vxhilfe;
      ccy=cy-vyhilfe;

     /*Berechnung der (summatorischen) kinetischen Energie des letzten Zeitschritts!*/
      ekin+=m/2.0 * (pow(cx,2)+pow(cy,2)); 

     /* kinetische Energie der Relativbewegung */
      ekincc+=m/2.0 * (pow(ccx,2)+pow(ccy,2)); 
      
      /*ekinsubsys: kinetische Energie der markierten Zelle*/
      for(k=0;k<nte;k++)
		if (i==subsys[k])
			ekinsubsys+=m/2.0 * (pow(cx,2)+pow(cy,2)); 
    }	
  
  omega=( di - (spx*iy-spy*ix) ) / mt; /*aktuelle Winkelgeschwindigkeit*/
  winkelsp+=omega*dt;
}



/*************************************************************************/ 

void scherwinkel(double ptvek[N][4], double mat[N][N],double *pphi)
/*Berechnung des Scherwinkels aus dem Skalarprodukt*/
{
	double sprod,a[2],b[2];	  

	int i;

	sprod=0.0;

	a[0]=ptvek[markiere[3]][0]-ptvek[markiere[0]][0];
	a[1]=ptvek[markiere[3]][1]-ptvek[markiere[0]][1];

	b[0]=ptvek[markiere[1]][0]-ptvek[markiere[0]][0];
	b[1]=ptvek[markiere[1]][1]-ptvek[markiere[0]][1];


	for(i=0;i<2;i++)
		sprod+=a[i]*b[i];
		
	*pphi = (0.5*PI-acos(sprod/
	  (mat[markiere[0]][markiere[3]]*mat[markiere[0]][markiere[1]])
			      ))/PI*180.0;
	
}
