/* Copyright (C) 2004  Oliver Kastner

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or any later version. 

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details. 

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.

*/
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <GL/glut.h>
#include <time.h>
#include <string.h>


#define R 0.2	/*Teilchenradius (nur Berechnung der Box)*/
#define PSIZE 6		/*Punktgre (nur fr graphische Darstellung)*/
#define OFFSET 0.5	/*Offset um Box herum*/
#define NEAR 10.0   /*Opengl*/
#define FAR 20.0	/*Opengl*/
#define STATIVPOS 12.0 /*Opengl*/
#define PI 3.14159	/*Zahl Pi...*/
#define KB 1.38e-23	/*Boltzmann-Konstante*/

#define N 800		/*Maximale Teilchenzahl*/
#define NTEMAX 60	/*Maximale Anzahl der Atome im Layer-Subsys*/
#define NLR 60		/*Maximale Anzahl der Atome im Last-Rand */
#define NDR 20		/*Maximale Anzahl der Atome im Dehn-Rand */
#define NFR 20		/*Maximale Anzahl der Atome im Fix-Rand */
#define NL 20		/*Anzahl der Gleitlager-Atome*/
#define ein1 "parameter.dat" 
#define ein2 "nullage.dat"
#define aus1 "film.dat"
#define aus2 "energie.dat"


#define LASTSCHRITT 0.002 /*Vernderung der Last im Lastschritt*/
#define DEHNSCHRITT 0.003 /*Vernderung der Last im Dehnschritt*/

struct mattyp{		/*mattyp nimmt die Lennard-Jones-Parameter auf*/
  double eps1;
  double sig1;
  double m1;
  double eps2;
  double sig2;
  double m2;
  double eps12;
  double sig12;};


/*Deklaration der Routinen*/

void eingabe (double *, double *, double *,
	      struct mattyp *, 
	      double *, double *, double *, 
	      int *, int *, int *, int *, int *, int *,   
	      double *, double *,  int *);
void nullage (double ptvek[N][4], int *, double*, double*, double*, double*);
void subsyslage(int subsys[NTEMAX], int *);
void lastrandlage(int lastrand[NLR], int *);
void dehnrandlage(int dehnrand[NDR], int *);
void fixrandlage(int fixrand[NFR], int *);
void lagerlage(int lager[NL][2], int *);

void scherwinkel(double ptvek[N][4], double mat[N][N],double *);

void schreibe_lage (FILE *);
void schreibe_energie (FILE *);
void schreibe_film (FILE *);


void ab (double ptvek[N][4], double);
double r (double,double,double,double);
double bkraft (double, double, double);
void schreibrmat ();
void schritt (double ptvek[N][4], struct mattyp, double mat[N][N], double);
void kiste (double ptvek[N][4]);
void waerme (double ptvek[N][4], double);
void fixieren();
double potential (double,double,double);

static void Idle( void );
static void Display( void );
static void Reshape( int, int );
static void Key( unsigned char , int , int);
static void SpecialKey( int , int , int  );
static void Init( void );

static void Display_control( void );
static void Display_ekin( void );
static void Display_epot( void );
static void Display_ld( void );
static void Reshape_ekin( int, int);
static void Reshape_epot( int, int);
static void Reshape_ld( int, int);
static void Reshape_control( int, int);

static void DrawBitmapString(void *, const char *);
void qregel(double*); 

void projektor();
void projektor_init();

void window_init(int argc, char *argv[]);
void animation();
void energieberechnung();


FILE *lagendatei;
FILE *energiedatei;
FILE *filmdatei;


struct mattyp typ;
double	dt,				/*Zeitschrittweite*/
		matrix[N][N],	/*Abstandsmatrix*/
		v0,				/*Betrag der atomaren Anfangsgeschwindigkeiten*/
		g,				/*Gravitation in negative y-Richtung*/
		q = 1.0,		/*Heiz/Khlfaktor. 1.0 --- default*/
		tvek[N][4],		/*Matrix der Atompositionen. x(t), y(t), x(t-dt), y(t-dt)*/
		boxx1, boxx2, boxy1, boxy2,	/*Dimension der Box. x1,y1 -- Ecke li.u.,  x2,y2 -- Ecke re.o.*/
		epot,			/*pot. Energie d. Gesamtkrpers zur Zeit t*/
		ekin,			/*abs. kin. Energie d. Gesamtkrpers zur Zeit t*/
		ekincc,			/*rel. kin. Energie d. Gesamtkrpers zur Zeit t*/
		epotzm,			/*pot. Energie d. Gesamtkrpers (Memittel)*/
		ekinzm,			/*abs. kin. Energie d. Gesamtkrpers (Memittel)*/
		ekincczm,		/*rel.. kin. Energie d. Gesamtkrpers (Memittel)*/
		f=0.0,			/*freie Energie*/
		epotsubsys,		/*pot. Energie d. Teilkrpers zur Zeit t*/
		ekinsubsys,		/*abs. kin. Energie d. Teilkrpers zur Zeit t*/
		epotsubsyszm,	/*pot. Energie d. Teilkrpers (Memittel)*/
		ekinsubsyszm,	/*abs. kin. Energie d. Teilkrpers (Memittel)*/
		klemmkraft,		/*Last*/
		disp,			/*Verschiebung der Atome A,B aus nl (A:fix)*/
		nl,				/*Referenzlage der Atome A,B*/
		epot0,			/* *0: Zur Einrichtung der Diagramme*/
		ekin0,
		ekincc0,
		kk0,
		dehn0=0.0,
		klemmkraft0,		
		epothist[2100], /*Plotvektoren*/
		ekinhist[2100],
		ekinhistcc[2100],
		dehnhist[20000], 
		klemmkrafthist[20000],
		lastx=0.0,		/*Last*/
		lasty=0.0, 
		dehnx=0.0,		/*Dehnung der Dehnrand-Atome*/
		dehny=0.0,
		fixvek[21],		
		fiyvek[21], 
		dehnfixvek[21], 
		dehnfiyvek[21],
		zeit=0.0,		/*dim'lose Zeit*/
		dehns=DEHNSCHRITT,	/*Dehnschritt*/
		lasts=LASTSCHRITT,	/*Lastschritt*/
		vx, vy,			/*Schwerpunktsgeschwindigkeit*/
		cx, cy,			/*Atomare Geschwindigkeit im Inertialsystem*/
		ccx, ccy,		/*Atomare Realtiv (Exze) -geschwindigkeit*/
		kp, 
		kt0, 
		temp,
		mges=0.0, 
		spx,spy, 
		winkelsp=0.0,
		mu0, sig0, eps0, tau0,dimlos,
		ekinfak, epotfak, kkfak, 
		winkel,
		lagerx[NL],  lagery[NL];
int hist=0, 
    klemmhist=0,
	nt,nstep, 
	fix, dehnfix, 
	schalter=-1, /*zwischen Last- und Dehnungskontrole
			      Lastkontrolle: schalter=0 
                  Dehnungskontrolle(default): schalter=1*/
    unterbrecher=1, 
	fensterid[6],
    markiere[5],
	ds=0,
	methode,
	mznr, 
	schrittzaehler=0, 
	abbruch,
    atomA, atomB, 
	kistenschalter, /*kistenschalter: 0 -- Kiste aus, 1 -- Kiste ein*/
	nte, 
	subsys[NTEMAX], 
	lastrand[NLR], ntlr,
	dehnrand[NDR], ntdr, 
	fixrand[NFR], ntfr, 
    tempregel=0, 
	lager[NL][2], ntl;
char farbe[N],
     stringkt[10],
     stringtemp[10],
     stringmu0[10],
     stringsig0[10],
     stringeps0[10],
     stringtau0[10],
     stringepsAA[10],
     stringepsBB[10],
     stringepsAB[10],
     stringsigAA[10],
     stringsigBB[10],
     stringsigAB[10],
     stringdt[10],
     stringzeit[10],
     stringrechenschritte[10],
     stringwinkel[10],
     stringnstep[5],
     *pstr,
     *pstrld,
     stringload[20],
     stringstrain[30];


