      dimension zs(0:22,20),u(0:22,20),v(0:22,20)
      dimension un(0:22,20),vn(0:22,20),d(0:22,20)
      dimension am(0:22,20),def(22),def2(22)
      dimension ut(0:22,20),vt(0:22,20),qm(22,20)
      dimension ys(22,20,3),yc(22,20,3),amp(22,20,3),fase(22,20,3)
      dimension ur(0:22,20),vr(0:22,20)
      
      real h1(0:23,20),h1n(0:23,20)
      real h1o(0:23,20),h1r(0:23,20)
      real num
      
      data pi/3.141592654/
      data dx,dy,dt/2500.,2500.,5./
      data rho/1027./
      data dh,f,w/10.0,8.55e-5,1.405e-4/
      data c1/0.05/

      t=-dt
      conta=0.0

      filtro=0.0

      open (1,file="depth",status="old")
      read (1,*) ((d(i,j),i=1,22),j=1,20)
      close (1)

      do 1,i=0,22
        do 1,j=1,20
          am(i,j)=0.0
          zs(i,j)=0.0
          if (d(i,j).gt.0.0) then
              h1(i,j)=d(i,j)
              else
                h1(i,j)=0.0
              end if
 1      continue

        do 6,i=0,22
          do 6,j=1,20
            h1o(i,j)=h1(i,j)
            u(i,j)=0.0
            v(i,j)=0.0
            u(i,j)=0.0
            v(i,j)=0.0
            h1n(i,j)=0.0
            ur(i,j)=0.0
            vr(i,j)=0.0
            h1r(i,j)=0.0
 6        continue

          do 20,j=3,19
            def(j)=pi*(-.8125*(j-3.)+67.)/180.
20        continue
          do 212,j=8,16
            def2(j)=pi*(-.2*(j-8.)+50.)/180.
 212      continue
          
          do 10,nci=1,6
            do 10,n=1,2236*4
            t=t+dt
            write (6,*) nci,n

            do 2,j=2,19
              h1n(1,j)=h1o(1,j)+.785*cos(w*t-def(j))
 2          continue
            do 202, j=8,16
              h1n(22,j)=h1o(22,j)+.25*cos(w*t-def2(j))
 202        continue

c        CONTINUITY EQUATION
            
            do 3,i=2,21
              do 3,j=2,19
                if (d(i,j).eq.0.0) goto 3
                der1=(u(i,j)-u(i-1,j))/dx
                der2=(v(i,j+1)-v(i,j))/dy
                h1n(i,j)=h1(i,j)-dt*(der1+der2)
 3            continue                

              do 4,i=1,22
                do 4,j=1,20
                  if (d(i,j).eq.0.0) goto 4
                  zs(i,j)=h1n(i,j)-h1o(i,j)
 4              continue

c         U EQUATION

                do 5,i=1,21
                  do 5,j=2,19
                    if (d(i,j).eq.0.0) goto 5
                    if (d(i+1,j).eq.0.0) goto 5
                    rnonli=0.0
                    if (i.ge.2.and.i.le.20) then
                      s1=u(i,j)*(u(i+1,j)-u(i-1,j))/(2.*dx)
                      s2=.5*(v(i,j+1)+v(i+1,j+1))*u(i,j+1)
                      s3=.5*(v(i,j)+v(i+1,j))*u(i,j-1)
                      rnonli=(s1+(s2-s3)/(2.*dy))/(.5*
     &                  (h1n(i,j)+h1n(i+1,j)))
                    end if 
                    gra=9.8*.5*(h1n(i,j)+h1n(i+1,j))*(zs(i+1,j)-
     &                zs(i,j))/dx
                    vp=.25*(v(i,j)+v(i+1,j)+v(i+1,j+1)+v(i,j+1))
                    q=sqrt(u(i,j)**2.+vp*vp)
                    fri=c1*q/h1n(i,j)**2.
                    cor=f*vp
                    hor=0.0
                    if (i.gt.1.and.i.lt.22) then
                    hor=dh*(u(i+1,j)+u(i-1,j)-2.*u(i,j))/(dx*dx)+
     &                dh*(u(i,j+1)+u(i,j-1)-2.*u(i,j))/(dy*dy)
                    end if
                    ut(i,j)=(u(i,j)/dt-gra+cor+hor-rnonli)/(1./dt+fri)
 5                continue

c             ORLANSKY BOUNDARY CONDITION

                  do 11,j=2,19
                    if (d(1,j).eq.0.0) goto 110
                    den=-u(1,j)+u(2,j)
                    num=ut(1,j)-u(1,j)
                    cp=-num/den
                    if (cp.lt.(-1.)) cp=-1.0
                    if (den.eq.0.0.and.num.lt.0.0) cp=-1.0
                    if (den.eq.0.0.and.num.gt.0.0) cp=0.0
                    if (cp.gt.0.0) cp=0.0
                    ut(0,j)=(1.+cp)*u(0,j)-cp*u(1,j)
 110                continue
                    if (d(22,j).eq.0.0) goto 11
                    den=u(21,j)-u(20,j)
                    num=ut(21,j)-u(21,j)
                    cp=-num/den
                    if (cp.gt.1.0) cp=1.0
                    if (cp.lt.0.0) cp=0.0
                    if (den.eq.0.0.and.num.gt.0.0) cp=1.0
                    if (den.eq.0.0.and.num.lt.0.0) cp=0.0
                    ut(22,j)=(1.-cp)*u(22,j)+cp*u(21,j)
 11               continue

c           FILTER
                  
                  do 15,j=1,20
                    un(0,j)=ut(0,j)
                    un(22,j)=ut(22,j)
                    do 15,i=1,21
                      if (ut(i,j).eq.0.0) goto 15
                      un(i,j)=ut(i,j)+.5*filtro*(ut(i-1,j)+
     &                  ut(i+1,j)-2.*ut(i,j))
15                 continue

c         V EQUATION

                    do 7,i=1,22
                      do 7,j=2,19
                    if (d(i,j).eq.0.0) goto 7
                    if (d(i,j-1).eq.0.0) goto 7
                    rnonli=0.0
                    if (i.ge.2.and.i.le.20) then
                      s1=v(i,j)*(v(i,j+1)-v(i,j-1))/(2.*dy)
                      s2=.5*(u(i,j)+u(i,j-1))*v(i+1,j)
                      s3=.5*(u(i-1,j)+u(i-1,j-1))*v(i-1,j)
                      rnonli=(s1+(s2-s3)/(2.*dx))/(.5*
     &                  (h1n(i,j)+h1n(i,j+1)))
                    end if
                    gra=9.8*.5*(h1n(i,j)+h1n(i,j-1))*(zs(i,j)-
     &                zs(i,j-1))/dy
                    up=.25*(un(i,j)+un(i-1,j)+un(i-1,j-1)+
     &                un(i,j-1))
                    cor=-f*up
                    q=sqrt(up*up+v(i,j)**2.)
                    fri=c1*q/h1n(i,j)**2.
                    hor=0.0
                    if (i.gt.1.and.i.lt.22) then
                      hor=dh*(v(i+1,j)+v(i-1,j)-2.*v(i,j))/(dx*dx)+
     &                  dh*(v(i,j+1)+v(i,j-1)-2.*v(i,j))/(dy*dy)
                    end if
                    vt(i,j)=(v(i,j)/dt-gra+cor+hor-rnonli)/(1./dt+fri)
7                 continue

c           FILTER

                  do 16,j=2,19
                    do 16,i=1,22
                      if (vt(i,j).eq.0.0) goto 16
                      vn(i,j)=vt(i,j)+.5*filtro*(vt(i,j-1)+
     &                  vt(i,j+1)-2.*vt(i,j))
 16                 continue
 
                    do 9,i=0,22
                      do 9,j=1,20
                      h1(i,j)=h1n(i,j)
                      u(i,j)=un(i,j)
                      v(i,j)=vn(i,j)
 9                  continue
  
c	TIDAL ANALYSIS
c	--------------
      if (nci.eq.5.and.int(t/600.).eq.(t/600.)) then
	ss=sin(w*t)
	cc=cos(w*t)
	seno2=seno2+ss*ss
	cose2=cose2+cc*cc
	cs=cs+cc*ss
        do 25,i=1,22
          do 25,j=1,20
	if (d(i,j).lt.0.2) goto 25
	ys(i,j,1)=ys(i,j,1)+zs(i,j)*ss
	yc(i,j,1)=yc(i,j,1)+zs(i,j)*cc
        ume=.5*(u(i,j)+u(i-1,j))/h1(i,j)
        vme=.5*(v(i,j)+v(i,j+1))/h1(i,j)
	ys(i,j,2)=ys(i,j,2)+ume*ss
	yc(i,j,2)=yc(i,j,2)+ume*cc
	ys(i,j,3)=ys(i,j,3)+vme*ss
	yc(i,j,3)=yc(i,j,3)+vme*cc
25	continue
	end if
	
 10         continue

c	TIDAL ANALYSIS RESULTS
c	----------------------
	det=cs*cs-seno2*cose2
	if (abs(det).lt.1.E-20) then 
	write (6,*) "No es posible"
	goto 66
	end if
        do 26, i=1,22
          do 26,j=1,20
	if (d(i,j).lt.0.2) goto 26
	do 27, n=1,3
	ak=(ys(i,j,n)*cs-yc(i,j,n)*seno2)/det
	bk=(yc(i,j,n)*cs-ys(i,j,n)*cose2)/det
	amp(i,j,n)=sqrt(ak*ak+bk*bk)
	fase(i,j,n)=0.0
	if (ak.ne.0.0) fase(i,j,n)=atan2(bk,ak)*180./pi
	if (fase(i,j,n).lt.0.0) fase(i,j,n)=fase(i,j,n)+360.
27	continue
26	continue
	open (unit=10,file="h.dat",status="new")
	open (unit=11,file="g.dat",status="new")
	do 30,n=1,3
          do 30,i=1,22
            write (10,250) (amp(i,j,n),j=1,20)
            write (11,300) (fase(i,j,n),j=1,20)
30	continue
250     format (1x,20f6.3)
300     format (1x,20f6.1)
66      continue
 
       end
                