        dimension u(75,50),v(75,50),cd(0:76,0:51),cdn(0:76,0:51),d(75,50)

        data dx,dy,dt/5000.,5000.,180./
       
	do 1,i=1,75
	do 1,j=1,50
          u(i,j)=.5
          v(i,j)=.15
          d(i,j)=5.
1	continue
   
        do 60,i=0,76
          do 60,j=0,51 
          cd(i,j)=0.01
          cdn(i,j)=0.0
60	continue
 

        cd(5,10)=1.e5
	t=-dt

c       Time integration

        do 10,n=1,2000
	t=t+dt

	do 20,i=2,74
	do 20,j=2,49
	if (d(i,j).eq.0.0) goto 20
	cdn(i,j)=cd(i,j)+dt*adv(cd,u,v,d,i,j)
20	continue


        do 36,i=1,75
          cdn(i,1)=cdn(i,2)
          cdn(i,50)=cdn(i,49)
36	continue
        do 37,j=1,50
          cdn(1,j)=cdn(2,j)
          cdn(75,j)=cdn(74,j)
 37     continue
        
	do 40,i=1,75
	do 40,j=1,50
	cd(i,j)=cdn(i,j)
40	continue
	

10 	continue

	do 100, i=1,75
	do 101, j=1,50
          write (21,*) i,j,cd(i,j)
101	continue
        write (21,*)
100	continue

	stop
	end

c	ADVECTION FUNCTION
c	------------------

	function adv(c,u,v,d,i,j)
        dimension u(75,50),v(75,50),d(75,50),c(0:76,0:51)

	data dx,dy/5000.,5000./

	d1=.5*(d(i,j)+d(i+1,j))
	d2=.5*(d(i,j)+d(i-1,j))
	d3=.5*(d(i,j)+d(i,j-1))
	d4=.5*(d(i,j)+d(i,j+1))
	n1=1
	n2=1
	n3=1
	n4=1
	if (u(i,j).lt.0.0) n1=0
        if (u(i-1,j).lt.0.0) n2=0
	if (v(i,j-1).lt.0.0) n3=0
	if (v(i,j).lt.0.0) n4=0

        adv1=(-n1*u(i,j)*c(i,j)-(1-n1)*u(i,j)*c(i+1,j))*d1*dy		

        adv2=(n2*u(i-1,j)*c(i-1,j)+(1-n2)*u(i-1,j)*c(i,j))*d2*dy

        adv4=(-n4*v(i,j)*c(i,j)-(1-n4)*v(i,j)*c(i,j+1))*d4*dx

        adv3=(n3*v(i,j-1)*c(i,j-1)+(1-n3)*v(i,j-1)*c(i,j))*d3*dx


	adv=(adv1+adv2+adv3+adv4)/(dx*dy*d(i,j))

	return
	end
