INIT_SCI LDAA	#$30	;see paragraph 3.5.
	 STAA	BAUD	;9600 baud
	 CLR	SCCR1	;clear M for 8 bit ;communication
	 LDAA	#$0C	;TE=1, RE=1
	 STAA	SCCR2	;no interrupts 
	 RTS
	
SCI_REC	 LDAA	SCSR	;read status register
	 ANDA	#$20	;isolate RDRF bit
	 BEQ	SCI_REC	;wait until RDRF is set
	 LDAA	SCDR	;get received character
	 STAA	SOMEWHERE	;and save it
	 RTS		
			
SCI_SEND TAB		;save character to B
SSLOOP	 LDAA	SCSR	;read status register
	 ANDA	#$80	;isolate TDRE
	 BEQ	SSLOOP	;wait until transmitter ;ready
	 STAB	SCDR	;send character
	 RTS		;and return

SCI_REC2 LDAA	SCSR	;read status register
	 ANDA	#$20	;isolate RDRF bit
	 BEQ	FRET	;failure return
	 LDAA	SCDR	;get received character
	 STAA	SOMEWHERE	;and save it
	 SEC		;Set Carry to inform
	 RTS		;the main program
FRET	 CLC		;Clear carry
	 RTS		

SCI_ISR	 LDAA	SCSR	
	 ANDA	#$0E	;Isolate all error flags
	 BNE	SCIERR	;if error, inform the ;main program
	 LDAA	SCDR	;get character
	 STAA	SCIRB	;save it in a buffer
	 INC	QSCI	;true QSCI
	 RTI		;return from interrupt
SCIERR	 LDAA	SCDR	;read SCDR to clear flags
	 STAA	SCIRB	
	 INC	QSCI	;true QSCI
	 INC	QSCIERR	;true error flag
	 RTI		

