;example of using the spi to expand the i/o space
INIT_SPI:			
; Configure MOSI SCK and LD			
	LDI	TMP1(1<<DD_MOSI)|(1<<DD_SCK)|(1<<DD_LD)
	OUT	DDRB,TMP1	
; Init SPI as master device, for 8 bit transmission and
; SCK=CK/16			
	LDI	TMP1,(1<<SPE)|(1<<MSTR)|(1<<SPR0)
	OUT	SPSR,TMP1	
	RET		
;*********************************************************************
;Main program
	.Include "M8def.inc"	
	.Equ	DD_LD=2	;portb,2 LD signal
	.Equ	DD_MOSI=3	;portb,3 MOSI
	.Equ	DD_SCK=5	;portb,5 SCK
	.Def	Tmp1=R16	;define temporary data ;registers
	.Def	Tmp2=R17	
	.Dseg		;DATA segment
BufT:	.Byte	1	;byte to send
BufR:	.Byte	1	;received byte
	.Cseg		;start of CODE segment
	.Org	0	
	Rjmp	Start	
Spi_transfer:		
	Sbis	Spsr,Spif     	;check SPIF
	Ret			;return if still busy
	Sbi	PortB,2		;pulse LD
	Nop		
	Cbi	PortB,2	
	In	Tmp1,Spdr	;Get SPI data from 
;previous read
	Sts	BufR,Tmp1	;save received character
	Out	Spdr,Tmp1     	;start new transmission
	Ret	           
START:			
	LDI	TMP1,LOW(RAMEND)  ;init SP
	OUT	SPL,TMP1	
	LDI	TMP1,HIGH(RAMEND)
	OUT	SPH,TMP1	
	RCALL	INIT_SPI	;init SPI interface
MAIN:			
	RCALL	Spi_Transfer	
; ..... other tasks here			
	RJMP	MAIN	
	
