;Example of using Timer0 of AT90S8535 to generate interrupts every 1ms.
;XTAL=8MHz
	.DEF	TEMP1=R16	;definitions
	.DEF	R_INT=R1	;use r1 only for this ;
	.EQU	KTOVF=131	;interrupt constant to load in TCNT0
			
INIT_T0:
	LDI	TEMP1,$03	; prescaller divide by 64
	OUT	TCCR0,TEMP1	
	LDI	TEMP1,KTOVF	;init TCNT0
	MOV	R_INT,TEMP1	
	OUT	TCNT0,R_INT	
	LDI	TEMP1,$02	
	OUT	TIFR,TEMP1	;clear flag if any
	OUT	TIMSK,TEMP1	;enable interrupt
	RET			;end of initializations

;******The interrupt service routine 
T0_ISR:
	OUT	TCNT0,R_INT	;reload counter
	....		
	RETI			;return from interrupt
