hex_asc:
	push	tmp1
	andi	tmp1,0b00001111
	ldi		op1l,$30
	add		tmp1,op1l
	cpi		tmp1,$3a
	brlo	hexasc1
	ldi		op1l,7
	add		tmp1,op1l
hexasc1:
	mov		tmp2,tmp1
	pop		tmp1
	andi	tmp1,0b11110000
	swap	tmp1
	ldi		op1l,$30
	add		tmp1,op1l
	cpi		tmp1,$3a
	brlo	hexasc2
	ldi		op1l,7
	add		tmp1,op1l
hexasc2:
	ret	
asc_hex:
	subi	tmp1,$30
	cpi		tmp1,$0a
	brlo	exit_aschex
	subi	tmp1,$7
exit_aschex:
	ret
asc_hex_e:
	clc
	mov		tmp2,tmp1
	cpi		tmp1,$30
	brlo	err_ahx
	cpi		tmp1,$3a
	brsh	ahx1
	subi	tmp1,$30
	rjmp	exit_ahx
ahx1:
	cpi		tmp1,$47
	brsh	ahx2
	subi	tmp1,$37
	rjmp	exit_ahx
ahx2:
	cpi		tmp1,$67
	brsh	err_ahx
	subi	tmp1,$57
exit_ahx:
	sec
	ret
err_ahx:
	mov		tmp1,tmp2
	ret


get_cmd:
	clc
	rcall	get_uart	; get chr from uart
	brcc	no_cmd		;if no chr exit
getcmd1:
	lds		op1l,stat_rx	
	tst		op1l
	brne	getcmd11
	cpi		tmp1,stx
	brne	no_cmd
getcmd11:
	get_adr	op1l,buf_rx		;get current position addr in buffer
	inc		op1l			;increment
	sts		stat_rx,op1l	;save new position
	st		x,tmp1			;save chr from uart
	cpi		op1l,pack_len+1	;if len overflow
	brsh	err_cmd			;then error
	cpi		tmp1,eot		;if eot continue
	brne	no_cmd			;else exit
	cpi		op1l,pack_len	;if len too small
	brlo	err_cmd			;then error
	lds		tmp1,buf_rx+2	;get pack addr
	cpi		tmp1,slave_addr	;if no slave addr 
	brne	err_cmd			;error
	mk_crc	buf_rx,pack_len ;make crc	
	lds		op1l,buf_rx+6	;get CRCh
	cp		tmp1,op1l		;if wrong CRC tehn
	brne	gcmd_nak		;then nak
	lds		op1l,buf_rx+7	;get CRCL
	cp		tmp2,op1l		;if wrong CRC
	brne	gcmd_nak		;then nak
	lds		tmp1,buf_rx+1	;get opcode
	cpi		tmp1,s_opc		;if no valid opcode
	brne	gcmd_nak		;then nack
	ldi		tmp2,ack		; if OK
	sts		ack_nak,tmp2			;then ACK
exit_gcmd:
	clr	tmp2
	sts	stat_rx,tmp2
	sec
	ret
gcmd_nak:
	ldi		tmp1,nak		;then NAK
	sts		ack_nak,tmp1
	rjmp	exit_gcmd
err_cmd:
	clr	tmp1
	sts	stat_rx,tmp1	;clear rx buffer
no_cmd:
	clc		
	ret

send:
	lds		op1l,stat_tx ; get tx status
	tst		op1l		 ; if not 0
	brne	send1		; go to next transmision
	sbis	usr,udre	; daca ultimul octet a fost transmis
	rjmp	exit_snd	; atunci
	cbi		portd,2		; 75176 in IN mode
	ret
send1:
	sbi		portd,2		; state 0 - 75176 txd enabled
	ldi		tmp1,pack_len;calculam pozitia in buf_rx
	sub		tmp1,op1l	; pentru caracterul ce urmeaza afi transmis
	get_adr	tmp1,buf_tx
	ld		tmp1,x		;get chr
	rcall	put_uart	;try to transmit
	brcc	exit_snd	;if the transmision s fail then exit
	dec		op1l		; else go to next chr
	sts		stat_tx,op1l ; and save new position
exit_snd:
	ret
	
make_pk:
	ldi		yl,low(buf_tx)	;get buf_tx addr
	ldi		yh,high(buf_tx)
	ldi		tmp1,stx		;put STX
	st		y+,tmp1
	lds		tmp1,ack_nak	; put ack or nak
	st		y+,tmp1
	ldi		tmp1,slave_addr
	st		y+,tmp1			;put SLAVE addr
	ldi		count,3			;no. of data in pack
	lds		tmp3,buf_io		;get io value
makepk1:
	mov		tmp1,tmp3		;
	andi	tmp1,0b00000001	;retinem valoarea curenta
	rcall	hex_asc			;convert to ascii
	st		y+,tmp2			;put in pack
	lsr		tmp3			;next value
	dec		count			;if not redy
	brne	makepk1			;then again
	mk_crc	buf_tx,pack_len	;make CRC
	st		y+,tmp1			;put CRCh
	st		y+,tmp2			;put CRCl
	ldi		tmp1,eot
	st		y,tmp1			;put EOT
	ldi		tmp1,pack_len
	sts		stat_tx,tmp1	;activate transmision
	ret
crc:
	adiw	xh:xl,1	;skip	STX chr
	subi	tmp2,4	;skip	crc high niblle,crc low niblle and EOT
	clr		tmp1
crc1:
	ld		tmp3,x+
	add		tmp1,tmp3
	dec		tmp2
	brne	crc1
	rcall	hex_asc
	ret
