hex_asc:
	push	tmp1
	andi	tmp1,0b00001111
	ldi	op1l,$30
	add	tmp1,op1l
	cpi	tmp1,$3a
	brlo	hexasc1
	ldi	op1l,7
	add	tmp1,op1l
hexasc1:
	mov	tmp2,tmp1
	pop	tmp1
	andi	tmp1,0b11110000
	swap	tmp1
	ldi	op1l,$30
	add	tmp1,op1l
	cpi	tmp1,$3a
	brlo	hexasc2
	ldi	op1l,7
	add	tmp1,op1l
hexasc2:
	ret	
asc_hex:
	subi	tmp1,$30
	cpi	tmp1,$0a
	brlo	exit_aschex
	subi	tmp1,$7
exit_aschex:
	ret
asc_hex_e:
	clc
	mov	tmp2,tmp1
	cpi	tmp1,$30
	brlo	err_ahx
	cpi	tmp1,$3a
	brsh	ahx1
	subi	tmp1,$30
	rjmp	exit_ahx
ahx1:
	cpi	tmp1,$47
	brsh	ahx2
	subi	tmp1,$37
	rjmp	exit_ahx
ahx2:
	cpi	tmp1,$67
	brsh	err_ahx
	subi	tmp1,$57
exit_ahx:
	sec
	ret
err_ahx:
	mov	tmp1,tmp2
	ret


get_cmd:
	clc
	rcall	get_uart	; get chr from uart
	brcc	no_cmd		;if no chr exit
getcmd1:
	lds	op1l,stat_rx
	get_adr	op1l,buf_rx
	inc	op1l
	sts	stat_rx,op1l
	st	x,tmp1	
	cpi	tmp1,eot
	brne	no_cmd
	cpi	op1l,6
	brlo	err_cmd
	mk_crc	buf_rx,6
	lds	op1l,buf_rx+3
	cp	tmp1,op1l
	brne	err_cmd
	lds	op1l,buf_rx+4
	cp	tmp2,op1l
	brne	err_cmd
	lds	tmp1,buf_rx+1
	cpi	tmp1,slave_addr
	brne	err_cmd
	clr	tmp1
	sts	stat_rx,tmp1
	lds	tmp1,buf_rx+2	;get cmd value
	sec
	ret
err_cmd:
	clr	tmp1
	sts	stat_rx,tmp1	;clear rx buffer
no_cmd:
	clc		
	ret
send:
	lds	op1l,stat_tx
	tst	op1l
	brne	send1
	sbis	usr,udre	; a fost transmis
	rjmp	exit_snd	; atunci
	sbi	portd,2		; 75176 in IN mode
	ret
send1:
	cbi	portd,2		; state 0 - 75176 txd enabled
	ldi	tmp1,6
	sub	tmp1,op1l
	get_adr	tmp1,buf_tx
	ld	tmp1,x
	rcall	put_uart
	brcc	exit_snd
	dec	op1l
	sts	stat_tx,op1l
exit_snd:
	ret
	
make_pk:
	ldi	yl,low(buf_tx)
	ldi	yh,high(buf_tx)
	ldi	tmp1,stx
	st	y+,tmp1
	ldi	tmp1,slave_addr
	st	y+,tmp1
	lds	tmp1,buf_io
	rcall	hex_asc
	st	y+,tmp2
	mk_crc	buf_tx,6
	st	y+,tmp1
	st	y+,tmp2
	ldi	tmp1,eot
	st	y,tmp1
	ldi	tmp1,6
	sts	stat_tx,tmp1
	ret
crc:
	adiw	xh:xl,1	;skip	STX chr
	subi	tmp2,4	;skip	crc high niblle,crc low niblle and EOT
	clr	tmp1
crc1:
	ld	tmp3,x+
	add	tmp1,tmp3
	dec	tmp2
	brne	crc1
	rcall	hex_asc
	ret
