            TITLE   DIGITAL AND ANALOG INPUT ROUTINES

* This module is executed every 24 ms. Uses T4MS0
* It reads AN0-AN3, and updates the variables TS, TM, KP, TI
* It reads the status of PA5, PA6 and sets QSTART accordingly

            CODE

            TST     T4MS0
            BNE     END_IO
            LDAA    #6              ;restart timer
            STAA    T4MS0
* read digital input
            LDAA    PORTA           ;read status of the rotary switch
            ANDA    #$1F
            LSRA    
            STAA    SWSTATUS
            LDAA    PORTA
            ANDA    #$60            ;isolate START/STOP buttons
            CMPA    #$60
            BEQ     IN15            ;if no button active, continue
            CMPA    #$20
            BEQ     IN05
            CMPA    #$40
            BEQ     IN10
            BRA     IN15
IN05        LDAA    #$FF            ;START is pressed
            STAA    QSTART
            BRA     IN15
IN10        CLR     QSTART          ;STOP is pressed

* read analog input

IN15        LDAA    ADR1
            STAA    TS
            LDAA    ADR2
            STAA    TM
            LDAA    ADR3
            LSRA    
            LSRA
            LSRA
            LSRA
            STAA    KP              ;consider only the upper nibble
            LDAA    ADR4
            LSRA
            LSRA    
            STAA    TI		    ;retain 6 bits 
            JSR     CERR            ;compute error
            BRA     END_IO

* Init ADC: MULT=1, SCAN=1, group 0
* this subroutine is called once by INIT.ASM

IADC        LDAA    #$80
            STAA    OPTION
            LDAA    #$30
            STAA    ADCTL
            LDAA    #50             ;leave some time before first read
            STAA    T4MS0
            RTS

* compute error ERR=TS-TM
CERR        CLRA
            LDAB    TM
            STD     TEMP
            LDAB    TS
            SUBD    TEMP            ;D=TS-TM. The error is a 16 bit signed integer
            STD     ERR
            RTS

END_IO      EQU     *               ;continue to next task



