            TITLE   HANDLING DTMF DATA


            TST	    DBFULL
            JEQ     END_DTMF	;if buffer not full, nothing to do here

            LDX	    #DTBUF
	    LDAA    0,X
            CMPA    #$0B	;$0B is the DTMF code for *
	    BNE	    DT99	;invalid data in buffer
	    LDAA    1,X		;check next character
	    CMPA    #$01
	    BEQ	    DT10
            CMPA    #$02
	    BEQ	    DT20
	    CMPA    #$03
	    BEQ	    DT30
	    BRA	    DT99	;if opcode <> 1,2,or 3, then invalid
* relay on/off command
DT10	    LDAA    2,X
	    BEQ	    RELOFF
	    CMPA    #$01
	    BEQ	    RELON
	    JMP	    DT99	;any other value is invalid
RELON	    LDAA    PORTA	;relay ON
	    ORAA    #$40
	    STAA    PORTA
	    BRA	    DT90
RELOFF	    LDAA    PORTA
	    ANDA    #$BF
	    STAA    PORTA
	    BRA	    DT90
* define MAXRING
DT20	    LDAA    2,X		;valid values 2-9
	    CMPA    #2
	    BLO	    DT99
	    CMPA    #9
	    BHI	    DT99
	    JSR	    WRMAXRING
	    BRA	    DT90
* close line
DT30	    LDAA    PORTA
	    ANDA    #$7F
	    STAA    PORTA
* valid command executed
DT90	    LDAA    #$03
	    STAA    BSTATUS
DT91	    LDX	    #DTBUF
	    STX	    XDTBUF
	    CLR	    DBFULL
	    JMP	    END_DTMF
* invalid command
DT99	    LDA	    #$01
	    STAA    BSTATUS
	    BRA	    DT91
* WRMAXRING - subroutine to write new value in the EEPROM variable MAXRING

WRMAXRING   LDY	    #MAXRING
	    JSR	    E2BE	;EEPROM byte erase
	    LDX	    #DTBUF
	    LDAA    2,X
	    JSR	    E2W
	    RTS
* E2BE - EEPROM BYTE ERASE. Erase the byte pointed by Y
E2BE	    LDAB   #$16         ;BYTE=1, ERASE=1, EELAT=1
	    STAB   PPROG	
	    STAB   0,Y          ;write operation to latch ;address
	    LDAB   #$17         ;make EEPGM=1
	    STAB   PPROG        ;start Vpp charge pump
	    JSR    DLY10        ;wait 10 ms
	    CLR    PPROG        ;stop Vpp and return to read ;mode
	    RTS	                ;return to main program
* E2W - WRITE BYTE IN A TO THE DESTINATION POINTED BY Y
E2W	    LDAB   #$02         ;BYTE=0, ERASE=0, EELAT=1
	    STAB   PPROG	
	    STAA	0,Y	;write operation to latch the address and data
	    LDAB   #$03         ;make EEPGM=1
	    STAB   PPROG        ;start Vpp charge pump
	    JSR    DLY10        ;wait 10 ms
	    CLR    PPROG        ;stop Vpp and return to read mode
	    RTS	                ;return to main program
* DLY10 - 10 ms delay
DLY10	    PSHX
	    LDX	    #$0D06
DLOOP	    DEX
	    BNE	    DLOOP
	    PULX
	    RTS

* TIC2 interrupt service routine
	    VECTOR_TIC2
	    LDAA    TFLG1
	    ORAA    #$02
	    STAA    TFLG1	  ;clear interruot flag
	    LDAA    #30
	    STAA    T1S1	  ;restart off-hook timer
	    LDAA    PORTD	  ;get DTMF code
	    LSRA
	    LSRA
	    CMPA    #$0A	  ;replace $0A by 0
	    BNE	    TIC210
	    CLRA
TIC210	    LDX     XDTBUF
	    STAA    0,X
	    INX
	    CPX	    #ENDDBUF
	    BHS	    TIC220
	    STX	    XDTBUF
	    CMPA    #$0C	  ;$0C is DTMF code for #
	    BEQ	    TIC220
	    RTI
TIC220	    LDX	    #DTBUF
	    STX	    XDTBUF
	    LDAA    #$FF
	    STAA    DBFULL
	    RTI

END_DTMF    EQU     *


