            TITLE   RING COUNTER AND AUTO ANSWER ROUTINES


* jump to different locations according to the value of RSTATUS

            LDX     #JTAB
            LDAB    RSTATUS
            LSLB
            ABX
            LDX     0,X
            JMP     0,X
* RSTATUS=0 idle status. No ring detected yet
RNG00       TST     QRING
            JEQ     END_RING		;if no ring detected, continue to next task
	    LDAA    #$01		;go to next status
	    STAA    RSTATUS            
	    LDAA    #3
	    STAA    T1S0		;start 3 seconds timer
	    CLR	    QRING
	    JMP	    END_RING
* RSTATUS=1 
RNG10	    TST	    QRING		;check if ring
	    BNE	    RNG15
	    TST	    T1S0
	    JNE	    END_RING
* timer expired and no ring return to RSTATUS=0
	    CLR     RCNT
	    CLR     RSTATUS
	    JMP     END_RING	    
* ring detected before timer expires. Compare to MAXRING
RNG15       LDAA    MAXRING
	    CMPA    #10			;If MAXRING >10, that means not programmed
	    BHS     RNG19
	    CMPA    RCNT
	    BLS     RNG19
* RCNT < MAXRING - keep waiting with RSTATUS=1
	    LDAA    #3
	    STAA    T1S0		;restart timer
	    CLR     QRING
	    JMP     END_RING
* MAXRING has been reached - open line and go to RSTATUS=2
RNG19       LDAA    #$02
            STAA    RSTATUS
            LDAA    PORTA
            ORAA    #$80
	    STAA    PORTA		;answer call
	    CLR     QRING
	    CLR     RCNT
	    LDAA    #30
	    STAA    T1S1
	    JMP	    END_RING
* line is open now - if no DTMF tone is received for 30s, return to RSTATUS=0
RNG20       TST     T1S1
	    BEQ     RNG29
 	    JMP	    END_RING
RNG29	    CLR	    RSTATUS
            CLR     QRING
	    CLR     RCNT
	    LDAA    PORTA
	    ANDA    #$7F
	    STAA    PORTA
	    JMP     END_RING

* TIC3 interrupt service routine
* increment RCNT and true QRING

            VECTOR_TIC3

            LDAA    TFLG1
            ORAA    #$01
            STAA    TFLG1       ;clear interrupt flag
	    INC	    RCNT
	    LDAA    #$FF
	    STAA    QRING
	    RTI


* jump table
JTAB        DW      RNG00
            DW      RNG10
            DW      RNG20

END_RING    EQU     *
            END

