                TITLE       MAIN SYSTEM TIMER

                CODE

TMRMAIN         TST     TIRQ
                JEQ     TMREXIT

                CLR     TIRQ

                DJEQ    T4MS0
                DJEQ    T4MS1
                DJEQ    T4MS2
                DJEQ    T4MS3
                DJEQ    T4MS4
                DJEQ    T4MS5
                DJEQ    T4MS6
                DJEQ    T4MS7

                DEC     CNT100MS
                BEQ     TMR10
                JMP     TMREXIT

TMR10           LDAA    #25             ;reload counter
                STAA    CNT100MS
                DJEQ    T100MS0
                DJEQ    T100MS1
                DJEQ    T100MS2
                DJEQ    T100MS3
                DJEQ    T100MS4
                DJEQ    T100MS5
                DJEQ    T100MS6
                DJEQ    T100MS7

                DEC     CNT1S
                BEQ     TMR20
                JMP     TMREXIT

TMR20           LDAA    #10
                STAA    CNT1S
                DJEQ    T1S0
                DJEQ    T1S1
                DJEQ    T1S2
                DJEQ    T1S3
                DJEQ    T1S4
                DJEQ    T1S5
                DJEQ    T1S6
                DJEQ    T1S7

                DEC     CNT1M
                BEQ     TMR30
                JMP     TMREXIT

TMR30           LDAA    #60
                STAA    CNT1M

                DJEQ    T1M0
                DJEQ    T1M1
                DJEQ    T1M2
                DJEQ    T1M3
                DJEQ    T1M4
                DJEQ    T1M5
                DJEQ    T1M6
                DJEQ    T1M7
                JMP     TMREXIT

********************************************************************
* INIT TIMER
********************************************************************
ITIMER		LDAA	#$40	; clear  OC2F if any.
		STAA	TFLG1
                LDD     TOC2
                ADDD    #8000
                STD     TOC2
		LDAA	#$40
		STAA	TMSK1	; enable TOC2 interrupts.
* clear all timers

                LDX     #T4MS0
                LDAB    #32
IT10            CLR     0,X
                INX
                DECB
                BNE     IT10
                LDAA    #25
                STAA    CNT100MS
                LDAA    #10
                STAA    CNT1S
                LDAA    #60
                STAA    CNT1M

                RTS

*********************************************************************
* TOC2 interrupt service routine
*********************************************************************
*                VECTOR_TOC2

TOC2ISR		LDAA	#$40	
		STAA	TFLG1	; clear TOC2 IRQ
		LDD	TOC2
		ADDD	#8000	; 4 milisecond more
		STD	TOC2	
		INC	TIRQ
		RTI
*********************************************************************
TMREXIT         EQU     *       ; go to next task


                END
