        TITLE SCI ROUTINES

        CODE

ISCI    LDAA	#$30	;see paragraph 3.5
	STAA	BAUD	;9600 baud
	CLR	SCCR1	;clear M for 8 bit communication
	LDAA	SCSR	;clear flags if any
	LDAA	SCDR	
	CLR	QSCI	
	LDAA	#$2C	;RIE=1, TE=1, RE=1
	STAA	SCCR2	;enable receiver interrupts 
        RTS


        VECTOR_SCI

SCI_ISR	LDAA	SCSR	
	ANDA	#$0E	;Isolate all error flags
	BNE	SCIERR	;if error, inform the ;main program
	LDAA	SCDR	;get character
	STAA	SCIRB	;save it in a buffer
	INC	QSCI	;true QSCI
	RTI		;return from interrupt

SCIERR	LDAA	SCDR	;read SCDR to clear flags
	STAA	SCIRB	
        CLR     QSCI
	RTI		

* SENDCH - send character in A to SCI

SENDCH	STAA	SCDR
SC05	LDAA	SCSR
	ANDA	#$80	 	
	BEQ	SC05
	RTS

*------------------------------------------------
* ECHO	send character in A to the comm line
* input: character in A
* if A=CR, then send LF too.
*------------------------------------------------

ECHO	PSHB
	TAB
	JSR	SENDCH
	CMPB	#CR
	BNE	E05
	LDAA	#LF
	JSR	SENDCH
E05	PULB
	RTS


SEND    LDAA    SCIXB
        JSR     ECHO
        LDAA    SCIXB+1
        JSR     ECHO
        LDAA    #$0D        ;CR
        JSR     ECHO
        RTS
