:Convert Tmp1 to ASCII in Tmp1 - High and Tmp2 Low
hex_asc:
	push	tmp1
	andi	tmp1,0b00001111
	ldi	op1l,$30
	add	tmp1,op1l
	cpi	tmp1,$3a
	brlo	hexasc1
	ldi	op1l,7
	add	tmp1,op1l
hexasc1:
	mov	tmp2,tmp1
	pop	tmp1
	andi	tmp1,0b11110000
	swap	tmp1
	ldi	op1l,$30
	add	tmp1,op1l
	cpi	tmp1,$3a
	brlo	hexasc2
	ldi	op1l,7
	add	tmp1,op1l
hexasc2:
	ret	
asc_hex:
	subi	tmp1,$30
	cpi	tmp1,$0a
	brlo	exit_aschex
	subi	tmp1,$7
exit_aschex:
	ret
;Convert ASCII chr from Tmp1 to hex in Tmp1
;Return carry =1 - succes 
;else carry=0 - error
asc_hex_e:
	clc
	mov	tmp2,tmp1
	cpi	tmp1,$30
	brlo	err_ahx
	cpi	tmp1,$3a
	brsh	ahx1
	subi	tmp1,$30
	rjmp	exit_ahx
ahx1:
	cpi	tmp1,$47
	brsh	ahx2
	subi	tmp1,$37
	rjmp	exit_ahx
ahx2:
	cpi	tmp1,$67
	brsh	err_ahx
	subi	tmp1,$57
exit_ahx:
	sec
	ret
err_ahx:
	mov	tmp1,tmp2
	ret

;Get chr from UART 
;Return carry=1 - valid command
;else carry=0 -no command or invalid command
get_cmd:
	rcall	get_uart	; get chr from uart
	brcs	getcmd1		;if no chr exit
	ret
getcmd1:
	clc			
	cpi	tmp1,$30	;else compare with "0" and "7"
	brlo	exit_gcmd
	cpi	tmp1,$38	;if no valid cmd exit
	brsh	exit_gcmd
	sec			;set carry
exit_gcmd:
	ret

;Transmit request value
exec_cmd:
	rcall	put_uartw
	rcall	asc_hex		;convert to hexa
	ldi	xl,low(buf_adc)
	ldi	xh,high(buf_adc)
	clr	tmp2
	add	tmp1,tmp1
	add	xl,tmp1
	adc	xh,tmp2
	adiw	xh:xl,2
	ldi	tmp1,':'
	rcall	put_uartw
	ld	tmp1,-x
	rcall	hex_asc
	rcall	put_uartw
	mov	tmp1,tmp2
	rcall	put_uartw
	ld	tmp1,-x
	rcall	hex_asc
	rcall	put_uartw
	mov	tmp1,tmp2
	rcall	put_uartw
	ldi	tmp1,$0d
	rcall	put_uartw
	ldi	tmp1,$0a
	rcall	put_uartw
	ret