display:
;***** Refresh display buffer first ****
;
;**** Get value from ADC buffer ***
	ldi	xl,low(buf_adc)
	ldi	xh,high(buf_adc)
	ld	tmp2,x+
	ld	tmp1,x
;***** Convert to BCD **************
	rcall	cbcd16
;***** Put BCD in display buffer **
	push	tmp1
	andi	tmp1,$f0
	swap	tmp1
	sts	disp_buf,tmp1
	pop	tmp1
	andi	tmp1,$0f
	sts	disp_buf+1,tmp1
	push	tmp2
	andi	tmp2,$f0
	swap	tmp2
	sts	disp_buf+2,tmp2
	pop	tmp2
	andi	tmp2,$0f
	sts	disp_buf,tmp2
;****** Display routine ***********
;***First check if SPI is free *******
	in	tmp1,spsr
	sbrs	tmp1,spif
	ret		;*** return if not redy
;*** Strobe data in register and make byte for transmision ******
	sbi	portb,ss	;LD 4095 in "1"
	lds	tmp2,dig_pos	;get position	
	cbi	portb,ss	;LD 4095 in "0"
	inc	tmp2		;increment position
	cpi	tmp2,4		;if position is overflow then
	brlo	disp1
	clr	tmp2		;first position
disp1:
	sts	dig_pos,tmp2	;save new position
	ldi	xl,low(disp_buf); display buffer address
	ldi	xh,high(disp_buf)
	clr	tmp1
	add	xl,tmp2
	adc	xh,tmp1
	ld	tmp1,x	;get value (in BCD)
	swap	tmp2		;position is high nibble
	or	tmp1,tmp2	;make byte
	out	spdr,tmp1
	ret
;***** Init SPI, ss pin for 4095 LD signal and dig_pos=0 ***
init_spi:
	sbi	portb,mosi	;mosi is output pin
	sbi	portb,sck	;sck is output pin
	ldi 	tmp1,0b01010011	;SPI-enable, MASTER mode, SCK=f/128
	out	spcr,tmp1
	sbi	ddrb,ss		;LD is output pin
	clr	tmp1
	sts	dig_pos,tmp1	;first digit
	ret