            TITLE   TRIAC GATE CONTROL

* This module contains the interrupt service routines for TIC3 and TOC1
* and the START/STOP control.

            CODE
        

* Init TIC3 timer
* TIC3 interrupt is used to sense the moments when the ac crosses zero

ITIC3       LDAA    #$03
            STAA    TCTL2       ;select both edges of IC3
            LDAA    #$01
            STAA    TFLG1       ;clear IC3F if any
            LDAA    TMSK1
            ORAA    #$01
            STAA    TMSK1       ;enable TIC3 interrupts
            RTS

* TIC3 interrupt service routine
            VECTOR_TIC3

            LDAA    TFLG1
            ORAA    #$01
            STAA    TFLG1       ;clear interrupt flag
            LDX     #TOCTAB
            LDD     VOUT
            ABX
            LDD     0,X
            ADDD    TCNT
            STD     TOC1        ;prepare next interrupt for TOC1
            LDAA    #$80
            ANDA    QSTART      ;enable TOC1 interrupts if QSTART=1
            BEQ     TIC310
            ORAA    TMSK1
            STAA    TMSK1
            RTI
* disable interrupts if QSTART=0
TIC310      LDAA    TMSK1
            ANDA    #$7F
            STAA    TMSK1
            RTI

* TOC1 interrupts. Generate a pulse on PA7 to open the triac

            VECTOR_TOC1

            LDAA    #$80
            STAA    TFLG1       ;clear interrupt flag
            STAA    PORTA
            NOP			;wait a few microseconds
            NOP
            NOP
            NOP
            NOP
            NOP
	    LDAA    TMSK1
	    ANDA    #$7F
	    STAA    TMSK1	;disable TOC1 interrupts
            CLRA
            STAA    PORTA
            RTI

* INITVAR - init variables 

INITVAR     CLR	    QSTART
	    LDAA    #25
	    STAA    T4MS0
	    STAA    T4MS1
            STAA    T4MS2
            LDAA    #10
            STAA    T100MS0
            RTS

* Note: the values in this table are calculated for 50Hz ac.

TOCTAB      DW      18000
            DW      17940
            DW      17880
            DW      17820
            DW      17760
            DW      17680
            DW      17620
            DW      17560
            DW      17500
            DW      17440
            DW      17380
            DW      17320
            DW      17260
            DW      17200
            DW      17140
            DW      17080
            DW      17020
            DW      16960
            DW      16900
            DW      16840
            DW      16780
            DW      16720
            DW      16660
            DW      16600
            DW      16540
            DW      16480
            DW      16420
            DW      16360
            DW      16300
            DW      16240
            DW      16180
            DW      16120
            DW      16060
            DW      16000
            DW      15940
            DW      15880
            DW      15820
            DW      15760
            DW      15700
            DW      15640
            DW      15580
            DW      15520
            DW      15460
            DW      15400
            DW      15340
            DW      15280
            DW      15220
            DW      15160
            DW      15100
            DW      15040
            DW      14980
            DW      14920
            DW      14860
            DW      14800
            DW      14740
            DW      14680
            DW      14620
            DW      14560
            DW      14500
            DW      14440
            DW      14380
            DW      14320
            DW      14260
            DW      14200
            DW      14140
            DW      14080
            DW      14020
            DW      13960
            DW      13900
            DW      13840
            DW      13780
            DW      13720
            DW      13660
            DW      13600
            DW      13540
            DW      13480
            DW      13420
            DW      13360
            DW      13300
            DW      13240
            DW      13180
            DW      13120
            DW      13060
            DW      13000
            DW      12940
            DW      12880
            DW      12820
            DW      12760
            DW      12700
            DW      12640
            DW      12580
            DW      12520
            DW      12460
            DW      12400
            DW      12340
            DW      12280
            DW      12220
            DW      12160
            DW      12100
            DW      12040
            DW      11980
            DW      11920
            DW      11860
            DW      11800
            DW      11740
            DW      11680
            DW      11620
            DW      11560
            DW      11500
            DW      11440
            DW      11380
            DW      11320
            DW      11260
            DW      11200
            DW      11140
            DW      11080
            DW      11020
            DW      10960
            DW      10900
            DW      10840
            DW      10780
            DW      10720
            DW      10660
            DW      10600
            DW      10540
            DW      10480
            DW      10420
            DW      10360
            DW      10300
            DW      10240
            DW      10180
            DW      10120
            DW      10060
            DW      10000
            DW      09940
            DW      09880
            DW      09820
            DW      09760
            DW      09700
            DW      09640
            DW      09580
            DW      09520
            DW      09460
            DW      09400
            DW      09340
            DW      09280
            DW      09220
            DW      09160
            DW      09100
            DW      09040
            DW      08980
            DW      08920
            DW      08860
            DW      08800
            DW      08740
            DW      08680
            DW      08620
            DW      08560
            DW      08500
            DW      08460
            DW      08400
            DW      08340
            DW      08280
            DW      08220
            DW      08160
            DW      08100
            DW      08040
            DW      07980
            DW      07920
            DW      07860
            DW      07800
            DW      07740
            DW      07680
            DW      07620
            DW      07560
            DW      07500
            DW      07440
            DW      07380
            DW      07320
            DW      07260
            DW      07200
            DW      07140
            DW      07080
            DW      07020
            DW      06960
            DW      06900
            DW      06840
            DW      06780
            DW      06720
            DW      06660
            DW      06600
            DW      06540
            DW      06480
            DW      06420
            DW      06360
            DW      06300
            DW      06240
            DW      06180
            DW      06120
            DW      06060
            DW      06000
            DW      05940
            DW      05880
            DW      05820
            DW      05760
            DW      05700
            DW      05640
            DW      05580
            DW      05520
            DW      05460
            DW      05400
            DW      05340
            DW      05280
            DW      05220
            DW      05160
            DW      05100
            DW      05040
            DW      04980
            DW      04920
            DW      04860
            DW      04800
            DW      04740
            DW      04680
            DW      04620
            DW      04560
            DW      04500
            DW      04440
            DW      04380
            DW      04320
            DW      04260
            DW      04200
            DW      04140
            DW      04080
            DW      04020
            DW      03960
            DW      03900
            DW      03840
            DW      03780
            DW      03720
            DW      03660
            DW      03600
            DW      03540
            DW      03480
            DW      03420
            DW      03360
            DW      03300
            DW      03240
            DW      03180
            DW      03120
            DW      03060
            DW      03000
            DW      02940
            DW      02880
            DW      02820
            DW      02760
            DW      02700


            END
