            TITLE   INITIALIZATION MODULE

            CODE

            SEI                 ;disable all interrupts during init sequence
            LDAA    #$0A
            STAA    HPRIO       ;TIC3 has the highest priority
	    LDAA    #$05	;Enable CSPROG
	    STAA    CSCTL	;for a 32k memory
* configure I/O lines
            LDAA    #$E0        ;PA7,PA6,PA5 output
            STAA    DDRA
	    CLR     DDRD        ;PORTD - input
	    LDS     #RAMEND     ;init stack pointer
            JSR     ITIMER      ;init TOC2 timer
	    JSR	    ITIC2	;init TIC2 timer
            JSR     ITIC3       ;init TIC3 timer
            JSR     INITVAR	;init variables
            CLI                 ;enable interrupts
            JMP     END_INIT
****************************************************************
INITVAR     CLR     RCNT
            CLR     RSTATUS
            CLR     DBFULL
            LDX     #DTBUF
            STX     XDTBUF
 	    	CLR	  BCNT
		CLR	  BSTATUS
            RTS

* TIC2 initialization routine
ITIC2       LDAA    TCTL2
	    ANDA    #$F3
	    ORAA    #$04
            STAA    TCTL2       ;select rising edge of IC2
            LDAA    #$02
            STAA    TFLG1       ;clear IC2F if any
            LDAA    TMSK1
            ORAA    #$02
            STAA    TMSK1       ;enable TIC2 interrupts
            RTS

* TIC3 initialization routine
ITIC3       LDAA    #$01
            STAA    TCTL2       ;select rising edge of IC3
            LDAA    #$01
            STAA    TFLG1       ;clear IC3F if any
            LDAA    TMSK1
            ORAA    #$01
            STAA    TMSK1       ;enable TIC3 interrupts
            RTS

END_INIT    EQU     *

            END


