.include	"8535def.inc"
.def	tmp1=r16
.def	tmp2=r17
.equ	mosi=5
.equ	miso=6
.equ	sck=7
.equ	ss=4
.dseg
	.org	$60
disp_buf:	.byte 4
dig_pos:	.byte 1
.cseg
	.org  0
	rjmp	init
;******* *******
init:
; ***** Other initializtion
init_spi:
	sbi	portb,mosi	;mosi is output pin
	sbi	portb,sck	;sck is output pin
	ldi 	tmp1,0b01010011	;SPI-enable, MASTER mode, SCK=f/128
	out	spcr,tmp1
	sbi	ddrb,ss		;LD is output pin
	clr	tmp1
	sts	dig_pos,tmp1	;first digit
main:
;*** Other routines 
	rcall	Display
	rjmp	main

Display:
;***First check if SPI is free *******
	in	tmp1,spsr
	sbrs	tmp1,spif
	ret		;*** return if not redy
;*** Strobe data in register and make byte for transmision ******
	sbi	portb,ss	;LD 4095 in "1"
	lds	tmp2,dig_pos	;get position	
	cbi	portb,ss	;LD 4095 in "0"
	inc	tmp2		;increment position
	cpi	tmp2,4		;if position is overflow then
	brlo	disp1
	clr	tmp2		;first position
disp1:
	sts	dig_pos,tmp2	;save new position
	ldi	xl,low(disp_buf); display buffer address
	ldi	xh,high(disp_buf)
	clr	tmp1
	add	xl,tmp2
	adc	xh,tmp1
	ld	tmp1,x	;get value (in BCD)
	swap	tmp2		;position is high nibble
	or	tmp1,tmp2	;make byte
	out	spdr,tmp1
	ret
