#include "de.h"
#include "math.h"

//------global variable for the objective function--------------
float gfa_bound[21];

//------objective function---------------------------------------

t_pop evaluate(int i_D, t_pop t_tmp, long *l_nfeval, t_pop *tpa_array, int i_NP)
/**C*F****************************************************************
**                                                                  
** Function       :t_pop evaluate(int i_D, t_pop t_tmp, long *l_nfeval,
**                                t_pop *tpa_array, int i_NP)                                        
**                                                                  
** Author         :Rainer Storn                                     
**                                                                  
** Description    :Evaluates the actual cost function (objective function).
**                 In this case: Filter design problem of chapter "Problem Domains"
**                 where the state variable filter structure multipliers
**                 must be found from the multipliers of the second canonic
**                 structure.                 
**                                                                  
** Functions      :-                                                
**                                                                  
** Globals        :- 
**                                                                  
** Parameters     :i_D         (I)    number of parameters
**                 t_tmp       (I)    parameter vector
**                 l_nfeval   (I/O)   counter for function evaluations
**                 tpa_array   (I)    pointer to current population (not needed here)
**                 i_NP   	   (I)    number of population members (not needed here)   
**                                                                  
** Preconditions  :-                     
**                                                                  
** Postconditions :- 
**
** Return Value   :TRUE if trial vector wins, FALSE otherwise.                                            
**                                                                  
***C*F*E*************************************************************/
{
   int   i,j;
   float result;
   float d1, d2, e1, e2, e3, a11, a12, a21, a22, r[5];
   float a0, a1, a2, b1, b2;

   a0 = 0.015608325640383633;
   a1 = 0.015608325640383633*0.60504150390625;
   a2 = 0.015608325640383633*1.26910400390625;
   b1 = -1.20703125;
   b2 = 0.75250244140625;

   (*l_nfeval)++;

   d1 = t_tmp.fa_vector[0];
   //d1 = 1;
   d2 = t_tmp.fa_vector[1]; 
   //d2 = 1;
   e1 = t_tmp.fa_vector[2]; 
   e2 = t_tmp.fa_vector[3]; 
   e3 = t_tmp.fa_vector[4]; 

   a11 = t_tmp.fa_vector[5]; 
   a12 = t_tmp.fa_vector[6]; 
   a21 = t_tmp.fa_vector[7]; 
   a22 = t_tmp.fa_vector[8]; 


   r[0] = -a11 - a22 - b1;
   r[1] = a11*a22 - a21*a12 - b2;
   r[2] = e3 - a0;
   r[3] = e3*(-a11 - a22) + e1*d1 + e2*d2 - a1;
   r[4] = e3*(a11*a22 - a21*a12) + e1*d2*a12 + e2*d1*a21 - e2*d2*a11 - e1*d1*a22 - a2;


   result = r[0]*r[0]+r[1]*r[1]+r[2]*r[2]+r[3]*r[3]+r[4]*r[4];

   t_tmp.fa_cost[0] = result;


   return(t_tmp);
}

int left_vector_wins(t_pop trial, t_pop target)
/**C*F****************************************************************
**                                                                  
** Function       :int left_vector_wins(t_pop t_trial, t_pop t_target)                                        
**                                                                  
** Author         :Rainer Storn                                     
**                                                                  
** Description    :Selection criterion of DE. Decides when the trial
**                 vector wins over the target vector.                 
**                                                                  
** Functions      :-                                                
**                                                                  
** Globals        :-                                                
**                                                                  
** Parameters     :t_trial    (I)   trial vector
**                 t_target   (I)   target vector   
**                                                                  
** Preconditions  :-                     
**                                                                  
** Postconditions :- 
**
** Return Value   :TRUE if trial vector wins, FALSE otherwise.                                            
**                                                                  
***C*F*E*************************************************************/
{
	if (trial.fa_cost[0] <= target.fa_cost[0]) return(TRUE);
	else return(FALSE);

}

