/***************************************************************
**                                                            **
**   Examples for index generation ex [0, i_Np-1], where i_Np **
**   is the population size.                                  **
**                                                            **
**                  Rainer Storn, 2004                        **
**                                                            **
***************************************************************/

//----Includes--------------------------------------------------
#include <stdio.h>

//----Defines---------------------------------------------------
#define NPMAX    100     //population size

//----Globals---------------------------------------------------
int gia_hist[NPMAX] = {0};

//----Function definitions--------------------------------------

unsigned int rand15a(unsigned long *ulp_seed)
//Generates random numbers ex [0,2^15-1], so
//it is suited as a fixed point random number
//in 1.15 format.
//Initialize *ulp_seed with 1 (for example)
{
   *ulp_seed = *ulp_seed*1664525 + 1013904223;
   return(unsigned int)((*ulp_seed)& 32767);//modulo 2^15
}

unsigned int randNa(unsigned long *ulp_seed, unsigned int ui_N)
//Generates random numbers ex [0,ui_N-1] with ui_N being a
//power of two.
{
   *ulp_seed = *ulp_seed*1103515245 + 12345;
   return(unsigned int)((*ulp_seed>>16)&(ui_N-1));//modulo ui_N
}

unsigned int randNb(unsigned long *ulp_seed, unsigned int ui_N)
//Generates random numbers ex [0,ui_N-1] with ui_N being a
//power of two.
{
   *ulp_seed = *ulp_seed*1664525 + 1013904223;
   return(unsigned int)((*ulp_seed)&(ui_N-1));//modulo ui_N
}


int rndindx(unsigned long *ulp_seed, unsigned int ui_N, int i_Np)
{  //---Substitute for rand()*i_Np.----------------------------
   //---ui_N must be chosen to be 2^(floor(log2(i_Np))+1)------
   //---i.e. ui_N is a power of two equal or greater i_Np.-----
   //---Advantage: No floating computation, little storage.----
   int  i_rnd_indx;
   i_rnd_indx = -1;//allow while loop to be entered
   while ((i_rnd_indx < 0) | (i_rnd_indx > (i_Np-1)))
   {
      i_rnd_indx = (int)randNa(ulp_seed,ui_N);
   }
   return (i_rnd_indx);
}

//----Main program----------------------------------------------
void main(void)
{
	unsigned long ul_seed = 123456;
	int   i, i_Np, i_Np2, i_res, i_max;

	i_Np  = 7;
	i_Np2 = 1;
	while (i_Np2 < i_Np) //power of two which is >= i_Np
	{
		i_Np2 = i_Np2*2;
	}
	printf("i_Np2 = %d\n",i_Np2);

	//---Sanity check--------------------------------------------
	if (i_Np > NPMAX)
	{
		printf("Error! i_Np=%d is > NPMAX=%d\n",i_Np,NPMAX);
		return;
	}

	//---Initialize the histogram array--------------------------
	for (i=0; i<i_Np; i++)
	{
		gia_hist[i] = 0;
	}

	//---Generate indexes----------------------------------------
	i_max = 500*i_Np;

	for (i=0; i<i_max; i++)
	{
		i_res = rndindx(&ul_seed,i_Np2,i_Np);
		gia_hist[i_res] += 1; //increment histogram entry
	}

	//---Analyze histogram---------------------------------------
	for (i=0; i<i_Np; i++)
	{
		printf("histogram[%d]=%d\n",i,gia_hist[i]);
	}

}
