/***************************************************************
**                                                            **
**   Examples for some simple random number generators.       **
**                  Rainer Storn, 2004                        **
**                                                            **
***************************************************************/

//----Includes--------------------------------------------------
#include <stdio.h>
#include <math.h>

//----Defines---------------------------------------------------
#define PI  3.14159265
#define USE_FLOAT

//----Function definitions--------------------------------------

float rand01(float *fp_seed)
//Generates random numbers ex [0,1].
//Initialize *fp_seed with 4.0 (for example)
{
   float f_x;
   f_x = *fp_seed + PI;
   f_x = f_x*f_x*f_x*f_x*f_x; 
   *fp_seed = f_x - floor(f_x);
   return(*fp_seed);
}

unsigned int rand15(unsigned long *ulp_seed)
//Generates random numbers ex [0,2^15-1], so
//it is suited as a fixed point random number
//in 1.15 format.
//Initialize *ulp_seed with 1 (for example)
{
   *ulp_seed = *ulp_seed*1103515245 + 12345;
   return(unsigned int)((*ulp_seed>>16)& 32767);//modulo 2^15
}

unsigned int rand15a(unsigned long *ulp_seed)
//Generates random numbers ex [0,2^15-1], so
//it is suited as a fixed point random number
//in 1.15 format.
//Initialize *ulp_seed with 1 (for example)
{
   *ulp_seed = *ulp_seed*1664525 + 1013904223;
   return(unsigned int)((*ulp_seed)& 32767);//modulo 2^15
}

//----Main program----------------------------------------------

void main(void)
{
	float f_seed = 4.0;
	float f_res, f_sum;
	unsigned long ul_seed = 123456;
	unsigned int  ui_res;
	int   i, i_max;

	i_max = 5000;
	f_sum = 0.0;

	for (i=0; i<i_max; i++)
	{
#ifdef USE_FLOAT
		f_res = rand01(&f_seed);
#else
        //ui_res = rand15(&ul_seed);
		ui_res = rand15a(&ul_seed);
		f_res  = (float)ui_res/32768;
#endif//USE_FLOAT
		printf("%f\n",f_res);
		f_sum += f_res;

	}
	printf("Mean value: %f\n",f_sum/((float)i_max));
}